/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina;

import fr.ens.biologie.genomique.kenetre.illumina.CSVUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public class DemultiplexStats {
    private List<Entry> entries = new ArrayList<Entry>();

    public List<Entry> entries() {
        return Collections.unmodifiableList(this.entries);
    }

    public DemultiplexStats(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public DemultiplexStats(InputStream in) throws IOException {
        Objects.requireNonNull(in);
        try (InputStreamReader reader = new InputStreamReader(in);){
            for (CSVRecord record : CSVFormat.RFC4180.builder().setIgnoreEmptyLines(true).setHeader(new String[0]).setSkipHeaderRecord(true).setSkipHeaderRecord(true).build().parse((Reader)reader)) {
                this.entries.add(new Entry(record));
            }
        }
    }

    public static class Entry {
        private final int lane;
        private final String sampleID;
        private final String index;
        private final int readCount;
        private final int perfectIndexReadCount;
        private final int oneMismatchIndexReadCount;
        private final long q30BaseCount;
        private final double meanPFQualityScore;
        private final int twoMismatchIndexReadCount;
        private final double readsPercent;
        private final double perfectIndexreadsPercent;
        private final double oneMismatchIndexReadPercent;
        private final double twoMismatchIndexReadPercent;

        public int getLane() {
            return this.lane;
        }

        public String getSampleID() {
            return this.sampleID;
        }

        public String getIndex() {
            return this.index;
        }

        public int getReadCount() {
            return this.readCount;
        }

        public int getPerfectIndexReadCount() {
            return this.perfectIndexReadCount;
        }

        public int getOneMismatchIndexReadCount() {
            return this.oneMismatchIndexReadCount;
        }

        public long getQ30BaseCount() {
            return this.q30BaseCount;
        }

        public double getMeanPFQualityScore() {
            return this.meanPFQualityScore;
        }

        public int getTwoMismatchIndexReadCount() {
            return this.twoMismatchIndexReadCount;
        }

        public double getReadsPercent() {
            return this.readsPercent;
        }

        public double getPerfectIndexreadsPercent() {
            return this.perfectIndexreadsPercent;
        }

        public double getOneMismatchIndexReadPercent() {
            return this.oneMismatchIndexReadPercent;
        }

        public double getTwoMismatchIndexReadPercent() {
            return this.twoMismatchIndexReadPercent;
        }

        private Entry(CSVRecord record) {
            this.lane = CSVUtils.parseInt(record, "Lane", -1);
            this.sampleID = CSVUtils.parseString(record, "SampleID", "");
            this.index = CSVUtils.parseString(record, "Index", "");
            this.readCount = CSVUtils.parseInt(record, "# Reads", -1);
            this.perfectIndexReadCount = CSVUtils.parseInt(record, "# Perfect Index Reads", -1);
            this.oneMismatchIndexReadCount = CSVUtils.parseInt(record, "# One Mismatch Index Reads", -1);
            this.q30BaseCount = CSVUtils.parseLong(record, "# of >= Q30 Bases (PF)", -1L);
            this.meanPFQualityScore = CSVUtils.parseDouble(record, "Mean Quality Score (PF)", Double.NaN);
            this.twoMismatchIndexReadCount = CSVUtils.parseInt(record, "# Two Mismatch Index Reads", -1);
            this.readsPercent = CSVUtils.parseDouble(record, "% Reads", Double.NaN);
            this.perfectIndexreadsPercent = CSVUtils.parseDouble(record, "% Perfect Index Reads", Double.NaN);
            this.oneMismatchIndexReadPercent = CSVUtils.parseDouble(record, "% One Mismatch Index Reads", Double.NaN);
            this.twoMismatchIndexReadPercent = CSVUtils.parseDouble(record, "% Two Mismatch Index Reads", Double.NaN);
        }
    }
}

