/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina;

import fr.ens.biologie.genomique.kenetre.illumina.CSVUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;

public class QualityMetrics {
    private List<Entry> entries = new ArrayList<Entry>();

    public List<Entry> entries() {
        return Collections.unmodifiableList(this.entries);
    }

    public QualityMetrics(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public QualityMetrics(InputStream in) throws IOException {
        Objects.requireNonNull(in);
        try (InputStreamReader reader = new InputStreamReader(in);){
            for (CSVRecord record : CSVFormat.RFC4180.builder().setIgnoreEmptyLines(true).setHeader(new String[0]).setSkipHeaderRecord(true).setSkipHeaderRecord(true).build().parse((Reader)reader)) {
                this.entries.add(new Entry(record));
            }
        }
    }

    public static class Entry {
        private final int lane;
        private final String sampleID;
        private final String index;
        private final String index2;
        private final int readNumber;
        private final long yield;
        private final long yieldQ30;
        private final long qualityScoreSum;
        private final double meanQualityScorePF;
        private final double q30Percent;

        public int getLane() {
            return this.lane;
        }

        public String getSampleID() {
            return this.sampleID;
        }

        public String getIndex() {
            return this.index;
        }

        public String getIndex2() {
            return this.index2;
        }

        public int getReadNumber() {
            return this.readNumber;
        }

        public long getYield() {
            return this.yield;
        }

        public long getYieldQ30() {
            return this.yieldQ30;
        }

        public long getQualityScoreSum() {
            return this.qualityScoreSum;
        }

        public double getMeanQualityScorePF() {
            return this.meanQualityScorePF;
        }

        public double getQ30Percent() {
            return this.q30Percent;
        }

        private Entry(CSVRecord record) {
            this.lane = CSVUtils.parseInt(record, "Lane", -1);
            this.sampleID = CSVUtils.parseString(record, "SampleID", "");
            this.index = CSVUtils.parseString(record, "index", "");
            this.index2 = CSVUtils.parseString(record, "index2", "");
            this.readNumber = CSVUtils.parseInt(record, "ReadNumber", -1);
            this.yield = CSVUtils.parseLong(record, "Yield", -1L);
            this.yieldQ30 = CSVUtils.parseLong(record, "YieldQ30", -1L);
            this.qualityScoreSum = CSVUtils.parseLong(record, "QualityScoreSum", -1L);
            this.meanQualityScorePF = CSVUtils.parseDouble(record, "Mean Quality Score (PF)", Double.NaN);
            this.q30Percent = CSVUtils.parseDouble(record, "% Q30", Double.NaN);
        }
    }
}

