/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.kenetre.KenetreRuntimeException;
import fr.ens.biologie.genomique.kenetre.util.XMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RunInfo {
    private final String id;
    private final int number;
    private final String flowCell;
    private final String instrument;
    private final String date;
    private final List<Read> reads;
    private final FlowCellLayout flowCellLayout;
    private final List<Integer> alignToPhix;
    private final List<String> imageChannels;

    public static RunInfo parse(String filepath) throws ParserConfigurationException, SAXException, IOException {
        Objects.requireNonNull(filepath, "RunInfo.xml path cannot be null");
        return RunInfo.parse(new File(filepath));
    }

    public static RunInfo parse(File file) throws ParserConfigurationException, SAXException, IOException {
        Objects.requireNonNull(file, "RunInfo.xml file cannot be null");
        Preconditions.checkArgument((boolean)file.isFile(), (Object)"RunInfo.xml does not exists or is not a file");
        return RunInfo.parse(new FileInputStream(file));
    }

    public static RunInfo parse(InputStream is) throws ParserConfigurationException, SAXException, IOException {
        Objects.requireNonNull(is, "RunInfo.xml input stream cannot be null");
        try (InputStream in = is;){
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(in);
            doc.getDocumentElement().normalize();
            RunInfo runInfo = RunInfo.parse(doc);
            return runInfo;
        }
    }

    private static RunInfo parse(Document document) {
        for (Element e : XMLUtils.getElementsByTagName((Document)document, (String)"RunInfo")) {
            List elements = XMLUtils.getElementsByTagName((Element)e, (String)"Run");
            if (elements.isEmpty()) continue;
            Element runElement = (Element)elements.get(0);
            String id = null;
            int number = -1;
            block9: for (String name : XMLUtils.getAttributeNames((Element)runElement)) {
                String value = runElement.getAttribute(name);
                switch (name) {
                    case "Id": {
                        id = value;
                        continue block9;
                    }
                    case "Number": {
                        number = Integer.parseInt(value);
                        continue block9;
                    }
                }
                throw new KenetreRuntimeException("in RunInfo unvalid value for name attribute on run tag.");
            }
            String flowCell = XMLUtils.getTagValue((Element)runElement, (String)"Flowcell");
            String instrument = XMLUtils.getTagValue((Element)runElement, (String)"Instrument");
            String date = XMLUtils.getTagValue((Element)runElement, (String)"Date");
            List<Read> readList = RunInfo.extractReadData(runElement);
            FlowCellLayout layout = RunInfo.extractFlowcellElement(runElement);
            List<Integer> lanesWithPhiX = RunInfo.extractAlignToPhiXElement(runElement, layout.laneCount);
            List<String> imageChannels = RunInfo.extractImageChannels(runElement);
            return new RunInfo(id, number, flowCell, instrument, date, readList, layout, lanesWithPhiX, imageChannels);
        }
        throw new KenetreRuntimeException("No \"Run\" tag found in RunInfo.xml");
    }

    private static List<String> extractImageChannels(Element runElement) {
        ArrayList<String> result = new ArrayList<String>();
        if (XMLUtils.getElementsByTagName((Element)runElement, (String)"ImageChannels") == null) {
            return result;
        }
        for (Element e2 : XMLUtils.getElementsByTagName((Element)runElement, (String)"ImageChannels")) {
            for (Element name : XMLUtils.getElementsByTagName((Element)e2, (String)"Name")) {
                result.add(name.getTextContent());
            }
        }
        return result;
    }

    private static List<Read> extractReadData(Element runElement) {
        ArrayList<Read> result = new ArrayList<Read>();
        int readCount = 0;
        for (Element e2 : XMLUtils.getElementsByTagName((Element)runElement, (String)"Reads")) {
            for (Element e3 : XMLUtils.getElementsByTagName((Element)e2, (String)"Read")) {
                int readNumber = 0;
                int readNumberCycles = 0;
                boolean readIndexedRead = false;
                ++readCount;
                block14: for (String name : XMLUtils.getAttributeNames((Element)e3)) {
                    String value = e3.getAttribute(name);
                    switch (name) {
                        case "Number": {
                            readNumber = Integer.parseInt(value);
                            continue block14;
                        }
                        case "NumCycles": {
                            readNumberCycles = Integer.parseInt(value);
                            continue block14;
                        }
                        case "IsIndexedRead": {
                            readIndexedRead = "Y".equals(value.toUpperCase().trim());
                            continue block14;
                        }
                        case "IsReverseComplement": {
                            continue block14;
                        }
                    }
                    throw new KenetreRuntimeException("in RunInfo unvalid value for name attribute on read tag.");
                }
                Read read = new Read(readNumber == 0 ? readCount : readNumber, readNumberCycles, readIndexedRead);
                result.add(read);
            }
        }
        return result;
    }

    private static FlowCellLayout extractFlowcellElement(Element runElement) {
        int laneCount = -1;
        int surfaceCount = -1;
        int swathCount = -1;
        int tileCount = -1;
        int sectionPerLane = -1;
        int lanePerSection = -1;
        for (Element e2 : XMLUtils.getElementsByTagName((Element)runElement, (String)"FlowcellLayout")) {
            block17: for (String name : XMLUtils.getAttributeNames((Element)e2)) {
                int value = Integer.parseInt(e2.getAttribute(name));
                switch (name) {
                    case "LaneCount": {
                        laneCount = value;
                        continue block17;
                    }
                    case "SurfaceCount": {
                        surfaceCount = value;
                        continue block17;
                    }
                    case "SwathCount": {
                        swathCount = value;
                        continue block17;
                    }
                    case "TileCount": {
                        tileCount = value;
                        continue block17;
                    }
                    case "SectionPerLane": {
                        sectionPerLane = value;
                        continue block17;
                    }
                    case "LanePerSection": {
                        lanePerSection = value;
                        continue block17;
                    }
                }
                throw new KenetreRuntimeException("in RunInfo unvalid value for name attribute FlowcellLayout tag.");
            }
        }
        return new FlowCellLayout(laneCount, surfaceCount, swathCount, tileCount, sectionPerLane, lanePerSection);
    }

    private static List<Integer> extractAlignToPhiXElement(Element runElement, int flowCellLaneCount) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (RunInfo.isElementExistsByTagName(runElement, "AlignToPhiX")) {
            for (Element e2 : XMLUtils.getElementsByTagName((Element)runElement, (String)"AlignToPhiX")) {
                for (Element e3 : XMLUtils.getElementsByTagName((Element)e2, (String)"Lane")) {
                    result.add(Integer.parseInt(e3.getTextContent()));
                }
            }
        }
        return result;
    }

    public int getTilesCount() {
        if (this.flowCellLayout.sectionPerLane > 0) {
            return this.flowCellLayout.getNextseqTilesCount();
        }
        return this.flowCellLayout.getHiseqTilesCount();
    }

    public String getId() {
        return this.id;
    }

    public int getNumber() {
        return this.number;
    }

    public String getFlowCell() {
        return this.flowCell;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public String getDate() {
        return this.date;
    }

    public List<Read> getReads() {
        return Collections.unmodifiableList(this.reads);
    }

    public int getFlowCellLaneCount() {
        return this.flowCellLayout.laneCount;
    }

    public int getFlowCellSurfaceCount() {
        return this.flowCellLayout.surfaceCount;
    }

    public int getFlowCellSwathCount() {
        return this.flowCellLayout.swathCount;
    }

    public int getFlowCellTileCount() {
        return this.flowCellLayout.tileCount;
    }

    public int getFlowCellSectionPerLane() {
        return this.flowCellLayout.sectionPerLane;
    }

    public int getFlowCellLanePerSection() {
        return this.flowCellLayout.lanePerSection;
    }

    public List<Integer> getAlignToPhix() {
        return Collections.unmodifiableList(this.alignToPhix);
    }

    public List<String> getImageChannels() {
        return Collections.unmodifiableList(this.imageChannels);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", number=" + this.number + ", flowCell=" + this.flowCell + ", instrument=" + this.instrument + ", date=" + this.date + ", reads=" + this.reads + ", flowCellLaneCount=" + this.flowCellLayout.laneCount + ", flowCellSurfaceCount=" + this.flowCellLayout.surfaceCount + ", flowCellSwathCount=" + this.flowCellLayout.swathCount + ", flowCellTileCount=" + this.flowCellLayout.tileCount + ", alignToPhix=" + this.alignToPhix + "}";
    }

    public static boolean isElementExistsByTagName(Element element, String tagName) {
        if (element == null || tagName == null || tagName.isEmpty()) {
            return false;
        }
        NodeList res = element.getChildNodes();
        for (int i = 0; i < res.getLength(); ++i) {
            Element elem;
            Node node = res.item(i);
            if (node.getNodeType() != 1 || !(elem = (Element)node).getTagName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    private RunInfo(String id, int number, String flowCell, String instrument, String date, List<Read> readList, FlowCellLayout layout, List<Integer> alignToPhiX, List<String> imageChannels) {
        Objects.requireNonNull(id, "Run id argument cannot be null");
        Preconditions.checkArgument((number > 0 ? 1 : 0) != 0, (Object)("Run number must be greater than 0: " + number));
        Objects.requireNonNull(flowCell, "Flowcell id argument cannot be null");
        Objects.requireNonNull(instrument, "Instrument id argument cannot be null");
        Objects.requireNonNull(date, "date argument cannot be null");
        Objects.requireNonNull(readList, "readList argument cannot be null");
        Objects.requireNonNull(layout, "layout argument cannot be null");
        Objects.requireNonNull(alignToPhiX, "alignToPhiX argument cannot be null");
        Objects.requireNonNull(imageChannels, "imageChannels argument cannot be null");
        this.id = id;
        this.number = number;
        this.flowCell = flowCell;
        this.instrument = instrument;
        this.date = date;
        this.reads = readList;
        this.flowCellLayout = layout;
        this.alignToPhix = alignToPhiX;
        this.imageChannels = imageChannels;
    }

    private static class FlowCellLayout {
        private final int laneCount;
        private final int surfaceCount;
        private final int swathCount;
        private final int tileCount;
        private final int sectionPerLane;
        private final int lanePerSection;

        private int getNextseqTilesCount() {
            return this.surfaceCount * this.swathCount * this.tileCount * this.sectionPerLane;
        }

        private int getHiseqTilesCount() {
            return this.surfaceCount * this.swathCount * this.tileCount;
        }

        private FlowCellLayout(int laneCount, int surfaceCount, int swathCount, int tileCount, int sectionPerLane, int lanePerSection) {
            Preconditions.checkArgument((laneCount > 0 ? 1 : 0) != 0, (Object)"laneCount has not been defined in RunInfo.xml");
            Preconditions.checkArgument((surfaceCount > 0 ? 1 : 0) != 0, (Object)"surfaceCount has not been defined in RunInfo.xml");
            Preconditions.checkArgument((swathCount > 0 ? 1 : 0) != 0, (Object)"swathCount has not been defined in RunInfo.xml");
            Preconditions.checkArgument((tileCount > 0 ? 1 : 0) != 0, (Object)"tileCount has not been defined in RunInfo.xml");
            this.laneCount = laneCount;
            this.surfaceCount = surfaceCount;
            this.swathCount = swathCount;
            this.tileCount = tileCount;
            this.sectionPerLane = sectionPerLane;
            this.lanePerSection = lanePerSection;
        }
    }

    public static class Read {
        private final int number;
        private final int numberCycles;
        private final boolean indexedRead;

        public int getNumber() {
            return this.number;
        }

        public int getNumberCycles() {
            return this.numberCycles;
        }

        public boolean isIndexedRead() {
            return this.indexedRead;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{number=" + this.number + ", numberCycles=" + this.numberCycles + ", indexedRead=" + this.indexedRead + "}";
        }

        private Read(int number, int numberCycles, boolean indexedRead) {
            this.number = number;
            this.numberCycles = numberCycles;
            this.indexedRead = indexedRead;
        }
    }
}

