/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.illumina.interop.AbstractBinaryFileReader;
import fr.ens.biologie.genomique.kenetre.illumina.interop.Metric;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class ErrorMetric
extends Metric {
    private final int laneNumber;
    private final long tileNumber;
    private final int cycleNumber;
    private final float errorRate;
    private final int numberPerfectReads;
    private final int numberReadsOneError;
    private final int numberReadsTwoErrors;
    private final int numberReadsThreeErrors;
    private final int numberReadsFourErrors;
    private final float fractionOfReadAdapterTrimmed;

    public int getLaneNumber() {
        return this.laneNumber;
    }

    public long getTileNumber() {
        return this.tileNumber;
    }

    public int getCycleNumber() {
        return this.cycleNumber;
    }

    public float getErrorRate() {
        return this.errorRate;
    }

    public int getNumberPerfectReads() {
        return this.numberPerfectReads;
    }

    public int getNumberReadsOneError() {
        return this.numberReadsOneError;
    }

    public int getNumberReadsTwoErrors() {
        return this.numberReadsTwoErrors;
    }

    public int getNumberReadsThreeErrors() {
        return this.numberReadsThreeErrors;
    }

    public int getNumberReadsFourErrors() {
        return this.numberReadsFourErrors;
    }

    public float getPhiXAdapterRate() {
        return this.fractionOfReadAdapterTrimmed;
    }

    @Override
    public List<String> fieldNames() {
        return Arrays.asList("Lane", "Tile", "Cycle", "ErrorRate", "PhiXAdapterRate");
    }

    @Override
    public List<Class<?>> fieldTypes() {
        return Arrays.asList(Integer.class, Integer.class, Integer.class, Float.class, Float.class);
    }

    @Override
    public List<Number> values() {
        return Arrays.asList(this.getLaneNumber(), this.getTileNumber(), this.getCycleNumber(), Float.valueOf(this.getErrorRate()), Float.valueOf(this.fractionOfReadAdapterTrimmed));
    }

    public String toString() {
        return String.format("%s\t%s\t%s\t%.2f\t%s\t%s\t%s\t%s\t%s", this.laneNumber, this.tileNumber, this.cycleNumber, Float.valueOf(this.errorRate), this.numberPerfectReads, this.numberReadsOneError, this.numberReadsTwoErrors, this.numberReadsThreeErrors, this.numberReadsFourErrors);
    }

    ErrorMetric(int version, ByteBuffer bb) {
        this.name = "Error";
        this.version = version;
        this.laneNumber = AbstractBinaryFileReader.uShortToInt(bb);
        this.tileNumber = version > 3 ? AbstractBinaryFileReader.uIntToLong(bb) : (long)AbstractBinaryFileReader.uShortToInt(bb);
        this.cycleNumber = AbstractBinaryFileReader.uShortToInt(bb);
        this.errorRate = bb.getFloat();
        switch (version) {
            case 3: {
                this.numberPerfectReads = bb.getInt();
                this.numberReadsOneError = bb.getInt();
                this.numberReadsTwoErrors = bb.getInt();
                this.numberReadsThreeErrors = bb.getInt();
                this.numberReadsFourErrors = bb.getInt();
                this.fractionOfReadAdapterTrimmed = Float.NaN;
                break;
            }
            case 4: {
                this.numberPerfectReads = -1;
                this.numberReadsOneError = -1;
                this.numberReadsTwoErrors = -1;
                this.numberReadsThreeErrors = -1;
                this.numberReadsFourErrors = -1;
                this.fractionOfReadAdapterTrimmed = Float.NaN;
                break;
            }
            case 5: {
                this.numberPerfectReads = -1;
                this.numberReadsOneError = -1;
                this.numberReadsTwoErrors = -1;
                this.numberReadsThreeErrors = -1;
                this.numberReadsFourErrors = -1;
                this.fractionOfReadAdapterTrimmed = bb.getFloat();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown version: " + version);
            }
        }
    }
}

