/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.illumina.interop.AbstractBinaryFileReader;
import fr.ens.biologie.genomique.kenetre.illumina.interop.Metric;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class ExtendedTileMetric
extends Metric {
    private int laneNumber;
    private long tileNumber;
    private float clusterCountcOccupied;
    private float upperLeftX;
    private float upperLeftY;

    public int getLaneNumber() {
        return this.laneNumber;
    }

    public long getTileNumber() {
        return this.tileNumber;
    }

    public float getClusterCountOccupied() {
        return this.clusterCountcOccupied;
    }

    public float getUpperLeftX() {
        return this.upperLeftX;
    }

    public float getUpperLeftY() {
        return this.upperLeftY;
    }

    @Override
    public List<String> fieldNames() {
        if (this.version < 3) {
            return Arrays.asList("Lane", "Tile", "OccupiedCount");
        }
        return Arrays.asList("Lane", "Tile", "OccupiedCount", "Upper Left X", "Upper Left Y");
    }

    @Override
    public List<Number> values() {
        if (this.version < 3) {
            return Arrays.asList(this.laneNumber, this.tileNumber, Float.valueOf(this.clusterCountcOccupied));
        }
        return Arrays.asList(this.laneNumber, this.tileNumber, Float.valueOf(this.clusterCountcOccupied), Float.valueOf(this.upperLeftX), Float.valueOf(this.upperLeftY));
    }

    @Override
    public List<Class<?>> fieldTypes() {
        if (this.version < 3) {
            return Arrays.asList(Integer.class, Integer.class, Float.class);
        }
        return Arrays.asList(Integer.class, Integer.class, Float.class, Float.class, Float.class);
    }

    private static float parseClusterCountV1(ByteBuffer bb) {
        int code = AbstractBinaryFileReader.uShortToInt(bb);
        float value = bb.getFloat();
        switch (code) {
            case 0: {
                return value;
            }
        }
        throw new IllegalStateException();
    }

    ExtendedTileMetric(int version, ByteBuffer bb) {
        this.version = version;
        this.laneNumber = AbstractBinaryFileReader.uShortToInt(bb);
        this.tileNumber = version > 2 ? AbstractBinaryFileReader.uIntToLong(bb) : (long)AbstractBinaryFileReader.uShortToInt(bb);
        switch (version) {
            case 1: {
                this.clusterCountcOccupied = ExtendedTileMetric.parseClusterCountV1(bb);
                break;
            }
            case 2: {
                this.clusterCountcOccupied = bb.getFloat();
                this.upperLeftX = Float.NaN;
                this.upperLeftY = Float.NaN;
                break;
            }
            case 3: {
                this.clusterCountcOccupied = bb.getFloat();
                this.upperLeftX = bb.getFloat();
                this.upperLeftY = bb.getFloat();
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }
}

