/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.illumina.interop.AbstractBinaryFileReader;
import fr.ens.biologie.genomique.kenetre.illumina.interop.Metric;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ExtractionMetric
extends Metric {
    private final float[] fwhm = new float[4];
    private final int[] intensities = new int[4];
    private final int laneNumber;
    private final long tileNumber;
    private final int cycleNumber;
    private final int channelCount;
    private final long timestamp;

    public int getLaneNumber() {
        return this.laneNumber;
    }

    public long getTileNumber() {
        return this.tileNumber;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getCycleNumber() {
        return this.cycleNumber;
    }

    public float[] getFwhm() {
        return Arrays.copyOf(this.fwhm, this.fwhm.length);
    }

    public int[] getIntensities() {
        return Arrays.copyOf(this.intensities, this.intensities.length);
    }

    public int getAverageIntensities() {
        int sum = 0;
        for (int intensity : this.intensities) {
            sum += intensity;
        }
        return sum / this.intensities.length;
    }

    @Override
    public List<String> fieldNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList("Lane", "Tile", "Cycle", "TimeStamp"));
        if (this.channelCount == 4) {
            result.addAll(Arrays.asList("MaxIntensity_A", "MaxIntensity_C", "MaxIntensity_G", "MaxIntensity_T", "Focus_A", "Focus_C", "Focus_G", "Focus_T"));
            return result;
        }
        result.addAll(Arrays.asList("MaxIntensity_Red", "MaxIntensity_Green", "Focus_Red", "Focus_Green"));
        return result;
    }

    @Override
    public List<Number> values() {
        int i;
        ArrayList<Number> result = new ArrayList<Number>();
        result.addAll(Arrays.asList(this.getLaneNumber(), this.getTileNumber(), this.getCycleNumber(), this.getTimestamp()));
        int channelCount = this.channelCount;
        if (channelCount == 4) {
            channelCount = this.intensities[2] == 0 && this.intensities[3] == 0 && this.fwhm[2] == 0.0f && this.fwhm[3] == 0.0f ? 2 : 4;
        }
        for (i = 0; i < channelCount; ++i) {
            result.add(this.intensities[i]);
        }
        for (i = 0; i < channelCount; ++i) {
            result.add(Float.valueOf(this.fwhm[i]));
        }
        return result;
    }

    @Override
    public List<Class<?>> fieldTypes() {
        int i;
        ArrayList result = new ArrayList();
        result.addAll(Arrays.asList(Integer.class, Integer.class, Integer.class, Long.TYPE));
        int channelCount = this.channelCount;
        if (channelCount == 4) {
            channelCount = this.intensities[2] == 0 && this.intensities[3] == 0 && this.fwhm[2] == 0.0f && this.fwhm[3] == 0.0f ? 2 : 4;
        }
        for (i = 0; i < channelCount; ++i) {
            result.add(Integer.class);
        }
        for (i = 0; i < channelCount; ++i) {
            result.add(Float.class);
        }
        return result;
    }

    ExtractionMetric(int version, int channelCount, ByteBuffer bb) {
        this.laneNumber = AbstractBinaryFileReader.uShortToInt(bb);
        this.tileNumber = version == 3 ? AbstractBinaryFileReader.uIntToLong(bb) : (long)AbstractBinaryFileReader.uShortToInt(bb);
        this.cycleNumber = AbstractBinaryFileReader.uShortToInt(bb);
        this.channelCount = channelCount;
        if (version == 2) {
            int i;
            for (i = 0; i < 4; ++i) {
                this.fwhm[i] = bb.getFloat();
            }
            for (i = 0; i < 4; ++i) {
                this.intensities[i] = AbstractBinaryFileReader.uShortToInt(bb);
            }
            bb.getLong();
            this.timestamp = -1L;
        } else if (version == 3) {
            int i;
            for (i = 0; i < channelCount; ++i) {
                this.fwhm[i] = bb.getFloat();
            }
            for (i = 0; i < channelCount; ++i) {
                this.intensities[i] = AbstractBinaryFileReader.uShortToInt(bb);
            }
            this.timestamp = -1L;
        } else {
            throw new IllegalStateException("Unknow version for  Extraction metric:" + version);
        }
    }

    public static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String byteArrayToBin(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 8);
        for (byte b : a) {
            sb.append(Integer.toBinaryString(b));
            sb.append("|");
        }
        return sb.toString();
    }
}

