/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.illumina.interop.AbstractBinaryFileReader;
import fr.ens.biologie.genomique.kenetre.illumina.interop.Metric;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class QMetric
extends Metric {
    private final int laneNumber;
    private final long tileNumber;
    private final int cycleNumber;
    private final int binCount;
    private final long[] clustersScore = new long[50];
    private final int[] remappedScoreQuality;

    public int getLaneNumber() {
        return this.laneNumber;
    }

    public long getTileNumber() {
        return this.tileNumber;
    }

    public int getCycleNumber() {
        return this.cycleNumber;
    }

    public long[] getClustersScore() {
        return Arrays.copyOf(this.clustersScore, this.clustersScore.length);
    }

    @Override
    public List<String> fieldNames() {
        ArrayList<String> result = new ArrayList<String>(3 + this.binCount);
        result.add("Lane");
        result.add("Tile");
        result.add("Cycle");
        int binCount = this.remappedScoreQuality != null ? this.remappedScoreQuality.length : this.binCount;
        for (int i = 1; i <= binCount; ++i) {
            result.add("Bin_" + i);
        }
        return result;
    }

    @Override
    public List<Number> values() {
        ArrayList<Number> result = new ArrayList<Number>(3 + this.binCount);
        result.add(this.getLaneNumber());
        result.add(this.getTileNumber());
        result.add(this.getCycleNumber());
        if (this.remappedScoreQuality != null) {
            for (int i = 0; i < this.remappedScoreQuality.length; ++i) {
                result.add(this.clustersScore[this.remappedScoreQuality[i] - 1]);
            }
        } else {
            for (int i = 0; i < this.binCount; ++i) {
                result.add(this.clustersScore[i]);
            }
        }
        return result;
    }

    @Override
    public List<Class<?>> fieldTypes() {
        ArrayList result = new ArrayList(3 + this.binCount);
        int binCount = this.remappedScoreQuality != null ? this.remappedScoreQuality.length : this.binCount;
        for (int i = 0; i < binCount + 3; ++i) {
            result.add(Integer.class);
        }
        return result;
    }

    QMetric(int version, ByteBuffer bb, int binCount, int[] remappedScoreQuality) {
        this.laneNumber = AbstractBinaryFileReader.uShortToInt(bb);
        this.tileNumber = version == 7 ? AbstractBinaryFileReader.uIntToLong(bb) : (long)AbstractBinaryFileReader.uShortToInt(bb);
        this.cycleNumber = AbstractBinaryFileReader.uShortToInt(bb);
        this.binCount = binCount > 0 ? binCount : 50;
        this.remappedScoreQuality = remappedScoreQuality;
        if (binCount > 0) {
            for (int i = 0; i < binCount; ++i) {
                this.clustersScore[remappedScoreQuality[i] - 1] = AbstractBinaryFileReader.uIntToLong(bb);
            }
        } else {
            for (int i = 0; i < 50; ++i) {
                this.clustersScore[i] = AbstractBinaryFileReader.uIntToLong(bb);
            }
        }
    }
}

