/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.illumina.interop.AbstractBinaryFileReader;
import fr.ens.biologie.genomique.kenetre.illumina.interop.QMetric;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class QMetricsReader
extends AbstractBinaryFileReader<QMetric> {
    public static final String NAME = "QualityMetricsOut";
    public static final String QUALITY_METRICS_FILE = "QMetricsOut.bin";
    private static final int EXPECTED_RECORD_SIZE_VERSION4 = 206;
    private int expectedRecordSize = 206;
    private int qualityScoreBinningEnabled = -1;
    private int qualityScoreBinNumber = -1;
    private int[] lowerBoundary;
    private int[] upperBoundary;
    private int[] remappedScoreQuality;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected File getMetricsFile() {
        return new File(this.getDirPathInterOP(), QUALITY_METRICS_FILE);
    }

    @Override
    protected int getExpectedRecordSize(int version) {
        return this.expectedRecordSize;
    }

    @Override
    protected Set<Integer> getExpectedVersions() {
        return new HashSet<Integer>(Arrays.asList(4, 5, 6, 7));
    }

    @Override
    protected void readMetricRecord(List<QMetric> collection, ByteBuffer bb, int version) {
        switch (version) {
            case 4: {
                collection.add(new QMetric(version, bb, -1, null));
                break;
            }
            case 5: {
                collection.add(new QMetric(version, bb, -1, this.remappedScoreQuality));
                break;
            }
            case 6: {
                collection.add(new QMetric(version, bb, this.qualityScoreBinNumber, this.remappedScoreQuality));
                break;
            }
            case 7: {
                collection.add(new QMetric(version, bb, this.qualityScoreBinNumber, this.remappedScoreQuality));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    protected void readOptionalFlag(ByteBuffer bb, int version) {
        switch (version) {
            case 4: {
                return;
            }
            case 5: {
                this.readOptionalFlagVersion5(bb);
                return;
            }
            case 6: {
                this.readOptionalFlagVersion6(bb);
                return;
            }
            case 7: {
                this.readOptionalFlagVersion7(bb);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    private void readOptionalFlagVersion5(ByteBuffer bb) {
        this.qualityScoreBinningEnabled = QMetricsReader.uByteToInt(bb);
        if (this.qualityScoreBinningEnabled == 1) {
            int i;
            this.qualityScoreBinNumber = QMetricsReader.uByteToInt(bb);
            this.lowerBoundary = new int[this.qualityScoreBinNumber];
            this.upperBoundary = new int[this.qualityScoreBinNumber];
            this.remappedScoreQuality = new int[this.qualityScoreBinNumber];
            for (i = 0; i < this.qualityScoreBinNumber; ++i) {
                this.lowerBoundary[i] = QMetricsReader.uByteToInt(bb);
            }
            for (i = 0; i < this.qualityScoreBinNumber; ++i) {
                this.upperBoundary[i] = QMetricsReader.uByteToInt(bb);
            }
            for (i = 0; i < this.qualityScoreBinNumber; ++i) {
                this.remappedScoreQuality[i] = QMetricsReader.uByteToInt(bb);
            }
        }
    }

    private void readOptionalFlagVersion6(ByteBuffer bb) {
        this.qualityScoreBinningEnabled = QMetricsReader.uByteToInt(bb);
        if (this.qualityScoreBinningEnabled == 1) {
            int i;
            this.qualityScoreBinNumber = QMetricsReader.uByteToInt(bb);
            this.expectedRecordSize = 6 + 4 * this.qualityScoreBinNumber;
            this.lowerBoundary = new int[this.qualityScoreBinNumber];
            this.upperBoundary = new int[this.qualityScoreBinNumber];
            this.remappedScoreQuality = new int[this.qualityScoreBinNumber];
            for (i = 0; i < this.qualityScoreBinNumber; ++i) {
                this.lowerBoundary[i] = QMetricsReader.uByteToInt(bb);
            }
            for (i = 0; i < this.qualityScoreBinNumber; ++i) {
                this.upperBoundary[i] = QMetricsReader.uByteToInt(bb);
            }
            for (i = 0; i < this.qualityScoreBinNumber; ++i) {
                this.remappedScoreQuality[i] = QMetricsReader.uByteToInt(bb);
            }
        }
    }

    private void readOptionalFlagVersion7(ByteBuffer bb) {
        this.qualityScoreBinningEnabled = QMetricsReader.uByteToInt(bb);
        if (this.qualityScoreBinningEnabled == 1) {
            this.qualityScoreBinNumber = QMetricsReader.uByteToInt(bb);
            this.expectedRecordSize = 8 + 4 * this.qualityScoreBinNumber;
            this.lowerBoundary = new int[this.qualityScoreBinNumber];
            this.upperBoundary = new int[this.qualityScoreBinNumber];
            this.remappedScoreQuality = new int[this.qualityScoreBinNumber];
            for (int i = 0; i < this.qualityScoreBinNumber; ++i) {
                this.lowerBoundary[i] = QMetricsReader.uByteToInt(bb);
                this.upperBoundary[i] = QMetricsReader.uByteToInt(bb);
                this.remappedScoreQuality[i] = QMetricsReader.uByteToInt(bb);
            }
        }
    }

    public int getQualityScoreBinningEnabled() {
        return this.qualityScoreBinningEnabled;
    }

    public int getQualityScoreBinNumber() {
        return this.qualityScoreBinNumber;
    }

    public int[] getLowerBoundary() {
        return this.lowerBoundary;
    }

    public int[] getUpperBoundary() {
        return this.upperBoundary;
    }

    public int[] getRemappedScoreQuality() {
        return this.remappedScoreQuality;
    }

    public void setQualityScoreBinningEnabled(int value) {
        this.qualityScoreBinningEnabled = value;
    }

    public void setQualityScoreBinNumber(int value) {
        this.qualityScoreBinNumber = value;
    }

    public void setLowerBoundary(int[] value) {
        this.lowerBoundary = value;
    }

    public void setUpperBoundary(int[] value) {
        this.upperBoundary = value;
    }

    public void setRemappedScoreQuality(int[] value) {
        this.remappedScoreQuality = value;
    }

    public QMetricsReader(File dirPath) throws KenetreException {
        super(dirPath);
    }
}

