/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.interop;

import fr.ens.biologie.genomique.kenetre.illumina.interop.AbstractBinaryFileReader;
import fr.ens.biologie.genomique.kenetre.illumina.interop.Metric;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TileMetric
extends Metric {
    private static final int CLUSTER_DENSITY = 100;
    private static final int CLUSTER_DENSITY_PF = 101;
    private static final int CLUSTER_COUNT = 102;
    private static final int CLUSTER_COUNT_PF = 103;
    private static final int PHASING = 200;
    private static final int PREFPHASING = 201;
    private static final int PERCENT_ALIGNED = 300;
    private static final int CONTROL_LANE = 400;
    private static final int LANE_BIT_COUNT = 6;
    private static final int TILE_BIT_COUNT = 26;
    private static final int CYCLE_BIT_COUNT = 16;
    private static final int READ_BIT_COUNT = 16;
    private static final int RESERVED_BIT_COUNT = 16;
    private static final int READ_BIT_SHIFT = 16;
    private static final int CYCLE_BIT_SHIFT = 16;
    private static final int TILE_BIT_SHIFT = 32;
    private static final int LANE_BIT_SHIFT = 58;
    private int laneNumber;
    private long tileNumber;
    private float clusterDensity;
    private float clusterDensityPF;
    private float clusterCount;
    private float clusterCountPF;
    private final List<ReadMetric> readMetrics = new ArrayList<ReadMetric>();

    static int id(int lane, int tile) {
        return lane << 58 | tile << 32;
    }

    public int getLaneNumber() {
        return this.laneNumber;
    }

    public long getTileNumber() {
        return this.tileNumber;
    }

    public float getClusterDensity() {
        return this.clusterDensity;
    }

    public float getClusterDensityPF() {
        return this.clusterDensityPF;
    }

    public float getClusterCount() {
        return this.clusterCount;
    }

    public float getClusterCountPF() {
        return this.clusterCountPF;
    }

    public float getPercentPF() {
        return 100.0f * this.clusterCountPF / this.clusterCount;
    }

    public List<ReadMetric> readMetrics() {
        return this.readMetrics;
    }

    public float getPercentAligned(int readIndex) {
        if (readIndex >= this.readMetrics.size()) {
            return Float.NaN;
        }
        return this.readMetrics.get(readIndex).percentAligned();
    }

    public float getPercentPhasing(int readIndex) {
        if (readIndex >= this.readMetrics.size()) {
            return Float.NaN;
        }
        return this.readMetrics.get(readIndex).percentPhasing();
    }

    public float getPercentPrephasing(int readIndex) {
        if (readIndex >= this.readMetrics.size()) {
            return Float.NaN;
        }
        return this.readMetrics.get(readIndex).percentPrephasing();
    }

    public float getPercentPrephasingAt(int number) {
        for (ReadMetric rm : this.readMetrics) {
            if (rm.read() != (long)number) continue;
            return rm.percentPrephasing();
        }
        return Float.NaN;
    }

    public int getReadCount() {
        return this.readMetrics.size();
    }

    void parseV2(ByteBuffer bb) {
        int metricCode = AbstractBinaryFileReader.uShortToInt(bb);
        float metricValue = bb.getFloat();
        switch (metricCode) {
            case 400: {
                break;
            }
            case 100: {
                this.clusterDensity = metricValue;
                break;
            }
            case 101: {
                this.clusterDensityPF = metricValue;
                break;
            }
            case 102: {
                this.clusterCount = metricValue;
                break;
            }
            case 103: {
                this.clusterCountPF = metricValue;
                break;
            }
            default: {
                if (metricCode % 200 < 100) {
                    int code_offset = metricCode % 200;
                    if (code_offset % 2 == 0) {
                        this.getRead(this, code_offset / 2 + 1).percentPhasing(metricValue * 100.0f);
                        break;
                    }
                    this.getRead(this, (code_offset + 1) / 2).percentPrephasing(metricValue * 100.0f);
                    break;
                }
                if (metricCode % 300 < 100) {
                    int code_offset = metricCode % 300;
                    this.getRead(this, code_offset + 1).percentAligned(metricValue);
                    break;
                }
                throw new IllegalStateException();
            }
        }
    }

    void parseV3(ByteBuffer bb, float density) {
        int metricCode = AbstractBinaryFileReader.uByteToInt(bb);
        switch (metricCode) {
            case 116: {
                this.clusterCount = bb.getFloat();
                this.clusterCountPF = bb.getFloat();
                if (density == 0.0f || Float.isNaN(density)) {
                    this.clusterDensity = Float.NaN;
                    this.clusterDensityPF = Float.NaN;
                    break;
                }
                this.clusterDensity = this.clusterCount / density;
                this.clusterDensityPF = this.clusterCountPF / density;
                break;
            }
            case 114: {
                long read = AbstractBinaryFileReader.uIntToLong(bb);
                float percentAligned = bb.getFloat();
                int i = this.readMetrics.size();
                while ((long)i < read) {
                    this.readMetrics.add(new ReadMetric());
                    ++i;
                }
                ReadMetric rm = this.readMetrics.get((int)read - 1);
                rm.percentAligned = percentAligned;
                rm.percentPhasing = Float.NaN;
                rm.percentPrephasing = Float.NaN;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private ReadMetric getRead(TileMetric metric, long read) {
        for (ReadMetric m : metric.readMetrics) {
            if (m.read() != read) continue;
            return m;
        }
        ReadMetric result = new ReadMetric();
        result.read = read;
        metric.readMetrics.add(result);
        return result;
    }

    @Override
    public List<String> fieldNames() {
        return Arrays.asList("Lane", "Tile", "Read", "ClusterCount", "ClusterCountPF", "Density", "DensityPF", "Aligned", "Prephasing", "Phasing");
    }

    @Override
    public List<Number> values() {
        return this.values(0);
    }

    public List<Number> values(int read) {
        return Arrays.asList(this.getLaneNumber(), this.getTileNumber(), read + 1, Float.valueOf(this.getClusterCount()), Float.valueOf(this.getClusterCountPF()), Float.valueOf(this.getClusterDensity()), Float.valueOf(this.getClusterDensityPF()), Float.valueOf(this.getPercentAligned(read)), Float.valueOf(this.getPercentPrephasing(read)), Float.valueOf(this.getPercentPhasing(read)));
    }

    @Override
    public List<Class<?>> fieldTypes() {
        return Arrays.asList(Integer.class, Integer.class, Integer.class, Float.class, Float.class, Float.class, Float.class, Float.class, Float.class, Float.class);
    }

    public String toString() {
        return "NewTileMetric [m_lane=" + this.laneNumber + ", m_tile=" + this.tileNumber + ", m_cluster_density=" + this.clusterDensity + ", m_cluster_density_pf=" + this.clusterDensityPF + ", m_cluster_count=" + this.clusterCount + ", m_cluster_count_pf=" + this.clusterCountPF + "]";
    }

    TileMetric(int lane, long tile) {
        this.laneNumber = lane;
        this.tileNumber = tile;
    }

    class ReadMetric {
        private long read;
        private float percentAligned;
        private float percentPhasing;
        private float percentPrephasing;

        ReadMetric() {
        }

        long read() {
            return this.read;
        }

        float percentAligned() {
            return this.percentAligned;
        }

        float percentPhasing() {
            return this.percentPhasing < 0.0f ? 0.0f : this.percentPhasing;
        }

        float percentPrephasing() {
            return this.percentPrephasing < 0.0f ? 0.0f : this.percentPrephasing;
        }

        void percentAligned(float val) {
            this.percentAligned = val;
        }

        void percentPhasing(float val) {
            this.percentPhasing = val;
        }

        void percentPrephasing(float val) {
            this.percentPrephasing = val;
        }
    }
}

