/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet;

import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.TableSection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Sample {
    public static final String LANE_FIELD_NAME = "_lane";
    public static final String SAMPLE_ID_FIELD_NAME = "_sampleid";
    public static final String SAMPLE_NAME_FIELD_NAME = "_samplename";
    public static final String DESCRIPTION_FIELD_NAME = "_description";
    public static final String PROJECT_FIELD_NAME = "_project";
    public static final String INDEX1_FIELD_NAME = "_index1";
    public static final String INDEX2_FIELD_NAME = "_index2";
    public static final String SAMPLE_REF_FIELD_NAME = "_sampleref";
    private final TableSection tableSection;
    private final Map<String, String> map = new LinkedHashMap<String, String>();

    public String get(String fieldName) {
        return this.map.get(fieldName);
    }

    public int getLane() {
        if (!this.map.containsKey(LANE_FIELD_NAME)) {
            return -1;
        }
        String value = this.get(LANE_FIELD_NAME);
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public String getSampleId() {
        return this.map.get(SAMPLE_ID_FIELD_NAME);
    }

    public String getSampleName() {
        return this.map.get(SAMPLE_NAME_FIELD_NAME);
    }

    public String getDescription() {
        return this.map.get(DESCRIPTION_FIELD_NAME);
    }

    public String getSampleProject() {
        return this.map.get(PROJECT_FIELD_NAME);
    }

    public String getIndex1() {
        return this.map.get(INDEX1_FIELD_NAME);
    }

    public String getIndex2() {
        return this.map.get(INDEX2_FIELD_NAME);
    }

    public String getSampleRef() {
        return this.map.get(SAMPLE_REF_FIELD_NAME);
    }

    public List<String> getFieldNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.map.keySet()) {
            result.add(key);
        }
        return result;
    }

    public boolean isIndexed() {
        String value;
        return this.map.containsKey(INDEX1_FIELD_NAME) && (value = this.getIndex1()) != null && !value.trim().isEmpty();
    }

    public boolean isDualIndexed() {
        String value;
        return this.isIndexed() && this.map.containsKey(INDEX2_FIELD_NAME) && (value = this.getIndex2()) != null && !value.trim().isEmpty();
    }

    public TableSection getTableSection() {
        return this.tableSection;
    }

    public SampleSheet getSampleSheet() {
        return this.tableSection.getSampleSheet();
    }

    public String getDemultiplexingName() {
        String sampleName = this.getSampleName();
        String sampleIdentifier = this.getSampleId();
        if (sampleName != null && !sampleName.isEmpty()) {
            return sampleName;
        }
        return sampleIdentifier;
    }

    public void set(String fieldName, String value) {
        if (fieldName == null) {
            throw new NullPointerException("The field name cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("The value cannot be null");
        }
        this.map.put(fieldName, value);
    }

    public void setSampleId(String sampleId) {
        this.set(SAMPLE_ID_FIELD_NAME, sampleId);
    }

    public void setSampleName(String sampleName) {
        this.set(SAMPLE_NAME_FIELD_NAME, sampleName);
    }

    public void setLane(int lane) {
        if (lane < 1) {
            throw new IllegalArgumentException("Lane argument cannot be lower than 1");
        }
        this.set(LANE_FIELD_NAME, "" + lane);
    }

    public void setDescription(String description) {
        this.set(DESCRIPTION_FIELD_NAME, description);
    }

    public void setSampleProject(String projectName) {
        this.set(PROJECT_FIELD_NAME, projectName);
    }

    public void setSampleRef(String sampleRef) {
        this.set(SAMPLE_REF_FIELD_NAME, sampleRef);
    }

    public void setIndex1(String index) {
        if (index == null) {
            throw new NullPointerException("The index value cannot be null");
        }
        this.map.put(INDEX1_FIELD_NAME, index.trim());
    }

    public void setIndex2(String index) {
        if (index == null) {
            throw new NullPointerException("The index value cannot be null");
        }
        this.map.put(INDEX2_FIELD_NAME, index.trim());
    }

    public boolean isField(String fieldName) {
        return this.map.containsKey(fieldName);
    }

    public boolean isLaneField() {
        return this.isField(LANE_FIELD_NAME);
    }

    public boolean isSampleIdField() {
        return this.isField(SAMPLE_ID_FIELD_NAME);
    }

    public boolean isSampleNameField() {
        return this.isField(SAMPLE_NAME_FIELD_NAME);
    }

    public boolean isDescriptionField() {
        return this.isField(DESCRIPTION_FIELD_NAME);
    }

    public boolean isSampleProjectField() {
        return this.isField(PROJECT_FIELD_NAME);
    }

    public boolean isIndex1Field() {
        return this.isField(INDEX1_FIELD_NAME);
    }

    public boolean isIndex2Field() {
        return this.isField(INDEX2_FIELD_NAME);
    }

    public boolean isSampleRefField() {
        return this.isField(SAMPLE_REF_FIELD_NAME);
    }

    public void remove(String fieldName) {
        this.map.remove(fieldName);
    }

    public static boolean isInternalField(String fieldName) {
        if (fieldName == null) {
            throw new NullPointerException("fieldName argument cannot be null");
        }
        return LANE_FIELD_NAME.equals(fieldName) || SAMPLE_ID_FIELD_NAME.equals(fieldName) || SAMPLE_NAME_FIELD_NAME.equals(fieldName) || DESCRIPTION_FIELD_NAME.equals(fieldName) || PROJECT_FIELD_NAME.equals(fieldName) || INDEX1_FIELD_NAME.equals(fieldName) || INDEX2_FIELD_NAME.equals(fieldName) || SAMPLE_REF_FIELD_NAME.equals(fieldName);
    }

    public String toString() {
        return this.getClass().getName() + "{map=" + this.map + "}";
    }

    public Sample(TableSection tableSection) {
        if (tableSection == null) {
            throw new NullPointerException("The tableSection cannot be null");
        }
        this.tableSection = tableSection;
    }
}

