/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.Sample;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheetUtils;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.TableSection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SampleSheetCheck {
    public static List<String> checkSampleSheet(SampleSheet samplesheet) throws KenetreException {
        return SampleSheetCheck.checkSampleSheet(samplesheet, null, false);
    }

    public static List<String> checkSampleSheet(SampleSheet samplesheet, String flowCellId) throws KenetreException {
        return SampleSheetCheck.checkSampleSheet(samplesheet, flowCellId, false);
    }

    public static List<String> checkSampleSheet(SampleSheet samplesheet, String flowCellId, boolean allowUnderscoreInSampleID) throws KenetreException {
        if (samplesheet == null) {
            throw new NullPointerException("The samplesheet object is null");
        }
        TableSection table = SampleSheetUtils.getCheckedDemuxTableSection(samplesheet);
        if (table.size() == 0) {
            throw new KenetreException("No samples found in the samplesheet.");
        }
        ArrayList<String> warnings = new ArrayList<String>();
        HashMap indexes = new HashMap();
        HashSet<String> sampleIds = new HashSet<String>();
        HashSet<String> sampleNames = new HashSet<String>();
        HashSet<Integer> laneWithIndexes = new HashSet<Integer>();
        HashSet<Integer> laneWithoutIndexes = new HashSet<Integer>();
        HashMap<String, Set<Integer>> sampleInLanes = new HashMap<String, Set<Integer>>();
        HashMap<String, String> samplesProjects = new HashMap<String, String>();
        HashMap<String, String> samplesIndex = new HashMap<String, String>();
        for (Sample sample : table) {
            if (sample.isField("FCID")) {
                String sampleFCID = sample.get("FCID");
                SampleSheetCheck.checkFCID(sampleFCID);
                if (flowCellId != null && !flowCellId.trim().toUpperCase().equals(sampleFCID.toUpperCase())) {
                    throw new KenetreException("Bad flowcell name found: " + sampleFCID + " (" + flowCellId + " expected).");
                }
            }
            SampleSheetCheck.checkSampleId(sample.getSampleId(), allowUnderscoreInSampleID, sampleIds);
            if (sample.isSampleNameField()) {
                SampleSheetCheck.checkSampleName(sample.getSampleName(), allowUnderscoreInSampleID, sampleNames, true, warnings);
            }
            if (sample.isSampleRefField()) {
                SampleSheetCheck.checkSampleRef(sample.getSampleId(), sample.getSampleRef());
            }
            if (sample.isIndex1Field()) {
                SampleSheetCheck.checkIndex(sample.getIndex1());
            }
            if (sample.isIndex2Field()) {
                SampleSheetCheck.checkIndex(sample.getIndex2());
            }
            if (!sample.isIndex1Field() && sample.isIndex2Field()) {
                warnings.add("Found a column in the samplesheet for index 2 but not for index 1");
            }
            SampleSheetCheck.checkSampleIndex(sample.getSampleId(), sample.getIndex1(), sample.getIndex2(), samplesIndex);
            if (sample.isDescriptionField()) {
                SampleSheetCheck.checkSampleDescription(sample.getSampleId(), sample.getDescription(), true, warnings);
            }
            if (sample.isSampleProjectField()) {
                SampleSheetCheck.checkSampleProject(sample.getSampleProject());
                SampleSheetCheck.checkCharset(sample.getSampleProject());
            }
            String index = sample.getIndex1() == null ? null : sample.getIndex1() + (sample.getIndex2() != null ? '-' + sample.getIndex2() : "");
            int lane = sample.getLane();
            if (index == null || "".equals(index.trim())) {
                if (laneWithoutIndexes.contains(lane)) {
                    throw new KenetreException("Found two samples without index for the same lane: " + lane + ".");
                }
                if (laneWithIndexes.contains(lane)) {
                    throw new KenetreException("Found a lane with indexed and non indexed samples: " + lane + ".");
                }
                laneWithoutIndexes.add(lane);
            } else {
                if (laneWithoutIndexes.contains(lane)) {
                    throw new KenetreException("Found a lane with indexed and non indexed samples: " + lane + ".");
                }
                laneWithIndexes.add(lane);
            }
            if (indexes.containsKey(lane)) {
                if (((Set)indexes.get(lane)).contains(index)) {
                    throw new KenetreException("Found a lane with two time the same index: " + lane + " (" + index + ").");
                }
            } else {
                indexes.put(lane, new HashSet());
            }
            if (sample.isSampleProjectField()) {
                SampleSheetCheck.checkSampleAndProject(sample.getSampleId(), sample.getSampleProject(), sample.getLane(), sampleInLanes, samplesProjects, warnings);
            }
            ((Set)indexes.get(lane)).add(index);
        }
        SampleSheetCheck.checkSampleInLanes(sampleInLanes, warnings);
        ArrayList<String> result = new ArrayList<String>(new HashSet<String>(warnings));
        Collections.sort(result);
        return result;
    }

    private static void checkCharset(String s) throws KenetreException {
        if (s == null) {
            return;
        }
        for (int i = 0; i < s.length(); ++i) {
            int c = s.codePointAt(i);
            if (c >= 32 && c < 127) continue;
            throw new KenetreException("Found invalid character '" + (char)c + "' in \"" + s + "\".");
        }
    }

    private static void checkFCID(String fcid) throws KenetreException {
        if (SampleSheetCheck.isNullOrEmpty(fcid)) {
            throw new KenetreException("Flow cell id is null or empty.");
        }
        SampleSheetCheck.checkCharset(fcid);
        for (int i = 0; i < fcid.length(); ++i) {
            char c = fcid.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            throw new KenetreException("Invalid flow cell id, only letters or digits are allowed: " + fcid + ".");
        }
    }

    private static void checkSampleId(String sampleId, boolean allowUnderscoreInSampleID, Set<String> sampleIds) throws KenetreException {
        if (SampleSheetCheck.isNullOrEmpty(sampleId)) {
            throw new KenetreException("Found a null or empty sample id.");
        }
        SampleSheetCheck.checkCharset(sampleId);
        if (SampleSheetCheck.hasForbiddenCharacter(sampleId, allowUnderscoreInSampleID)) {
            throw new KenetreException("Invalid sample id, only letters, digits, '-' or '_' characters are allowed: " + sampleId + ".");
        }
        if (sampleId.length() > 20) {
            throw new KenetreException("Invalid sample id, a valid id cannot be longuer than 20 characters: " + sampleId + ".");
        }
        sampleIds.add(sampleId);
    }

    public static boolean hasForbiddenCharacter(String s, boolean allowUnderscoreInSampleID) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' && !allowUnderscoreInSampleID || c == '-') continue;
            return true;
        }
        return false;
    }

    private static void checkSampleName(String sampleName, boolean allowUnderscoreInSampleID, Set<String> sampleNames, Boolean isBcl2Fastq2, List<String> warnings) throws KenetreException {
        if (SampleSheetCheck.isNullOrEmpty(sampleName)) {
            if (!isBcl2Fastq2.booleanValue()) {
                throw new KenetreException("Sample Name is null or empty.");
            }
            warnings.add("Empty or null Sample Name detected.");
        }
        SampleSheetCheck.checkCharset(sampleName);
        if (SampleSheetCheck.hasForbiddenCharacter(sampleName, allowUnderscoreInSampleID)) {
            throw new KenetreException("Invalid sample id, only letters, digits, '-' or '_' characters are allowed : " + sampleName + ".");
        }
        sampleNames.add(sampleName);
    }

    private static void checkSampleRef(String sampleId, String sampleRef) throws KenetreException {
        if (SampleSheetCheck.isNullOrEmpty(sampleRef)) {
            throw new KenetreException("Found a null or empty sample reference for sample: " + sampleId + ".");
        }
        SampleSheetCheck.checkCharset(sampleRef);
        for (int i = 0; i < sampleRef.length(); ++i) {
            char c = sampleRef.charAt(i);
            if (Character.isLetterOrDigit(c) || c == ' ' || c == '-' || c == '_') continue;
            throw new KenetreException("Invalid sample reference, only letters, digits, ' ', '-' or '_' characters are allowed: " + sampleRef + ".");
        }
    }

    static void checkIndex(String index) throws KenetreException {
        if (index == null) {
            return;
        }
        block3: for (int i = 0; i < index.length(); ++i) {
            switch (index.codePointAt(i)) {
                case 65: 
                case 67: 
                case 71: 
                case 84: 
                case 97: 
                case 99: 
                case 103: 
                case 116: {
                    continue block3;
                }
                default: {
                    throw new KenetreException("Invalid index found: " + index + ".");
                }
            }
        }
    }

    private static void checkSampleDescription(String sampleId, String sampleDescription, Boolean isBcl2Fastq2, List<String> warnings) throws KenetreException {
        if (SampleSheetCheck.isNullOrEmpty(sampleDescription)) {
            if (!isBcl2Fastq2.booleanValue()) {
                throw new KenetreException("Found a null or empty description for sample: " + sampleId);
            }
            warnings.add("Found a null or empty description for sample: " + sampleId);
        }
        SampleSheetCheck.checkCharset(sampleDescription);
        for (int i = 0; i < sampleDescription.length(); ++i) {
            char c = sampleDescription.charAt(i);
            if (c != '\'' && c != '\"') continue;
            throw new KenetreException("Invalid sample description, '" + c + "' character is not allowed: " + sampleDescription + ".");
        }
    }

    private static void checkSampleProject(String sampleProject) throws KenetreException {
        if (SampleSheetCheck.isNullOrEmpty(sampleProject)) {
            throw new KenetreException("Found a null or empty sample project name.");
        }
        for (int i = 0; i < sampleProject.length(); ++i) {
            char c = sampleProject.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
            throw new KenetreException("Invalid sample project, only letters, digits, '-' or '_' characters are allowed: " + sampleProject + ".");
        }
    }

    private static void checkSampleAndProject(String sampleId, String projectName, int lane, Map<String, Set<Integer>> sampleInLanes, Map<String, String> samplesProjects, List<String> warnings) throws KenetreException {
        Set<Object> lanes;
        if (samplesProjects.containsKey(sampleId) && !samplesProjects.get(sampleId).equals(projectName)) {
            throw new KenetreException("The sample \"" + sampleId + "\" is used by two or more projects.");
        }
        samplesProjects.put(sampleId, projectName);
        if (!sampleInLanes.containsKey(sampleId)) {
            lanes = new HashSet();
            sampleInLanes.put(sampleId, lanes);
        } else {
            lanes = sampleInLanes.get(sampleId);
        }
        if (lanes.contains(lane)) {
            warnings.add("The sample \"" + sampleId + "\" exists two or more times in the lane " + lane + ".");
        }
        lanes.add(lane);
    }

    private static void checkSampleInLanes(Map<String, Set<Integer>> sampleInLanes, List<String> warnings) {
        for (Map.Entry<String, Set<Integer>> e : sampleInLanes.entrySet()) {
            Set<Integer> lanes = e.getValue();
            if (lanes.size() <= 1) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("The sample \"");
            sb.append(e.getKey());
            sb.append("\" exists in lanes: ");
            ArrayList<Integer> laneSorted = new ArrayList<Integer>(lanes);
            Collections.sort(laneSorted);
            boolean first = true;
            Iterator iterator = laneSorted.iterator();
            while (iterator.hasNext()) {
                int lane = (Integer)iterator.next();
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(lane);
            }
            sb.append('.');
            warnings.add(sb.toString());
        }
    }

    private static void checkSampleIndex(String sampleName, String index1, String index2, Map<String, String> samplesIndex) throws KenetreException {
        if (index1 == null) {
            return;
        }
        String key = index1 + (index2 != null ? '-' + index2 : "");
        if (samplesIndex.containsKey(sampleName) && !samplesIndex.get(sampleName).equals(key)) {
            throw new KenetreException("The sample \"" + sampleName + "\" is defined in several lanes but without the same index.");
        }
        samplesIndex.put(sampleName, key);
    }

    private static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

