/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.KenetreRuntimeException;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.PropertySection;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.Sample;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheetCheck;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.TableSection;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetDiscoverFormatParser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class SampleSheetUtils {
    private static final char SEPARATOR = ',';

    public static final String toSampleSheetV1CSV(SampleSheet samplesheet) {
        TableSection table;
        StringBuilder sb = new StringBuilder();
        sb.append("\"FCID\",\"Lane\",\"SampleID\",\"SampleRef\",\"Index\",\"Description\",\"Control\",\"Recipe\",\"Operator\",\"SampleProject\"\n");
        if (samplesheet == null) {
            return sb.toString();
        }
        try {
            table = samplesheet.getDemuxSection();
        }
        catch (NoSuchElementException e) {
            return sb.toString();
        }
        for (Sample s : table) {
            sb.append(samplesheet.getFlowCellId().toUpperCase());
            sb.append(',');
            sb.append(s.getLane());
            sb.append(',');
            sb.append(SampleSheetUtils.quote(s.getSampleId().trim()));
            sb.append(',');
            sb.append(SampleSheetUtils.quote(s.getSampleRef().trim()));
            sb.append(',');
            String index = s.getIndex1();
            if (!s.getIndex2().isEmpty()) {
                index = index + '-' + s.getIndex2();
            }
            sb.append(SampleSheetUtils.quote(index));
            sb.append(',');
            sb.append(SampleSheetUtils.quote(s.getDescription().trim()));
            sb.append(',');
            sb.append(Boolean.parseBoolean(s.get("Control")) ? (char)'Y' : 'N');
            sb.append(',');
            sb.append(SampleSheetUtils.quote(s.get("Recipe").trim()));
            sb.append(',');
            sb.append(SampleSheetUtils.quote(s.get("Operator").trim()));
            sb.append(',');
            sb.append(SampleSheetUtils.quote(s.getSampleProject()));
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String convertFieldNameV2(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        if ("_lane".equals(fieldName)) {
            return "Lane";
        }
        if ("_sampleid".equals(fieldName)) {
            return "Sample_ID";
        }
        if ("_samplename".equals(fieldName)) {
            return "Sample_Name";
        }
        if ("_description".equals(fieldName)) {
            return "Description";
        }
        if ("_project".equals(fieldName)) {
            return "Sample_Project";
        }
        if ("_index1".equals(fieldName)) {
            return "index";
        }
        if ("_index2".equals(fieldName)) {
            return "index2";
        }
        if ("_sampleref".equals(fieldName)) {
            return "Sample_Ref";
        }
        return fieldName;
    }

    public static final String toSampleSheetV2CSV(SampleSheet samplesheet) {
        if (samplesheet == null) {
            throw new NullPointerException("the samplesheet argument cannot be null");
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String section : samplesheet.getSections()) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(SampleSheetUtils.sectionHeader(section));
            if (samplesheet.containsPropertySection(section)) {
                sb.append(SampleSheetUtils.propertySectionToCSV(samplesheet.getPropertySection(section)));
                continue;
            }
            sb.append(SampleSheetUtils.tableSectionToCSV(samplesheet.getTableSection(section)));
        }
        return sb.toString();
    }

    private static String sectionHeader(String sectionName) {
        return '[' + SampleSheetUtils.quoteStringWithComma(sectionName) + "]\n";
    }

    private static String propertySectionToCSV(PropertySection propertySection) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> e : propertySection.entrySet()) {
            sb.append(e.getKey());
            if (!e.getValue().isEmpty()) {
                sb.append(',');
                sb.append(SampleSheetUtils.quoteStringWithComma(e.getValue()));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String tableSectionToCSV(TableSection tableSection) {
        StringBuilder sb = new StringBuilder();
        List<String> fieldNames = tableSection.getSamplesFieldNames();
        boolean firstHeader = true;
        for (String fieldName : fieldNames) {
            if (fieldName.isEmpty()) continue;
            if (firstHeader) {
                firstHeader = false;
            } else {
                sb.append(',');
            }
            sb.append(SampleSheetUtils.quoteStringWithComma(SampleSheetUtils.convertFieldNameV2(fieldName)));
        }
        sb.append('\n');
        for (Sample s : tableSection) {
            boolean first = true;
            for (String fieldName : fieldNames) {
                if (fieldName.isEmpty()) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(SampleSheetUtils.quoteStringWithComma(s.get(fieldName)));
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    private static String quote(String s) {
        if (s == null) {
            return "";
        }
        String trimmed = s.trim();
        if (s.indexOf(32) != -1 || s.indexOf(44) != -1 || s.indexOf(39) != -1) {
            return '\"' + trimmed + '\"';
        }
        return trimmed;
    }

    private static String quoteStringWithComma(String s) {
        if (s == null) {
            return "";
        }
        if (s.contains(",")) {
            return "\"" + s + "\"";
        }
        return s;
    }

    public static void duplicateSamplesIfLaneFieldNotSet(SampleSheet samplesheet, int laneCount) {
        TableSection table;
        if (samplesheet == null) {
            throw new NullPointerException("The samplesheet argument cannot be null");
        }
        if (laneCount < 1) {
            throw new IllegalArgumentException("The lane count cannot be lower than 1: " + laneCount);
        }
        try {
            table = samplesheet.getDemuxSection();
        }
        catch (NoSuchElementException e) {
            return;
        }
        if (table.isLaneSampleField()) {
            return;
        }
        ArrayList<Sample> samples = new ArrayList<Sample>();
        for (Object s : table) {
            samples.add((Sample)s);
        }
        ArrayList samplesToDuplicate = new ArrayList();
        for (Sample s : samples) {
            s.set("_lane", "1");
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            samplesToDuplicate.add(linkedHashMap);
            for (String fieldName : s.getFieldNames()) {
                linkedHashMap.put(fieldName, s.get(fieldName));
            }
        }
        for (int i = 2; i <= laneCount; ++i) {
            for (Map map : samplesToDuplicate) {
                Sample s2 = table.addSample();
                for (Map.Entry e : map.entrySet()) {
                    s2.set((String)e.getKey(), (String)e.getValue());
                }
                s2.set("_lane", "" + i);
            }
        }
    }

    public static void checkRequiredQCSampleFields(SampleSheet samplesheet) {
        TableSection table;
        if (samplesheet == null) {
            throw new NullPointerException("The samplesheet argument cannot be null");
        }
        try {
            table = samplesheet.getDemuxSection();
        }
        catch (NoSuchElementException e) {
            return;
        }
        for (String fieldName : Arrays.asList("sampleref", "_index1", "_description", "_project")) {
            if (!table.isSampleFieldName(fieldName)) continue;
            throw new KenetreRuntimeException("A required field is Missing in the samplesheet to create the quality control report: " + SampleSheetUtils.convertFieldNameV2(fieldName));
        }
    }

    public static SampleSheet parseCSVSamplesheet(final String s) throws IOException {
        if (s == null) {
            return null;
        }
        try (SampleSheetReader reader = new SampleSheetReader(){

            @Override
            public SampleSheet read() throws IOException {
                String[] lines = s.split("\n");
                SampleSheetDiscoverFormatParser parser = new SampleSheetDiscoverFormatParser();
                for (String line : lines) {
                    if ("".equals(line.trim())) continue;
                    parser.parseLine(SampleSheetUtils.parseCSVSamplesheetLine(line));
                }
                return parser.getSampleSheet();
            }

            @Override
            public void close() throws IOException {
            }
        };){
            SampleSheet sampleSheet = reader.read();
            return sampleSheet;
        }
    }

    public static SampleSheet parseTabulatedSamplesheet(final String s) throws IOException {
        if (s == null) {
            return null;
        }
        try (SampleSheetReader reader = new SampleSheetReader(){

            @Override
            public SampleSheet read() throws IOException {
                String[] lines = s.split("\n");
                SampleSheetDiscoverFormatParser parser = new SampleSheetDiscoverFormatParser();
                for (String line : lines) {
                    if ("".equals(line.trim())) continue;
                    parser.parseLine(SampleSheetUtils.parseTabulatedSamplesheetLine(line));
                }
                return parser.getSampleSheet();
            }

            @Override
            public void close() throws IOException {
            }
        };){
            SampleSheet sampleSheet = reader.read();
            return sampleSheet;
        }
    }

    public static final List<String> parseCSVSamplesheetLine(String line) {
        ArrayList<String> result = new ArrayList<String>();
        if (line == null) {
            return null;
        }
        int len = line.length();
        boolean openQuote = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = line.charAt(i);
            if (!openQuote && c == ',') {
                result.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            if (c == '\"') {
                openQuote = !openQuote;
                continue;
            }
            sb.append(c);
        }
        result.add(sb.toString());
        return result;
    }

    public static List<String> parseTabulatedSamplesheetLine(String line) {
        if (line == null) {
            return null;
        }
        return Arrays.asList(line.split("\t"));
    }

    public static void replaceIndexShortcutsBySequences(SampleSheet samplesheet, Map<String, String> sequences) throws KenetreException {
        TableSection table;
        if (samplesheet == null || sequences == null) {
            return;
        }
        try {
            table = samplesheet.getDemuxSection();
        }
        catch (NoSuchElementException e) {
            return;
        }
        for (Sample sample : table) {
            if (sample.isIndex1Field()) {
                String index1 = sample.getIndex1();
                if (index1 == null) {
                    throw new NullPointerException("Sample index1 is null for sample: " + sample);
                }
                index1 = index1.trim().toLowerCase();
                try {
                    SampleSheetCheck.checkIndex(index1);
                }
                catch (KenetreException e) {
                    if (!sequences.containsKey(index1)) {
                        throw new KenetreException("Unknown index 1 sequence shortcut (" + index1 + ") for sample: " + sample);
                    }
                    sample.setIndex1(sequences.get(index1));
                }
            }
            if (!sample.isIndex2Field()) continue;
            String index2 = sample.getIndex2();
            if (index2 == null) {
                throw new NullPointerException("Sample index2 is null for sample: " + sample);
            }
            index2 = index2.trim().toLowerCase();
            try {
                SampleSheetCheck.checkIndex(index2);
            }
            catch (KenetreException e) {
                if (!sequences.containsKey(index2)) {
                    throw new KenetreException("Unknown index 2 sequence shortcut (" + index2 + ") for sample: " + sample);
                }
                sample.setIndex2(sequences.get(index2));
            }
        }
    }

    public static TableSection getCheckedDemuxTableSection(SampleSheet samplesheet) throws KenetreException {
        Objects.requireNonNull(samplesheet);
        try {
            return samplesheet.getDemuxSection();
        }
        catch (NoSuchElementException e) {
            throw new KenetreException("No sample table for demultiplexing found in samplesheet");
        }
    }

    public static void removeBclConvertDataForbiddenFields(SampleSheet samplesheet) throws KenetreException {
        Objects.requireNonNull(samplesheet);
        if (!samplesheet.containsSection("BCLConvert_Data")) {
            throw new KenetreException("No section BCLConvert_Data found in samplesheet");
        }
        TableSection demuxTable = samplesheet.getTableSection("BCLConvert_Data");
        block10: for (String fieldName : demuxTable.getSamplesFieldNames()) {
            switch (fieldName.toLowerCase().trim()) {
                case "_lane": 
                case "_sampleid": 
                case "_index1": 
                case "_index2": 
                case "_project": {
                    continue block10;
                }
            }
            for (Sample s : demuxTable.getSamples()) {
                s.remove(fieldName);
            }
        }
    }

    public static void moveBclConvertDataForbiddenFieldsInNewSection(SampleSheet samplesheet, String otherSectionName) throws KenetreException {
        Objects.requireNonNull(samplesheet);
        Objects.requireNonNull(otherSectionName);
        if (!samplesheet.containsSection("BCLConvert_Data")) {
            throw new KenetreException("No section BCLConvert_Data found in samplesheet");
        }
        if (samplesheet.containsSection(otherSectionName)) {
            throw new KenetreException("No section " + otherSectionName + " already found in samplesheet");
        }
        TableSection demuxTable = samplesheet.getTableSection("BCLConvert_Data");
        TableSection otherTable = samplesheet.addTableSection(otherSectionName);
        for (Sample s : demuxTable.getSamples()) {
            Sample newSample = otherTable.addSample();
            block12: for (String fieldName : s.getFieldNames()) {
                switch (fieldName.toLowerCase().trim()) {
                    case "_lane": 
                    case "_sampleid": 
                    case "_project": {
                        newSample.set(fieldName, s.get(fieldName));
                        continue block12;
                    }
                    case "_index1": 
                    case "_index2": {
                        continue block12;
                    }
                }
                newSample.set(fieldName, s.get(fieldName));
                s.remove(fieldName);
            }
        }
    }

    public static void mergeBclConvertDataAndForbiddenData(SampleSheet samplesheet, String otherSectionName) throws KenetreException {
        StringBuilder sb;
        Objects.requireNonNull(samplesheet);
        Objects.requireNonNull(otherSectionName);
        if (!samplesheet.containsTableSection(otherSectionName) || !samplesheet.containsTableSection("BCLConvert_Data")) {
            return;
        }
        TableSection demuxTable = samplesheet.getTableSection("BCLConvert_Data");
        TableSection otherTable = samplesheet.getTableSection(otherSectionName);
        HashMap<String, String> values = new HashMap<String, String>();
        HashSet<String> fieldsToAdd = new HashSet<String>();
        for (Sample s : otherTable.getSamples()) {
            sb = new StringBuilder();
            if (s.isSampleIdField()) {
                sb.append(s.getSampleId());
            }
            sb.append('\t');
            if (s.isLaneField()) {
                sb.append(s.getLane());
            }
            sb.append('\t');
            if (s.isSampleProjectField()) {
                sb.append(s.getSampleName());
            }
            sb.append('\t');
            String key = sb.toString();
            block9: for (String fieldName : s.getFieldNames()) {
                switch (fieldName.toLowerCase().trim()) {
                    case "_lane": 
                    case "_sampleid": 
                    case "_project": {
                        continue block9;
                    }
                }
                fieldsToAdd.add(fieldName);
                values.put(key + '\t' + fieldName, s.get(fieldName));
            }
        }
        for (Sample s : demuxTable.getSamples()) {
            sb = new StringBuilder();
            if (s.isSampleIdField()) {
                sb.append(s.getSampleId());
            }
            sb.append('\t');
            if (s.isLaneField()) {
                sb.append(s.getLane());
            }
            sb.append('\t');
            if (s.isSampleProjectField()) {
                sb.append(s.getSampleName());
            }
            sb.append('\t');
            String prefix = sb.toString();
            for (String fieldName : fieldsToAdd) {
                String key = prefix + '\t' + fieldName;
                if (!values.containsKey(key)) continue;
                s.set(fieldName, (String)values.get(key));
            }
        }
        samplesheet.removeSection(otherSectionName);
    }

    public static void replaceUnderscoresByDashesInSampleIds(SampleSheet samplesheet) throws KenetreException {
        Objects.requireNonNull(samplesheet);
        if (!samplesheet.containsSection("Data") && !samplesheet.containsSection("BCLConvert_Data")) {
            throw new KenetreException("No section demultiplexing found in samplesheet");
        }
        TableSection demuxTable = samplesheet.getDemuxSection();
        for (Sample s : demuxTable.getSamples()) {
            if (!s.isSampleIdField()) continue;
            s.setSampleId(s.getSampleId().replace('_', '-'));
        }
    }

    public static String serialize(SampleSheet sampleSheet) {
        return SampleSheetUtils.toSampleSheetV2CSV(sampleSheet);
    }

    public static SampleSheet deSerialize(String s) throws IOException {
        return SampleSheetUtils.parseCSVSamplesheet(s);
    }

    private SampleSheetUtils() {
    }
}

