/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io;

import fr.ens.biologie.genomique.kenetre.KenetreRuntimeException;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetParser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetReaderUtils;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetV1Parser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetV2Parser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SampleSheetDiscoverFormatParser
implements SampleSheetParser {
    private SampleSheetParser parser;
    private final List<List<String>> cache = new ArrayList<List<String>>();
    private final List<String> sampleSheetV1Hearder = Arrays.asList("FCID", "Lane", "SampleID", "SampleRef", "Index", "Description", "Control", "Recipe", "Operator", "SampleProject");
    private final List<String> normalizedSampleSheetV1Hearder = SampleSheetDiscoverFormatParser.normalizeHeader(this.sampleSheetV1Hearder);

    @Override
    public void parseLine(List<String> fields) throws IOException {
        SampleSheetReaderUtils.trimFields(fields);
        if (fields.isEmpty()) {
            return;
        }
        if (this.parser != null) {
            this.parser.parseLine(fields);
            return;
        }
        if (fields.get(0).startsWith("[")) {
            this.parser = new SampleSheetV2Parser();
            this.parser.parseLine(fields);
        } else if (this.normalizedSampleSheetV1Hearder.equals(SampleSheetDiscoverFormatParser.normalizeHeader(fields))) {
            this.parser = new SampleSheetV1Parser();
            this.parser.parseLine(this.sampleSheetV1Hearder);
        }
        if (this.parser != null) {
            for (List<String> fieldsCached : this.cache) {
                this.parser.parseLine(fieldsCached);
            }
            this.cache.clear();
            return;
        }
        this.cache.add(new ArrayList<String>(fields));
    }

    @Override
    public SampleSheet getSampleSheet() {
        if (this.parser == null) {
            throw new KenetreRuntimeException("Unable to discovert the format of the samplesheet to read");
        }
        return this.parser.getSampleSheet();
    }

    private static List<String> normalizeHeader(List<String> list) {
        if (list == null) {
            throw new NullPointerException("list argument cannot be null");
        }
        ArrayList<String> result = new ArrayList<String>(list);
        for (int i = 0; i < result.size(); ++i) {
            String value = (String)result.get(i);
            if (value == null) continue;
            result.set(i, value.trim().replaceAll("_", "").toLowerCase());
        }
        return result;
    }
}

