/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io;

import com.google.common.math.DoubleMath;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.SampleSheet;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetDiscoverFormatParser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetParser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetReader;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetV1Parser;
import fr.ens.biologie.genomique.kenetre.illumina.samplesheet.io.SampleSheetV2Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class SampleSheetXLSXReader
implements SampleSheetReader,
AutoCloseable {
    private final InputStream is;
    private int version = -1;

    @Override
    public SampleSheet read() throws IOException {
        SampleSheetParser parser;
        switch (this.version) {
            case -1: {
                parser = new SampleSheetDiscoverFormatParser();
                break;
            }
            case 1: {
                parser = new SampleSheetV1Parser();
                break;
            }
            case 2: {
                parser = new SampleSheetV2Parser();
                break;
            }
            default: {
                throw new IOException("Unknown bcl2fastq samplesheet format version: " + this.version);
            }
        }
        XSSFWorkbook wb = new XSSFWorkbook(this.is);
        XSSFSheet sheet = wb.getSheetAt(0);
        Iterator rows = sheet.rowIterator();
        ArrayList<String> fields = new ArrayList<String>();
        while (rows.hasNext()) {
            XSSFRow row = (XSSFRow)rows.next();
            Iterator cells = row.cellIterator();
            while (cells.hasNext()) {
                XSSFCell cell = (XSSFCell)cells.next();
                while (fields.size() != cell.getColumnIndex()) {
                    fields.add("");
                }
                fields.add(SampleSheetXLSXReader.parseCell(cell));
            }
            if (!SampleSheetXLSXReader.isFieldsEmpty(fields)) {
                parser.parseLine(fields);
            }
            fields.clear();
        }
        wb.close();
        this.close();
        return parser.getSampleSheet();
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    private static String parseCell(XSSFCell cell) {
        double doubleValue;
        if (cell.getCellType() == CellType.NUMERIC && DoubleMath.isMathematicalInteger((double)(doubleValue = cell.getNumericCellValue()))) {
            return Long.toString((long)doubleValue);
        }
        return cell.toString();
    }

    private static boolean isFieldsEmpty(List<String> list) {
        if (list == null) {
            return true;
        }
        for (String e : list) {
            if (e == null || "".equals(e.trim())) continue;
            return false;
        }
        return true;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public int getVersion() {
        return this.version;
    }

    public SampleSheetXLSXReader(InputStream is) {
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        this.is = is;
    }

    public SampleSheetXLSXReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        if (!file.isFile()) {
            throw new FileNotFoundException("File not found: " + file.getAbsolutePath());
        }
        this.is = new FileInputStream(file);
    }

    public SampleSheetXLSXReader(Path file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            throw new FileNotFoundException("File not found: " + file);
        }
        this.is = Files.newInputStream(file, new OpenOption[0]);
    }

    public SampleSheetXLSXReader(String filename) throws FileNotFoundException {
        this(new File(filename));
    }
}

