/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import htsjdk.samtools.cram.build.CramContainerIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.seqdoop.hadoop_bam.CRAMRecordReader;
import org.seqdoop.hadoop_bam.SAMRecordWritable;
import org.seqdoop.hadoop_bam.util.WrapSeekable;

public class CRAMInputFormat
extends FileInputFormat<LongWritable, SAMRecordWritable> {
    public static final String REFERENCE_SOURCE_PATH_PROPERTY = "hadoopbam.cram.reference-source-path";

    public List<InputSplit> getSplits(JobContext job) throws IOException {
        return this.getSplits(super.getSplits(job), job.getConfiguration());
    }

    public List<InputSplit> getSplits(List<InputSplit> splits, Configuration conf) throws IOException {
        ArrayList<InputSplit> newSplits = new ArrayList<InputSplit>();
        HashMap<Path, List<Long>> fileToOffsets = new HashMap<Path, List<Long>>();
        for (InputSplit split : splits) {
            FileSplit fileSplit = (FileSplit)split;
            Path path = fileSplit.getPath();
            List<Long> containerOffsets = (List<Long>)fileToOffsets.get(path);
            if (containerOffsets == null) {
                containerOffsets = CRAMInputFormat.getContainerOffsets(conf, path);
                fileToOffsets.put(path, containerOffsets);
            }
            long newStart = CRAMInputFormat.nextContainerOffset(containerOffsets, fileSplit.getStart());
            long newEnd = CRAMInputFormat.nextContainerOffset(containerOffsets, fileSplit.getStart() + fileSplit.getLength());
            long newLength = newEnd - newStart;
            if (newLength == 0L) continue;
            FileSplit newSplit = new FileSplit(fileSplit.getPath(), newStart, newLength, fileSplit.getLocations());
            newSplits.add((InputSplit)newSplit);
        }
        return newSplits;
    }

    private static List<Long> getContainerOffsets(Configuration conf, Path cramFile) throws IOException {
        WrapSeekable<FSDataInputStream> seekableStream = WrapSeekable.openPath(conf, cramFile);
        CramContainerIterator cci = new CramContainerIterator(seekableStream);
        ArrayList<Long> containerOffsets = new ArrayList<Long>();
        containerOffsets.add(seekableStream.position());
        while (cci.hasNext()) {
            cci.next();
            containerOffsets.add(seekableStream.position());
        }
        containerOffsets.add(seekableStream.length());
        return containerOffsets;
    }

    private static long nextContainerOffset(List<Long> containerOffsets, long position) {
        for (long offset : containerOffsets) {
            if (offset < position) continue;
            return offset;
        }
        throw new IllegalStateException("Could not find position " + position + " in container offsets: " + containerOffsets);
    }

    public RecordReader<LongWritable, SAMRecordWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        CRAMRecordReader rr = new CRAMRecordReader();
        rr.initialize(split, context);
        return rr;
    }

    public boolean isSplitable(JobContext job, Path path) {
        return true;
    }
}

