/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;

public final class SplittingBAMIndex {
    private final NavigableSet<Long> virtualOffsets = new TreeSet<Long>();

    public SplittingBAMIndex() {
    }

    public SplittingBAMIndex(File path) throws IOException {
        this(new BufferedInputStream(new FileInputStream(path)));
    }

    public SplittingBAMIndex(InputStream in) throws IOException {
        this.readIndex(in);
    }

    public void readIndex(InputStream in) throws IOException {
        this.virtualOffsets.clear();
        ByteBuffer bb = ByteBuffer.allocate(8);
        long prev = -1L;
        while (in.read(bb.array()) == 8) {
            long cur = bb.getLong(0);
            if (prev > cur) {
                throw new IOException(String.format("Invalid splitting BAM index; offsets not in order: %#x > %#x", prev, cur));
            }
            prev = cur;
            this.virtualOffsets.add(prev);
        }
        in.close();
        if (this.virtualOffsets.size() < 1) {
            throw new IOException("Invalid splitting BAM index: should contain at least the file size");
        }
    }

    public List<Long> getVirtualOffsets() {
        return new ArrayList<Long>(this.virtualOffsets);
    }

    public Long prevAlignment(long filePos) {
        return this.virtualOffsets.floor(filePos << 16);
    }

    public Long nextAlignment(long filePos) {
        return this.virtualOffsets.higher(filePos << 16);
    }

    public int size() {
        return this.virtualOffsets.size();
    }

    private long first() {
        return (Long)this.virtualOffsets.first();
    }

    private long last() {
        return this.prevAlignment(this.bamSize() - 1L);
    }

    long bamSize() {
        return (Long)this.virtualOffsets.last() >>> 16;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SplittingBAMIndex that = (SplittingBAMIndex)o;
        return this.virtualOffsets != null ? this.virtualOffsets.equals(that.virtualOffsets) : that.virtualOffsets == null;
    }

    public int hashCode() {
        return this.virtualOffsets != null ? this.virtualOffsets.hashCode() : 0;
    }

    public String toString() {
        return this.virtualOffsets.toString();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: SplittingBAMIndex [splitting BAM indices...]\n\nWrites a few statistics about each splitting BAM index.");
            return;
        }
        for (String arg : args) {
            File f = new File(arg);
            if (f.isFile() && f.canRead()) {
                try {
                    System.err.printf("%s:\n", f);
                    SplittingBAMIndex bi = new SplittingBAMIndex(f);
                    if (bi.size() == 1) {
                        System.err.printf("\t0 alignments\n\tassociated BAM file size %d\n", bi.bamSize());
                        continue;
                    }
                    long first = bi.first();
                    long last = bi.last();
                    System.err.printf("\t%d alignments\n\tfirst is at %#06x in BGZF block at %#014x\n\tlast  is at %#06x in BGZF block at %#014x\n\tassociated BAM file size %d\n", bi.size(), first & 0xFFFFL, first >>> 16, last & 0xFFFFL, last >>> 16, bi.bamSize());
                }
                catch (IOException e) {
                    System.err.printf("Failed to read %s!\n", f);
                    e.printStackTrace();
                }
                continue;
            }
            System.err.printf("%s does not look like a readable file!\n", f);
        }
    }
}

