/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;

class BGZFSplitCompressionInputStream
extends SplitCompressionInputStream {
    private static final int END_OF_BLOCK = -2;
    private final BlockCompressedInputStream input;
    private BufferedInputStream bufferedIn;
    private long startingPos = 0L;
    private long processedPosition;
    POS_ADVERTISEMENT_STATE_MACHINE posSM = POS_ADVERTISEMENT_STATE_MACHINE.HOLD;
    long compressedStreamPosition = 0L;

    public BGZFSplitCompressionInputStream(InputStream in, long start, long end) throws IOException {
        super(in, start, end);
        this.bufferedIn = new BufferedInputStream(this.in);
        this.startingPos = super.getPos();
        this.input = new BlockCompressedInputStream((InputStream)this.bufferedIn);
        this.updatePos(false);
    }

    public int read() throws IOException {
        byte[] b = new byte[1];
        int result = this.read(b, 0, 1);
        return result < 0 ? result : b[0] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.readWithinBlock(b, off, len);
        if (result == -2) {
            this.posSM = POS_ADVERTISEMENT_STATE_MACHINE.ADVERTISE;
        }
        if (this.posSM == POS_ADVERTISEMENT_STATE_MACHINE.ADVERTISE) {
            result = this.readWithinBlock(b, off, off + 1);
            this.updatePos(true);
            this.posSM = POS_ADVERTISEMENT_STATE_MACHINE.HOLD;
        }
        return result;
    }

    private int readWithinBlock(byte[] b, int off, int len) throws IOException {
        if (this.input.endOfBlock()) {
            int available = this.input.available();
            this.processedPosition = this.input.getPosition() >> 16;
            if (available == 0) {
                return -1;
            }
            return -2;
        }
        int available = this.input.available();
        return this.input.read(b, off, Math.min(available, len));
    }

    public void resetState() throws IOException {
    }

    public long getPos() throws IOException {
        return this.compressedStreamPosition;
    }

    private void updatePos(boolean shouldAddOn) {
        int addOn = shouldAddOn ? 1 : 0;
        this.compressedStreamPosition = this.startingPos + this.processedPosition + (long)addOn;
    }

    public void close() throws IOException {
        this.input.close();
    }

    private static enum POS_ADVERTISEMENT_STATE_MACHINE {
        HOLD,
        ADVERTISE;

    }
}

