/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.seekablestream.ByteArraySeekableStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Seekable;

public class BGZFSplitGuesser {
    private InputStream inFile;
    private Seekable seekableInFile;
    private ByteArraySeekableStream in;
    private final ByteBuffer buf;
    private static final int BGZF_MAGIC = 67668767;
    private static final int BGZF_MAGIC_SUB = 148290;
    private static final int BGZF_SUB_SIZE = 6;

    public BGZFSplitGuesser(InputStream is) {
        this.inFile = is;
        this.seekableInFile = (Seekable)is;
        this.buf = ByteBuffer.allocate(8);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public BGZFSplitGuesser(FSDataInputStream is) {
        this.inFile = is;
        this.seekableInFile = is;
        this.buf = ByteBuffer.allocate(8);
        this.buf.order(ByteOrder.LITTLE_ENDIAN);
    }

    public long guessNextBGZFBlockStart(long beg, long end) throws IOException {
        int r;
        byte[] arr = new byte[131069];
        this.seekableInFile.seek(beg);
        int totalRead = 0;
        for (int left = Math.min((int)(end - beg), arr.length); left > 0 && (r = this.inFile.read(arr, totalRead, left)) >= 0; left -= r) {
            totalRead += r;
        }
        arr = Arrays.copyOf(arr, totalRead);
        this.in = new ByteArraySeekableStream(arr);
        BlockCompressedInputStream bgzf = new BlockCompressedInputStream((SeekableStream)this.in);
        bgzf.setCheckCrcs(true);
        int firstBGZFEnd = Math.min((int)(end - beg), 65535);
        int pos = 0;
        while (true) {
            if ((pos = this.guessNextBGZFPos(pos, firstBGZFEnd)) < 0) {
                return end;
            }
            try {
                bgzf.seek((long)pos << 16);
            }
            catch (Throwable e) {
                ++pos;
                continue;
            }
            break;
        }
        return beg + (long)pos;
    }

    private int guessNextBGZFPos(int p, int end) throws IOException {
        while (true) {
            this.in.seek((long)p);
            this.in.read(this.buf.array(), 0, 4);
            int n = this.buf.getInt(0);
            if (n != 67668767) {
                p = n >>> 8 == 559903 ? ++p : (n >>> 16 == 35615 ? (p += 2) : (p += 3));
                if (p < end) continue;
                return -1;
            }
            int p0 = p;
            this.in.seek((long)(p += 10));
            this.in.read(this.buf.array(), 0, 2);
            int xlen = this.getUShort(0);
            int subEnd = (p += 2) + xlen;
            while (p < subEnd) {
                this.in.read(this.buf.array(), 0, 4);
                if (this.buf.getInt(0) != 148290) {
                    this.in.seek((long)(p += 4 + this.getUShort(2)));
                    continue;
                }
                return p0;
            }
            p = p0 + 4;
        }
    }

    private int getUShort(int idx) {
        return this.buf.getShort(idx) & 0xFFFF;
    }
}

