/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import com.google.common.collect.ImmutableList;
import htsjdk.samtools.util.Interval;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.seqdoop.hadoop_bam.FormatException;

public final class IntervalUtil {
    private IntervalUtil() {
    }

    public static List<Interval> getIntervals(Configuration conf, String intervalPropertyName) {
        String intervalsProperty = conf.get(intervalPropertyName);
        if (intervalsProperty == null) {
            return null;
        }
        if (intervalsProperty.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        for (String s : intervalsProperty.split(",")) {
            int lastColonIdx = s.lastIndexOf(58);
            if (lastColonIdx < 0) {
                throw new FormatException("no colon found in interval string: " + s);
            }
            int hyphenIdx = s.indexOf(45, lastColonIdx + 1);
            if (hyphenIdx < 0) {
                throw new FormatException("no hyphen found after colon interval string: " + s);
            }
            String sequence = s.substring(0, lastColonIdx);
            int start = IntervalUtil.parseIntOrThrowFormatException(s.substring(lastColonIdx + 1, hyphenIdx), "invalid start position", s);
            int stop = IntervalUtil.parseIntOrThrowFormatException(s.substring(hyphenIdx + 1), "invalid stop position", s);
            intervals.add(new Interval(sequence, start, stop));
        }
        return intervals;
    }

    private static int parseIntOrThrowFormatException(String str, String error, String input) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ex) {
            throw new FormatException(error + " in  interval '" + input + "': '" + str + "'");
        }
    }
}

