/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class NIOFileUtil {
    static final String PARTS_GLOB = "glob:**/part-[mr]-[0-9][0-9][0-9][0-9][0-9]*";

    private NIOFileUtil() {
    }

    public static Path asPath(URI uri) {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                throw e;
            }
            try {
                return FileSystems.newFileSystem(uri, new HashMap(), cl).provider().getPath(uri);
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot create filesystem for " + uri, ex);
            }
        }
    }

    public static Path asPath(String path) {
        URI uri = URI.create(path);
        return uri.getScheme() == null ? Paths.get(path, new String[0]) : NIOFileUtil.asPath(uri);
    }

    static void deleteRecursive(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.deleteIfExists(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    static List<Path> getFilesMatching(Path directory, String syntaxAndPattern, String excludesExt) throws IOException {
        PathMatcher matcher = directory.getFileSystem().getPathMatcher(syntaxAndPattern);
        List<Path> parts = Files.walk(directory, new FileVisitOption[0]).filter(matcher::matches).filter(path -> excludesExt == null || !path.toString().endsWith(excludesExt)).collect(Collectors.toList());
        Collections.sort(parts);
        return parts;
    }

    static void mergeInto(List<Path> parts, OutputStream out) throws IOException {
        for (Path part : parts) {
            Files.copy(part, out);
            Files.delete(part);
        }
    }
}

