/*
 * Decompiled with CFR 0.152.
 */
package org.seqdoop.hadoop_bam.util;

import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.FeatureCodecHeader;
import htsjdk.tribble.TribbleException;
import htsjdk.tribble.readers.AsciiLineReader;
import htsjdk.tribble.readers.AsciiLineReaderIterator;
import htsjdk.tribble.readers.LineIterator;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.vcf.VCFCodec;
import htsjdk.variant.vcf.VCFHeader;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.seqdoop.hadoop_bam.VCFFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VCFHeaderReader {
    private static final Logger logger = LoggerFactory.getLogger(VCFHeaderReader.class);

    public static VCFHeader readHeaderFrom(SeekableStream in) throws IOException {
        FeatureCodecHeader headerCodec = null;
        Object header = null;
        long initialPos = in.position();
        try {
            BufferedInputStream bis = new BufferedInputStream((InputStream)in);
            FilterInputStream is = VCFFormat.isGzip(bis) ? new GZIPInputStream(bis) : bis;
            headerCodec = new VCFCodec().readHeader((LineIterator)new AsciiLineReaderIterator(new AsciiLineReader((InputStream)is)));
        }
        catch (TribbleException e) {
            logger.warn("Exception while trying to read VCF header from file:", (Throwable)e);
            in.seek(initialPos);
            BufferedInputStream bin = new BufferedInputStream((InputStream)in);
            if (BlockCompressedInputStream.isValidFile((InputStream)bin)) {
                bin = new BlockCompressedInputStream((InputStream)bin);
            }
            headerCodec = new BCF2Codec().readHeader(new PositionalBufferedStream((InputStream)bin));
        }
        if (!(headerCodec instanceof FeatureCodecHeader)) {
            throw new IOException("No VCF header found");
        }
        header = headerCodec.getHeaderValue();
        return (VCFHeader)header;
    }
}

