/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.AbstractMapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.BowtieMapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.EntryMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProcess;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperUtils;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractBowtieMapperProvider
extends AbstractMapperProvider {
    protected static final String SYNC = AbstractBowtieMapperProvider.class.getName();
    private static final String SHORT_INDEX_FLAVOR = "standard";
    private static final String LARGE_INDEX_FLAVOR = "large-index";

    protected abstract String getExtensionIndexFile(EntryMapping var1);

    @Override
    public String getDefaultFlavor() {
        return SHORT_INDEX_FLAVOR;
    }

    @Override
    public boolean isMultipleInstancesAllowed() {
        return true;
    }

    @Override
    public boolean checkIfFlavorExists(MapperInstance mapperInstance) {
        if (mapperInstance.getFlavor() == null) {
            return true;
        }
        switch (mapperInstance.getFlavor().trim().toLowerCase()) {
            case "standard": {
                return true;
            }
            case "large-index": {
                return true;
            }
        }
        return false;
    }

    protected boolean isLongIndexFlavor(EntryMapping mapping, Version firstFlavoredVersion) {
        Version currentVersion = new Version(mapping.getVersion());
        if (currentVersion.greaterThanOrEqualTo(firstFlavoredVersion)) {
            String flavor = mapping.getFlavor();
            return flavor != null && LARGE_INDEX_FLAVOR.equals(flavor.trim().toLowerCase());
        }
        return false;
    }

    protected String flavoredBinary(String version, String flavor, String binary, Version firstFlavoredVersion) {
        return this.flavoredBinary(version, flavor, binary, binary, firstFlavoredVersion);
    }

    protected String flavoredBinary(String version, String flavor, String binary, String newBinary, Version firstFlavoredVersion) {
        Version currentVersion = new Version(version);
        if (currentVersion.greaterThanOrEqualTo(firstFlavoredVersion)) {
            if (flavor != null && LARGE_INDEX_FLAVOR.equals(flavor.trim().toLowerCase())) {
                return newBinary + "-l";
            }
            return newBinary + "-s";
        }
        return binary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readBinaryVersion(MapperInstance mapperInstance) {
        try {
            String bowtiePath;
            String string = SYNC;
            synchronized (string) {
                bowtiePath = mapperInstance.getExecutor().install(this.getMapperExecutableName(mapperInstance));
            }
            ArrayList cmd = Lists.newArrayList((Object[])new String[]{bowtiePath, "--version"});
            String s = MapperUtils.executeToString(mapperInstance.getExecutor(), cmd);
            String[] lines = s.split("\n");
            if (lines.length == 0) {
                return null;
            }
            String[] tokens = lines[0].split(" version ");
            if (tokens.length > 1) {
                return tokens[1].trim();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public List<String> getIndexerCommand(File indexerFile, File genomeFile, List<String> indexerArguments, int threads) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(indexerFile.getAbsolutePath());
        cmd.add(genomeFile.getAbsolutePath());
        cmd.add("genome");
        return cmd;
    }

    protected String bowtieQualityArgument(EntryMapping mapping) {
        return BowtieMapperProvider.getBowtieQualityArgument(mapping.getFastqFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperProcess mapSE(final EntryMapping mapping, File inputFile, File errorFile, File logFile) throws IOException {
        String bowtiePath;
        String string = SYNC;
        synchronized (string) {
            bowtiePath = mapping.getExecutor().install(this.getMapperExecutableName(mapping.getMapperInstance()));
        }
        final String index = this.getIndexArgument(mapping);
        return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, false, inputFile){

            @Override
            protected List<List<String>> createCommandLines() {
                ArrayList<String> cmd = new ArrayList<String>(AbstractBowtieMapperProvider.this.createCommonArgs(mapping, bowtiePath, index));
                if (mapping.isMultipleInstancesEnabled()) {
                    cmd.add("--mm");
                }
                cmd.add(this.getNamedPipeFile1().getAbsolutePath());
                return Collections.singletonList(cmd);
            }

            @Override
            protected File executionDirectory() {
                return mapping.getIndexDirectory();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperProcess mapPE(final EntryMapping mapping, File inputFile1, File inputFile2, File errorFile, File logFile) throws IOException {
        String bowtiePath;
        String string = SYNC;
        synchronized (string) {
            bowtiePath = mapping.getExecutor().install(this.getMapperExecutableName(mapping.getMapperInstance()));
        }
        final String index = this.getIndexArgument(mapping);
        return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, true, inputFile1, inputFile2){

            @Override
            protected List<List<String>> createCommandLines() {
                ArrayList<String> cmd = new ArrayList<String>(AbstractBowtieMapperProvider.this.createCommonArgs(mapping, bowtiePath, index));
                if (mapping.isMultipleInstancesEnabled()) {
                    cmd.add("--mm");
                }
                cmd.add("-1");
                cmd.add(this.getNamedPipeFile1().getAbsolutePath());
                cmd.add("-2");
                cmd.add(this.getNamedPipeFile2().getAbsolutePath());
                return Collections.singletonList(cmd);
            }

            @Override
            protected File executionDirectory() {
                return mapping.getIndexDirectory();
            }
        };
    }

    private String getIndexArgument(EntryMapping mapping) throws IOException {
        String extensionIndexFile = this.getExtensionIndexFile(mapping);
        return MapperUtils.getIndexPath(this.getName(), mapping.getIndexDirectory(), extensionIndexFile, extensionIndexFile.length()).getName();
    }

    protected abstract List<String> createCommonArgs(EntryMapping var1, String var2, String var3);
}

