/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.AbstractBowtieMapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.EntryMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Bowtie2MapperProvider
extends AbstractBowtieMapperProvider {
    public static final String MAPPER_NAME = "Bowtie2";
    private static final String DEFAULT_VERSION = "2.0.6";
    public static final String DEFAULT_ARGUMENTS = "-k 2";
    private static final Version FIRST_FLAVORED_VERSION = new Version(2, 2, 0);
    private static final String MAPPER_EXECUTABLE = "bowtie2-align";
    private static final String INDEXER_EXECUTABLE = "bowtie2-build";
    private static final String EXTENSION_INDEX_FILE = ".rev.1.bt2";

    @Override
    public String getName() {
        return MAPPER_NAME;
    }

    @Override
    public String getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    @Override
    protected String getExtensionIndexFile(EntryMapping mapping) {
        return EXTENSION_INDEX_FILE + (this.isLongIndexFlavor(mapping, FIRST_FLAVORED_VERSION) ? "l" : "");
    }

    @Override
    public List<String> getIndexerExecutables(MapperInstance mapperInstance) {
        return Collections.singletonList(this.flavoredBinary(mapperInstance.getVersion(), mapperInstance.getFlavor(), INDEXER_EXECUTABLE, FIRST_FLAVORED_VERSION));
    }

    @Override
    public String getMapperExecutableName(MapperInstance mapperInstance) {
        return this.flavoredBinary(mapperInstance.getVersion(), mapperInstance.getFlavor(), MAPPER_EXECUTABLE, FIRST_FLAVORED_VERSION);
    }

    @Override
    public String getDefaultMapperArguments() {
        return DEFAULT_ARGUMENTS;
    }

    protected static String getBowtieQualityArgument(FastqFormat format) throws Exception {
        switch (format) {
            case FASTQ_SOLEXA: {
                throw new Exception("Format " + format.getName() + " not available with bowtie2");
            }
            case FASTQ_ILLUMINA: 
            case FASTQ_ILLUMINA_1_5: {
                return "--phred64";
            }
        }
        return "--phred33";
    }

    @Override
    protected List<String> createCommonArgs(EntryMapping mapping, String bowtiePath, String index) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(bowtiePath);
        result.addAll(mapping.getMapperArguments());
        if (!mapping.isMultipleInstancesEnabled()) {
            result.add("-p");
            result.add(mapping.getThreadNumber() + "");
        } else {
            result.add("--mm");
        }
        result.add("-q");
        result.add(this.bowtieQualityArgument(mapping));
        result.add("-x");
        result.add(index);
        return result;
    }
}

