/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.AbstractBowtieMapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.EntryMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BowtieMapperProvider
extends AbstractBowtieMapperProvider {
    public static final String MAPPER_NAME = "Bowtie";
    private static final String DEFAULT_VERSION = "0.12.9";
    public static final String DEFAULT_ARGUMENTS = "--best -k 2";
    private static final Version FIRST_FLAVORED_VERSION = new Version(1, 1, 0);
    private static final String MAPPER_EXECUTABLE = "bowtie";
    private static final String MAPPER_NEW_EXECUTABLE = "bowtie-align";
    private static final String INDEXER_EXECUTABLE = "bowtie-build";
    private static final String EXTENSION_INDEX_FILE = ".rev.1.ebwt";

    @Override
    public String getName() {
        return MAPPER_NAME;
    }

    @Override
    public String getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    @Override
    protected String getExtensionIndexFile(EntryMapping mapping) {
        return EXTENSION_INDEX_FILE + (this.isLongIndexFlavor(mapping, FIRST_FLAVORED_VERSION) ? "l" : "");
    }

    @Override
    public List<String> getIndexerExecutables(MapperInstance mapperInstance) {
        return Collections.singletonList(this.flavoredBinary(mapperInstance.getVersion(), mapperInstance.getFlavor(), INDEXER_EXECUTABLE, FIRST_FLAVORED_VERSION));
    }

    @Override
    public String getMapperExecutableName(MapperInstance mapperInstance) {
        return this.flavoredBinary(mapperInstance.getVersion(), mapperInstance.getFlavor(), MAPPER_EXECUTABLE, MAPPER_NEW_EXECUTABLE, FIRST_FLAVORED_VERSION);
    }

    protected static String getBowtieQualityArgument(FastqFormat format) {
        switch (format) {
            case FASTQ_SOLEXA: {
                return "--solexa-quals";
            }
            case FASTQ_ILLUMINA: 
            case FASTQ_ILLUMINA_1_5: {
                return "--phred64-quals";
            }
        }
        return "--phred33-quals";
    }

    @Override
    public String getDefaultMapperArguments() {
        return DEFAULT_ARGUMENTS;
    }

    @Override
    protected List<String> createCommonArgs(EntryMapping mapping, String bowtiePath, String index) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(bowtiePath);
        result.addAll(mapping.getMapperArguments());
        if (!mapping.isMultipleInstancesEnabled()) {
            result.add("-p");
            result.add(mapping.getThreadNumber() + "");
        } else {
            result.add("--mm");
        }
        result.add("-q");
        result.add(this.bowtieQualityArgument(mapping));
        result.add("-S");
        result.add(index);
        return result;
    }
}

