/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperExecutor;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public abstract class MapperProcess {
    private final String mapperName;
    private final String uuid;
    private final MapperExecutor executor;
    private final boolean pairedEnd;
    private final List<MapperExecutor.Result> processResults = new ArrayList<MapperExecutor.Result>();
    private InputStream stdout;
    private final File pipeFile1;
    private final File pipeFile2;
    private final File stdErrFile;
    private final FastqWriter writer1;
    private final FastqWriter writer2;
    private final File temporaryDirectory;
    private String commandLine;
    private ReporterIncrementer incrementer;
    private String counterGroup;
    private final List<File> filesToRemove = new ArrayList<File>();

    protected abstract List<List<String>> createCommandLines();

    protected File executionDirectory() {
        return null;
    }

    protected InputStream createCustomInputStream(InputStream stdout) throws IOException {
        return stdout;
    }

    protected String getUUID() {
        return this.uuid;
    }

    public boolean isPairedEnd() {
        return this.pairedEnd;
    }

    protected File getNamedPipeFile1() {
        return this.pipeFile1;
    }

    protected File getNamedPipeFile2() {
        return this.pipeFile2;
    }

    protected void inputReadsIncr() {
        if (this.incrementer != null) {
            this.incrementer.incrCounter(this.counterGroup, "mapper input reads", 1L);
        }
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public void setIncrementer(ReporterIncrementer incrementer, String counterGroup) {
        if (counterGroup == null) {
            throw new NullPointerException("The counterGroup is null");
        }
        this.incrementer = incrementer;
        this.counterGroup = counterGroup;
    }

    public InputStream getStout() {
        return this.stdout;
    }

    public void toFile(File outputFile) throws IOException {
        Thread tout = new Thread(new ProcessThreadStdOut(this.getStdoutProcessResult(), new FileOutputStream(outputFile)));
        tout.start();
    }

    public void writeEntry(String name, String sequence, String quality) throws IOException {
        if (this.pairedEnd) {
            throw new IllegalStateException("Cannot use this writeEntry method in paired-end mode");
        }
        this.writer1.write(ReadSequence.toFastQ((String)name, (String)sequence, (String)quality) + '\n');
        this.inputReadsIncr();
    }

    public void writeEntry1(ReadSequence read) throws IOException {
        if (read == null) {
            return;
        }
        this.writer1.write(read.toFastQ() + '\n');
        this.inputReadsIncr();
    }

    public void writeEntry2(ReadSequence read) throws IOException {
        if (!this.pairedEnd) {
            throw new IllegalStateException("Cannot use this writeEntry method in paired-end mode");
        }
        if (read == null) {
            return;
        }
        this.writer2.write(read.toFastQ() + '\n');
    }

    public void writeEntry(String name1, String sequence1, String quality1, String name2, String sequence2, String quality2) throws IOException {
        if (!this.pairedEnd) {
            throw new IllegalStateException("Cannot use this writeEntry method in single-end mode");
        }
        this.writer1.write(ReadSequence.toFastQ((String)name1, (String)sequence1, (String)quality1) + '\n');
        this.writer2.write(ReadSequence.toFastQ((String)name2, (String)sequence2, (String)quality2) + '\n');
        this.inputReadsIncr();
    }

    public void closeWriter1() throws IOException {
        if (this.writer1 != null) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.writer1.close();
        }
    }

    public void closeWriter2() throws IOException {
        if (this.writer2 != null) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.writer2.close();
        }
    }

    public void closeEntriesWriter() throws IOException, InterruptedException {
        if (this.writer1 != null) {
            this.writer1.close();
        }
        if (this.writer2 != null) {
            this.writer2.close();
        }
    }

    private MapperExecutor.Result getStdoutProcessResult() {
        int index = this.processResults.size() - 1;
        if (index < 0) {
            throw new IllegalStateException("No mapper process has been launched");
        }
        return this.processResults.get(index);
    }

    void startProcess() throws IOException {
        try {
            this.startProcess(this.temporaryDirectory);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void startProcess(File tmpDirectory) throws IOException, InterruptedException {
        List<List<String>> cmds = this.createCommandLines();
        this.commandLine = MapperProcess.commandLinesToString(cmds);
        File executionDirectory = this.executionDirectory() == null ? tmpDirectory : this.executionDirectory();
        for (int i = 0; i < cmds.size(); ++i) {
            boolean last = i == cmds.size() - 1;
            MapperExecutor.Result result = this.executor.execute(cmds.get(i), executionDirectory, last, this.stdErrFile, false, this.pipeFile1, this.pipeFile2);
            this.processResults.add(result);
            if (!last) {
                Thread.sleep(1000L);
                continue;
            }
            this.stdout = new InputStreamWrapper(this.createCustomInputStream(result.getInputStream()));
        }
    }

    public void waitFor() throws IOException {
        for (MapperExecutor.Result result : this.processResults) {
            int exitValue = result.waitFor();
            this.executor.getLogger().debug("End of process with " + exitValue + " exit value");
            if (exitValue == 0) continue;
            throw new IOException("Bad error result for " + this.mapperName + " execution: " + exitValue);
        }
        for (File f : this.filesToRemove) {
            this.removeFile(f);
        }
    }

    private void removeFile(File f) {
        if (f != null && f.exists() && !f.delete()) {
            this.executor.getLogger().warn("Cannot remove temporary file: " + f);
        }
    }

    private static Writer createPipeWriter(File file) throws IOException {
        FileUtils.createNamedPipe((File)file);
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        OutputStream os = Channels.newOutputStream(raf.getChannel());
        return new OutputStreamWriter(os, StandardCharsets.ISO_8859_1);
    }

    protected void addFilesToRemove(File ... files) {
        if (files == null) {
            return;
        }
        Collections.addAll(this.filesToRemove, files);
    }

    protected void additionalInit() throws IOException {
    }

    private static String commandLinesToString(List<List<String>> cmds) {
        if (cmds == null) {
            return "";
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (List<String> cmd : cmds) {
            if (cmd == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append(" ; ");
            }
            sb.append(String.join((CharSequence)" ", cmd));
        }
        return sb.toString();
    }

    protected MapperProcess(String mapperName, MapperExecutor executor, File temporaryDirectory, File stdErrFile, boolean pairedEnd) throws IOException {
        this(mapperName, executor, temporaryDirectory, stdErrFile, pairedEnd, false);
    }

    protected MapperProcess(String mapperName, MapperExecutor executor, File temporaryDirectory, File stdErrFile, boolean pairedEnd, File inputFile1, File inputFile2) throws IOException {
        this(mapperName, executor, temporaryDirectory, stdErrFile, pairedEnd, false, inputFile1, inputFile2);
    }

    protected MapperProcess(String mapperName, MapperExecutor executor, File temporaryDirectory, File stdErrFile, boolean pairedEnd, File inputFile) throws IOException {
        this(mapperName, executor, temporaryDirectory, stdErrFile, pairedEnd, false, inputFile, null);
    }

    protected MapperProcess(String mapperName, MapperExecutor executor, File temporaryDirectory, File stdErrFile, boolean pairedEnd, boolean threadForRead1) throws IOException {
        this(mapperName, executor, temporaryDirectory, stdErrFile, pairedEnd, threadForRead1, null, null);
    }

    protected MapperProcess(String mapperName, MapperExecutor executor, File temporaryDirectory, File stdErrFile, boolean pairedEnd, boolean threadForRead1, File inputFile1, File inputFile2) throws IOException {
        Objects.requireNonNull(mapperName, "mapperName argument cannot be null");
        Objects.requireNonNull(executor, "executor argument cannot be null");
        Objects.requireNonNull(temporaryDirectory, "temporaryDirectory argument cannot be null");
        this.mapperName = mapperName;
        this.uuid = UUID.randomUUID().toString();
        this.executor = executor;
        this.pairedEnd = pairedEnd;
        this.temporaryDirectory = temporaryDirectory;
        this.pipeFile1 = inputFile1 != null ? inputFile1 : new File(this.temporaryDirectory, "mapper-inputfile1-" + this.uuid + ".fq");
        this.pipeFile2 = inputFile2 != null ? inputFile2 : new File(this.temporaryDirectory, "mapper-inputfile2-" + this.uuid + ".fq");
        this.stdErrFile = stdErrFile;
        if (inputFile1 == null) {
            this.writer1 = threadForRead1 ? new FastqWriterThread(this.pipeFile1, "FastqWriterThread fastq1") : new FastqWriterNoThread(this.pipeFile1);
            this.writer2 = pairedEnd ? new FastqWriterThread(this.pipeFile2, "FastqWriterThread fastq2") : null;
            this.addFilesToRemove(this.pipeFile1, this.pipeFile2);
        } else {
            this.writer1 = null;
            this.writer2 = null;
        }
        this.additionalInit();
    }

    static class FastqWriterThread
    extends Thread
    implements FastqWriter {
        private static final int MAX_CAPACITY = 100000;
        private static final int MIN_LINE_SIZE = 1000;
        private volatile boolean closed;
        private final BlockingDeque<String> queue = new LinkedBlockingDeque<String>(100000);
        private final Writer writer;
        private Exception exception;
        private int lineCount;
        private final StringBuilder buffer = new StringBuilder();

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block3: while (true) {
                    if (this.closed && this.queue.isEmpty()) {
                        this.writer.close();
                        return;
                    }
                    if (!this.queue.isEmpty()) {
                        while (true) {
                            if (this.queue.isEmpty()) continue block3;
                            this.writer.write(this.queue.take());
                        }
                    }
                    Thread.sleep(1000L);
                }
            }
            catch (IOException e) {
                this.exception = e;
                return;
            }
            catch (InterruptedException e) {
                this.exception = new IOException(e);
            }
        }

        @Override
        public void write(String s) throws IOException {
            if (this.closed) {
                throw new IllegalStateException("FastqWriterThread is closed");
            }
            this.buffer.append(s);
            ++this.lineCount;
            if (this.buffer.length() < 1000 || this.lineCount % 4 != 0) {
                return;
            }
            if (this.queue.remainingCapacity() == 0) {
                this.writer.flush();
                while (this.queue.remainingCapacity() == 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.queue.add(this.buffer.toString());
            this.buffer.setLength(0);
            this.lineCount = 0;
            this.throwExceptionIfExists();
        }

        @Override
        public void close() throws IOException {
            this.queue.add(this.buffer.toString());
            this.buffer.setLength(0);
            this.closed = true;
            try {
                this.join();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.throwExceptionIfExists();
        }

        private void throwExceptionIfExists() throws IOException {
            if (this.exception != null) {
                throw new IOException(this.exception);
            }
        }

        public FastqWriterThread(Writer writer, String threadName) {
            super(threadName);
            this.writer = writer;
            this.start();
        }

        public FastqWriterThread(File namedPipeFile, String threadName) throws IOException {
            this(MapperProcess.createPipeWriter(namedPipeFile), threadName);
        }
    }

    static class FastqWriterNoThread
    implements FastqWriter {
        final Writer writer;

        @Override
        public void write(String s) throws IOException {
            this.writer.write(s);
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }

        public FastqWriterNoThread(Writer writer) {
            this.writer = writer;
        }

        public FastqWriterNoThread(File namedPipeFile) throws IOException {
            this(MapperProcess.createPipeWriter(namedPipeFile));
        }
    }

    private static interface FastqWriter
    extends AutoCloseable {
        public void write(String var1) throws IOException;

        @Override
        public void close() throws IOException;
    }

    private final class InputStreamWrapper
    extends InputStream {
        private final InputStream is;

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            this.is.close();
            int exitValue = MapperProcess.this.getStdoutProcessResult().waitFor();
            MapperProcess.this.executor.getLogger().debug("End of process with " + exitValue + " exit value");
            if (exitValue != 0) {
                throw new IOException("Bad error result for " + MapperProcess.this.mapperName + " execution: " + exitValue);
            }
        }

        @Override
        public synchronized void mark(int readLimit) {
            this.is.mark(readLimit);
        }

        @Override
        public boolean markSupported() {
            return this.is.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] arg0, int arg1, int arg2) throws IOException {
            return this.is.read(arg0, arg1, arg2);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.is.read(b);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public long skip(long arg0) throws IOException {
            return this.is.skip(arg0);
        }

        private InputStreamWrapper(InputStream is) {
            this.is = is;
        }
    }

    public static final class ProcessThreadStdOut
    extends Thread {
        final OutputStream os;
        final InputStream is;
        private Exception exception;

        @Override
        public void run() {
            try {
                FileUtils.copy((InputStream)this.is, (OutputStream)this.os);
            }
            catch (IOException e) {
                this.catchException(e);
            }
        }

        private void catchException(Exception e) {
            this.exception = e;
        }

        public boolean isException() {
            return this.exception != null;
        }

        public Exception getException() {
            return this.exception;
        }

        public ProcessThreadStdOut(MapperExecutor.Result process, OutputStream os) throws IOException {
            if (process == null) {
                throw new NullPointerException("The Process parameter is null");
            }
            if (os == null) {
                throw new NullPointerException("The OutputStream parameter is null");
            }
            this.is = process.getInputStream();
            this.os = os;
        }
    }
}

