/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.AbstractMapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.EntryMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProcess;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Minimap2MapperProvider
extends AbstractMapperProvider {
    public static final String MAPPER_NAME = "minimap2";
    private static final String DEFAULT_PACKAGE_VERSION = "2.17";
    private static final String MAPPER_STANDARD_EXECUTABLE = "minimap2";
    private static final String DEFAULT_FLAVOR = "standard";
    private static final String DEFAULT_ARGUMENTS = "";
    private static final String SYNC = Minimap2MapperProvider.class.getName();
    private static final String INDEX_FILENAME = "genome.idx";

    @Override
    public String getName() {
        return "minimap2";
    }

    @Override
    public String getDefaultVersion() {
        return DEFAULT_PACKAGE_VERSION;
    }

    @Override
    public String getDefaultFlavor() {
        return DEFAULT_FLAVOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readBinaryVersion(MapperInstance mapperInstance) {
        try {
            String execPath;
            String string = SYNC;
            synchronized (string) {
                execPath = mapperInstance.getExecutor().install("minimap2");
            }
            ArrayList cmd = Lists.newArrayList((Object[])new String[]{execPath, "--version"});
            String s = MapperUtils.executeToString(mapperInstance.getExecutor(), cmd);
            String[] lines = s.split("\n");
            if (lines.length == 0) {
                return null;
            }
            String[] tokens = lines[0].split("-");
            if (tokens.length > 1) {
                return tokens[1].trim();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public String getDefaultMapperArguments() {
        return DEFAULT_ARGUMENTS;
    }

    @Override
    public List<String> getIndexerExecutables(MapperInstance mapperInstance) {
        return Collections.singletonList("minimap2");
    }

    @Override
    public String getMapperExecutableName(MapperInstance mapperInstance) {
        return "minimap2";
    }

    @Override
    public List<String> getIndexerCommand(File indexerFile, File genomeFile, List<String> indexerArguments, int threads) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(indexerFile.getAbsolutePath());
        cmd.addAll(indexerArguments);
        cmd.add(genomeFile.getAbsolutePath());
        cmd.add("-d");
        cmd.add(INDEX_FILENAME);
        return cmd;
    }

    @Override
    public boolean checkIfFlavorExists(MapperInstance mapperInstance) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperProcess mapSE(final EntryMapping mapping, File inputFile, File errorFile, File logFile) throws IOException {
        String minimap2Path;
        String string = SYNC;
        synchronized (string) {
            minimap2Path = mapping.getExecutor().install("minimap2");
        }
        return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, false, inputFile){

            @Override
            protected List<List<String>> createCommandLines() {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(minimap2Path);
                cmd.add("-a");
                cmd.add("-t");
                cmd.add(Minimap2MapperProvider.DEFAULT_ARGUMENTS + mapping.getThreadNumber());
                cmd.addAll(mapping.getMapperArguments());
                cmd.add(mapping.getIndexDirectory().getAbsolutePath() + "/" + Minimap2MapperProvider.INDEX_FILENAME);
                cmd.add(this.getNamedPipeFile1().getAbsolutePath());
                return Collections.singletonList(cmd);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperProcess mapPE(final EntryMapping mapping, File inputFile1, File inputFile2, File errorFile, File logFile) throws IOException {
        String minimap2Path;
        String string = SYNC;
        synchronized (string) {
            minimap2Path = mapping.getExecutor().install("minimap2");
        }
        return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, false, inputFile1, inputFile2){

            @Override
            protected List<List<String>> createCommandLines() {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(minimap2Path);
                cmd.add("-a");
                cmd.add("-t");
                cmd.add(Minimap2MapperProvider.DEFAULT_ARGUMENTS + mapping.getThreadNumber());
                cmd.addAll(mapping.getMapperArguments());
                cmd.add(mapping.getIndexDirectory().getAbsolutePath() + "/" + Minimap2MapperProvider.INDEX_FILENAME);
                cmd.add(this.getNamedPipeFile1().getAbsolutePath());
                cmd.add(this.getNamedPipeFile2().getAbsolutePath());
                return Collections.singletonList(cmd);
            }
        };
    }
}

