/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.BundledMapperExecutor;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperExecutor;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class PathMapperExecutor
implements MapperExecutor {
    private GenericLogger logger;

    @Override
    public GenericLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isExecutable(String executable) {
        Objects.requireNonNull(executable, "executable argument cannot be null");
        return FileUtils.checkIfExecutableIsInPATH((String)executable);
    }

    @Override
    public String install(String executable) throws IOException {
        Objects.requireNonNull(executable, "executable argument cannot be null");
        return executable;
    }

    @Override
    public MapperExecutor.Result execute(List<String> command, File executionDirectory, boolean stdout, File stdErrFile, boolean redirectStderr, File ... fileUsed) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(redirectStderr);
        if (stdErrFile != null) {
            builder.redirectError(stdErrFile);
        } else if (!redirectStderr) {
            builder.redirectError(new File("/dev/null"));
        }
        if (executionDirectory != null) {
            builder.directory(executionDirectory);
        }
        this.logger.info("Process command: " + Joiner.on((char)' ').join(builder.command()));
        this.logger.info("Process directory: " + builder.directory());
        return new BundledMapperExecutor.ProcessResult(builder.start());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    PathMapperExecutor(GenericLogger logger) {
        Objects.requireNonNull(logger, "logger argument cannot be null");
        this.logger = logger;
    }
}

