/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readmapper;

import com.google.common.collect.Lists;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.AbstractMapperProvider;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.EntryMapping;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperInstance;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperProcess;
import fr.ens.biologie.genomique.kenetre.bio.readmapper.MapperUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class STARMapperProvider
extends AbstractMapperProvider {
    public static final String MAPPER_NAME = "STAR";
    private static final String DEFAULT_VERSION = "2.7.2d";
    private static final String MAPPER_STANDARD_EXECUTABLE = "STAR";
    private static final String MAPPER_LARGE_INDEX_EXECUTABLE = "STARlong";
    private static final String SHORT_INDEX_FLAVOR = "standard";
    private static final String LARGE_INDEX_FLAVOR = "large-index";
    public static final String DEFAULT_ARGUMENTS = "--outSAMunmapped Within";
    private static final String SYNC = STARMapperProvider.class.getName();

    @Override
    public String getName() {
        return "STAR";
    }

    @Override
    public String getDefaultVersion() {
        return DEFAULT_VERSION;
    }

    @Override
    public String getDefaultFlavor() {
        return SHORT_INDEX_FLAVOR;
    }

    @Override
    public String getDefaultMapperArguments() {
        return DEFAULT_ARGUMENTS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readBinaryVersion(MapperInstance mapperInstance) {
        try {
            String execPath;
            String string = SYNC;
            synchronized (string) {
                execPath = mapperInstance.getExecutor().install(this.flavoredBinary(mapperInstance.getFlavor()));
            }
            ArrayList cmd = Lists.newArrayList((Object[])new String[]{execPath, "--version"});
            String s = MapperUtils.executeToString(mapperInstance.getExecutor(), cmd);
            String[] lines = s.split("\n");
            if (lines.length == 0) {
                return null;
            }
            String[] tokens = lines[0].split("_");
            if (tokens.length > 1) {
                return tokens[1].trim();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public List<String> getIndexerExecutables(MapperInstance mapperInstance) {
        return Collections.singletonList(this.flavoredBinary(mapperInstance.getFlavor()));
    }

    @Override
    public String getMapperExecutableName(MapperInstance mapperInstance) {
        return this.flavoredBinary(mapperInstance.getFlavor());
    }

    @Override
    public boolean checkIfFlavorExists(MapperInstance mapperInstance) {
        switch (mapperInstance.getFlavor().trim().toLowerCase()) {
            case "standard": 
            case "large-index": {
                return true;
            }
        }
        return false;
    }

    private String flavoredBinary(String flavor) {
        if (flavor != null && LARGE_INDEX_FLAVOR.equals(flavor.trim().toLowerCase())) {
            return MAPPER_LARGE_INDEX_EXECUTABLE;
        }
        return "STAR";
    }

    @Override
    public List<String> getIndexerCommand(File indexerFile, File genomeFile, List<String> indexerArguments, int threads) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(indexerFile.getAbsolutePath());
        cmd.add("--runThreadN");
        cmd.add("" + threads);
        cmd.add("--runMode");
        cmd.add("genomeGenerate");
        cmd.add("--genomeDir");
        cmd.add(genomeFile.getParentFile().getAbsolutePath());
        cmd.add("--genomeFastaFiles");
        cmd.add(genomeFile.getAbsolutePath());
        cmd.addAll(indexerArguments);
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperProcess mapSE(EntryMapping mapping, File inputFile, File errorFile, File logFile) throws IOException {
        String starPath;
        String string = SYNC;
        synchronized (string) {
            starPath = mapping.getExecutor().install(this.flavoredBinary(mapping.getFlavor()));
        }
        return this.createMapperProcessSE(mapping, starPath, inputFile, errorFile, logFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperProcess mapPE(EntryMapping mapping, File inputFile1, File inputFile2, File errorFile, File logFile) throws IOException {
        String starPath;
        String string = SYNC;
        synchronized (string) {
            starPath = mapping.getExecutor().install(this.flavoredBinary(mapping.getFlavor()));
        }
        return this.createMapperProcessPE(mapping, starPath, inputFile1, inputFile2, errorFile, logFile);
    }

    private MapperProcess createMapperProcessSE(final EntryMapping mapping, final String starPath, File inputFile, File errorFile, final File logFile) throws IOException {
        return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, false, inputFile){

            @Override
            protected List<List<String>> createCommandLines() {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(starPath);
                cmd.add("--runThreadN");
                cmd.add("" + mapping.getThreadNumber());
                cmd.add("--genomeDir");
                cmd.add(mapping.getIndexDirectory().getAbsolutePath());
                if (logFile != null) {
                    cmd.add("--outFileNamePrefix");
                    cmd.add(logFile.getAbsolutePath());
                }
                cmd.add("--outStd");
                cmd.add("SAM");
                cmd.addAll(mapping.getMapperArguments());
                cmd.add("--readFilesIn");
                cmd.add(this.getNamedPipeFile1().getAbsolutePath());
                return Collections.singletonList(cmd);
            }
        };
    }

    private MapperProcess createMapperProcessPE(final EntryMapping mapping, final String starPath, File inputFile1, File inputFile2, File errorFile, final File logFile) throws IOException {
        return new MapperProcess(mapping.getName(), mapping.getExecutor(), mapping.getTemporaryDirectory(), errorFile, true, true, inputFile1, inputFile2){

            @Override
            protected List<List<String>> createCommandLines() {
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(starPath);
                cmd.add("--runThreadN");
                cmd.add("" + mapping.getThreadNumber());
                cmd.add("--genomeDir");
                cmd.add(mapping.getIndexDirectory().getAbsolutePath());
                if (logFile != null) {
                    cmd.add("--outFileNamePrefix");
                    cmd.add(logFile.getAbsolutePath());
                }
                cmd.add("--outStd");
                cmd.add("SAM");
                cmd.addAll(mapping.getMapperArguments());
                cmd.add("--readFilesIn");
                cmd.add(this.getNamedPipeFile1().getAbsolutePath());
                cmd.add(this.getNamedPipeFile2().getAbsolutePath());
                return Collections.singletonList(cmd);
            }
        };
    }
}

