/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.eoulsan.EoulsanError;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractEoulsanRuntime {
    private final Settings settings;

    public Settings getSettings() {
        return this.settings;
    }

    public abstract File getTempDirectory();

    public abstract EoulsanExecMode getMode();

    public abstract InputStream getInputStream(String var1) throws IOException;

    public abstract InputStream getRawInputStream(String var1) throws IOException;

    public abstract OutputStream getOutputStream(String var1) throws IOException;

    protected InputStream decompressInputStreamIsNeeded(InputStream is, String source) throws IOException {
        String extension = StringUtils.compressionExtension((String)source);
        return CompressionType.getCompressionTypeByExtension((String)extension).createInputStream(is);
    }

    public File createTempDir() throws IOException {
        return FileUtils.createTempDir((File)this.getTempDirectory(), null);
    }

    public File createTempDir(String prefix) throws IOException {
        return FileUtils.createTempDir((File)this.getTempDirectory(), (String)prefix);
    }

    public File createTempFile(String prefix, String suffix) throws IOException {
        return FileUtils.createTempFile((File)this.getTempDirectory(), (String)prefix, (String)suffix);
    }

    public File createFileInTempDir(String filename) {
        return new File(this.getTempDirectory(), filename);
    }

    protected AbstractEoulsanRuntime(Settings settings) {
        if (settings == null) {
            throw new EoulsanError("The settings are null");
        }
        this.settings = settings;
    }

    public static enum EoulsanExecMode {
        LOCAL,
        HADOOP,
        HADOOP_TASK,
        AMAZON,
        CLUSTER,
        CLUSTER_TASK,
        EXTERNAL_APP;


        public boolean isHadoopMode() {
            switch (this) {
                case HADOOP: 
                case AMAZON: {
                    return true;
                }
            }
            return false;
        }

        public boolean isHadoopProtocolMode() {
            return this.isHadoopMode() || this == HADOOP_TASK;
        }
    }
}

