/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class BufferedHandler
extends Handler {
    private final List<Handler> handlers = new ArrayList<Handler>();
    private final Queue<LogRecord> records = new LinkedList<LogRecord>();
    private boolean flushed = false;

    public void addHandler(Handler handler) {
        if (handler != null) {
            if (this.getLevel() != null) {
                handler.setLevel(this.getLevel());
            }
            if (this.getFormatter() != null) {
                handler.setFormatter(this.getFormatter());
            }
            this.handlers.add(handler);
        }
    }

    @Override
    public void close() throws SecurityException {
        for (Handler h : this.handlers) {
            h.close();
        }
    }

    @Override
    public void flush() {
        if (!this.flushed) {
            LogRecord record = null;
            while ((record = this.records.poll()) != null) {
                for (Handler h : this.handlers) {
                    h.publish(record);
                }
            }
            this.flushed = true;
        }
        for (Handler h : this.handlers) {
            h.flush();
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (!this.flushed) {
            this.records.add(record);
        } else {
            for (Handler h : this.handlers) {
                h.publish(record);
            }
        }
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        super.setLevel(newLevel);
        for (Handler h : this.handlers) {
            h.setLevel(newLevel);
        }
    }

    @Override
    public synchronized void setFormatter(Formatter newFormatter) throws SecurityException {
        super.setFormatter(newFormatter);
        for (Handler h : this.handlers) {
            h.setFormatter(newFormatter);
        }
    }
}

