/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EoulsanLogger {
    private static String loggerName = "Eoulsan";
    private static final Map<String, Logger> threadGroupLoggers = new HashMap<String, Logger>();
    private static Logger logger;

    public static Logger getLogger() {
        if (!threadGroupLoggers.isEmpty()) {
            ThreadGroup tg = Thread.currentThread().getThreadGroup();
            do {
                if (!threadGroupLoggers.containsKey(tg.getName())) continue;
                return threadGroupLoggers.get(tg.getName());
            } while ((tg = tg.getParent()) != null);
        }
        if (logger == null) {
            logger = Logger.getLogger(loggerName);
        }
        return logger;
    }

    public static void setLoggerName(String newLoggerName) {
        if (newLoggerName == null) {
            throw new NullPointerException("New logger name is null");
        }
        loggerName = newLoggerName;
        logger = null;
    }

    public static String getLoggerName() {
        return loggerName;
    }

    public static void registerThreadGroupLogger(ThreadGroup threadGroup, Logger logger) {
        if (threadGroup == null || logger == null) {
            return;
        }
        threadGroupLoggers.put(threadGroup.getName(), logger);
    }

    public static void removeThreadGroupLogger(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            return;
        }
        threadGroupLoggers.remove(threadGroup.getName());
    }

    public static void initConsoleHandler() {
        EoulsanLogger.initConsoleHandler(null);
    }

    public static void initConsoleHandler(Level level) {
        EoulsanLogger.getLogger().setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(level != null ? level : Globals.LOG_LEVEL);
        handler.setFormatter(Globals.LOG_FORMATTER);
        EoulsanLogger.getLogger().addHandler(handler);
        EoulsanLogger.getLogger().setLevel(handler.getLevel());
    }

    public static void logSevere(String msg) {
        EoulsanLogger.getLogger().severe(msg);
    }

    public static void logWarning(String msg) {
        EoulsanLogger.getLogger().warning(msg);
    }

    public static void logInfo(String msg) {
        EoulsanLogger.getLogger().info(msg);
    }

    public static void logConfig(String msg) {
        EoulsanLogger.getLogger().config(msg);
    }

    public static void logFiner(String msg) {
        EoulsanLogger.getLogger().finer(msg);
    }

    public static void logFinest(String message) {
        EoulsanLogger.getLogger().finest(message);
    }

    public static GenericLogger getGenericLogger() {
        return new EoulsanRuntimeLogger();
    }

    private static class EoulsanRuntimeLogger
    implements GenericLogger,
    Serializable {
        private static final long serialVersionUID = 7316420644292128626L;

        private EoulsanRuntimeLogger() {
        }

        public void debug(String message) {
            EoulsanLogger.getLogger().fine(message);
        }

        public void info(String message) {
            EoulsanLogger.getLogger().info(message);
        }

        public void warn(String message) {
            EoulsanLogger.getLogger().warning(message);
        }

        public void error(String message) {
            EoulsanLogger.getLogger().severe(message);
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

