/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.util.Version;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public final class Globals {
    private static Attributes manifestAttributes;
    private static final String MANIFEST_FILE = "/META-INF/MANIFEST.MF";
    public static final String APP_NAME = "Eoulsan";
    public static final String APP_NAME_LOWER_CASE;
    public static final String PARAMETER_PREFIX;
    public static final String APP_VERSION_STRING;
    public static final Version APP_VERSION;
    public static final String APP_BUILD_NUMBER;
    public static final String APP_BUILD_COMMIT;
    public static final String APP_BUILD_HOST;
    public static final String APP_BUILD_DATE;
    public static final String APP_BUILD_YEAR;
    public static final String WELCOME_MSG;
    public static final String TEMP_PREFIX;
    public static final Level LOG_LEVEL;
    public static final boolean DEBUG;
    public static final boolean BYPASS_PLATFORM_CHECKING = false;
    public static final int MINIMAL_JAVA_VERSION_REQUIRED = 8;
    public static final Set<String> AVAILABLE_BINARY_ARCH;
    public static final Map<String, String> AVAILABLE_BINARY_ARCH_ALIAS;
    public static final Locale DEFAULT_LOCALE;
    public static final Formatter LOG_FORMATTER;
    private static final String WEBSITE_URL_DEFAULT;
    public static final String WEBSITE_URL;
    public static final String CONTACT_EMAIL;
    public static final String DISCUSSION_GROUP;
    private static final String COPYRIGHT_DATE;
    public static final String LICENSE_TXT = "This program is developed under the GNU Lesser General Public License version 2.1 or later and CeCILL-C.";
    public static final String ABOUT_TXT;
    public static final boolean STD_OUTPUT_DEFAULT = false;
    public static final double DESIGN_FILE_VERSION = 1.1;
    public static final String LIBS_TO_HADOOP_REPACK_PROPERTY;
    public static final String LAUNCH_MODE_PROPERTY;
    public static final String LAUNCH_SCRIPT_PATH;
    public static final boolean PRINT_STACK_TRACE_DEFAULT;
    public static final String UI_NAME_DEFAULT = "lanterna";
    public static final int FASTA_FILE_WIDTH = 60;
    static final FastqFormat FASTQ_FORMAT_DEFAULT;
    public static final boolean OBFUSCATE_DESIGN_DEFAULT = true;
    public static final boolean OBFUSCATE_DESIGN_REMOVE_REPLICATE_INFO_DEFAULT = true;
    public static final int ZOOKEEPER_DEFAULT_PORT_DEFAULT = 2181;
    public static final int ZOOKEEPER_SESSION_TIMEOUT_DEFAULT = 10000;
    public static final boolean USE_OLD_EOULSAN_RESULT_FORMAT_DEFAULT = false;
    public static final String LOG_FILENAME;
    public static final String OTHER_LOG_FILENAME = "additional.log";
    public static final String OUTPUT_TREE_TYPE_DEFAULT = "step";
    public static final boolean SAVE_WORKFLOW_IMAGE_DEFAULT = true;
    public static final boolean STANDARD_EXTERNAL_MODULES_ENABLED_DEFAULT = true;
    public static final String INTERNET_CHECK_SERVER = "raw.githubusercontent.com";
    public static final int INTERNET_CHECK_PORT = 443;
    public static final String EOULSAN_TOOLS_WEBSITE_URL = "https://raw.githubusercontent.com/GenomicParisCentre/eoulsan-tools";
    public static final String DEFAULT_FILE_ENCODING = "UTF-8";
    public static final Charset DEFAULT_CHARSET;
    public static final String LOG_EXTENSION = ".log";
    public static final String STEP_LOG_EXTENSION = ".step.log";
    public static final String STEP_RESULT_EXTENSION = ".step.result";
    public static final String STEP_RESULT_OLD_FORMAT_EXTENSION = ".log";
    public static final String TASK_CONTEXT_EXTENSION = ".task.context";
    public static final String TASK_RESULT_EXTENSION = ".task.result";
    public static final String TASK_LOG_EXTENSION = ".task.log";
    public static final String TASK_DATA_EXTENSION = ".task.data";
    public static final String TASK_DONE_EXTENSION = ".task.done";
    public static final String TASK_STDOUT_EXTENSION = ".task.out";
    public static final String TASK_STDERR_EXTENSION = ".task.err";
    public static final String TASK_JOB_ID = ".task.job.id";
    public static final String STEP_OUTPUT_DIRECTORY_SUFFIX = "_output";
    private static final String UNKNOWN_VERSION = "UNKNOWN_VERSION";
    private static final String UNKNOWN_BUILD = "UNKNOWN_BUILD";
    private static final String UNKNOWN_DATE = "UNKNOWN_DATE";
    private static final String UNKNOWN_YEAR = "UNKNOWN_YEAR";
    private static final String UNKNOWN_BUILD_COMMIT = "UNKNOWN_COMMIT";
    private static final String UNKNOWN_BUILD_HOST = "UNKNOWN_HOST";

    private static String getVersion() {
        String version = Globals.getManifestProperty("Specification-Version");
        return version != null ? version : UNKNOWN_VERSION;
    }

    private static String getBuiltNumber() {
        String builtNumber = Globals.getManifestProperty("Implementation-Version");
        return builtNumber != null ? builtNumber : UNKNOWN_BUILD;
    }

    private static String getBuiltDate() {
        String builtDate = Globals.getManifestProperty("Built-Date");
        return builtDate != null ? builtDate : UNKNOWN_DATE;
    }

    private static String getBuiltYear() {
        String builtYear = Globals.getManifestProperty("Built-Year");
        return builtYear != null ? builtYear : UNKNOWN_YEAR;
    }

    private static String getWebSiteURL() {
        String url = Globals.getManifestProperty("url");
        return url != null ? url : WEBSITE_URL_DEFAULT;
    }

    private static String getBuiltCommit() {
        String buildCommit = Globals.getManifestProperty("Built-Commit");
        return buildCommit != null ? buildCommit : UNKNOWN_BUILD_COMMIT;
    }

    private static String getBuiltHost() {
        String buildHost = Globals.getManifestProperty("Built-Host");
        return buildHost != null ? buildHost : UNKNOWN_BUILD_HOST;
    }

    private static String getManifestProperty(String propertyKey) {
        if (propertyKey == null) {
            return null;
        }
        Globals.readManifest();
        if (manifestAttributes == null) {
            return null;
        }
        return manifestAttributes.getValue(propertyKey);
    }

    private static synchronized void readManifest() {
        if (manifestAttributes != null) {
            return;
        }
        try {
            String manifestPath;
            Class<Globals> clazz = Globals.class;
            String className = clazz.getSimpleName() + ".class";
            String classPath = clazz.getResource(className).toString();
            if (!classPath.startsWith("jar")) {
                String basePath = classPath.substring(0, classPath.length() - clazz.getName().length() - ".class".length());
                manifestPath = basePath + MANIFEST_FILE;
            } else {
                manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + MANIFEST_FILE;
            }
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            manifestAttributes = manifest.getMainAttributes();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setDefaultLocale() {
        Locale.setDefault(DEFAULT_LOCALE);
    }

    private Globals() {
        throw new IllegalStateException();
    }

    static {
        APP_NAME_LOWER_CASE = APP_NAME.toLowerCase();
        PARAMETER_PREFIX = "fr.ens.biologie.genomique." + APP_NAME_LOWER_CASE;
        APP_VERSION_STRING = Globals.getVersion();
        APP_VERSION = new Version(APP_VERSION_STRING);
        APP_BUILD_NUMBER = Globals.getBuiltNumber();
        APP_BUILD_COMMIT = Globals.getBuiltCommit();
        APP_BUILD_HOST = Globals.getBuiltHost();
        APP_BUILD_DATE = Globals.getBuiltDate();
        APP_BUILD_YEAR = Globals.getBuiltYear();
        WELCOME_MSG = "Eoulsan version " + APP_VERSION_STRING + " (" + APP_BUILD_COMMIT + ", " + APP_BUILD_NUMBER + " build on " + APP_BUILD_HOST + ", " + APP_BUILD_DATE + ")";
        TEMP_PREFIX = APP_NAME_LOWER_CASE + "-" + APP_VERSION_STRING + "-" + APP_BUILD_NUMBER + "-";
        LOG_LEVEL = Level.INFO;
        DEBUG = APP_VERSION_STRING.endsWith("-SNAPSHOT") || UNKNOWN_VERSION.equals(APP_VERSION_STRING);
        AVAILABLE_BINARY_ARCH = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("linux\tamd64", "linux\tx86_64")));
        AVAILABLE_BINARY_ARCH_ALIAS = Collections.unmodifiableMap(Collections.singletonMap("linux\tx86_64", "linux\tamd64"));
        DEFAULT_LOCALE = Locale.US;
        LOG_FORMATTER = new Formatter(){
            private final DateFormat df = new SimpleDateFormat("yyyy.MM.dd kk:mm:ss", DEFAULT_LOCALE);

            @Override
            public String format(LogRecord record) {
                return record.getLevel() + "\t" + this.df.format(new Date(record.getMillis())) + "\t" + record.getMessage() + "\n";
            }
        };
        WEBSITE_URL_DEFAULT = "http://outils.genomique.biologie.ens.fr/" + APP_NAME_LOWER_CASE;
        WEBSITE_URL = Globals.getWebSiteURL();
        CONTACT_EMAIL = APP_NAME_LOWER_CASE + "@biologie.ens.fr";
        DISCUSSION_GROUP = "http://groups.google.com/group/" + APP_NAME_LOWER_CASE;
        COPYRIGHT_DATE = "2010-" + APP_BUILD_YEAR;
        ABOUT_TXT = "Eoulsan version " + APP_VERSION_STRING + " (" + APP_BUILD_COMMIT + ", " + APP_BUILD_NUMBER + ") is a pipeline for NGS analysis.\nThis version has been built on " + APP_BUILD_DATE + ".\n\nAuthors:\n  Laurent Jourdren (Project leader and maintainer)\n  Maria Bernard\n  St\u00e9phane Le Crom\n  Claire Wallon\n  Vivien Deshaies\n  Sandrine Perrin\n  Xavier Bauquet\n  Cyril Firmo\n  Runxin Du\n  Aur\u00e9lien Birer\nContacts:\n  Email: " + CONTACT_EMAIL + "\n  Discussion group: " + DISCUSSION_GROUP + "\n  Website: " + WEBSITE_URL + "\nCopyright " + COPYRIGHT_DATE + " IBENS genomics core facility\nThis program is developed under the GNU Lesser General Public License version 2.1 or later and CeCILL-C.\n";
        LIBS_TO_HADOOP_REPACK_PROPERTY = APP_NAME_LOWER_CASE + ".hadoop.libs";
        LAUNCH_MODE_PROPERTY = APP_NAME_LOWER_CASE + ".launch.mode";
        LAUNCH_SCRIPT_PATH = APP_NAME_LOWER_CASE + ".launch.script.path";
        PRINT_STACK_TRACE_DEFAULT = DEBUG;
        FASTQ_FORMAT_DEFAULT = FastqFormat.FASTQ_SANGER;
        LOG_FILENAME = APP_NAME_LOWER_CASE + ".log";
        DEFAULT_CHARSET = Charset.forName(DEFAULT_FILE_ENCODING);
    }
}

