/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.CommonHadoop;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Settings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class HadoopEoulsanRuntime
extends AbstractEoulsanRuntime {
    private static final String HADOOP_TEMP_DIR = "mapreduce.cluster.temp.dir";
    private final Configuration conf;
    private final AbstractEoulsanRuntime.EoulsanExecMode mode;

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public AbstractEoulsanRuntime.EoulsanExecMode getMode() {
        return this.mode;
    }

    @Override
    public File getTempDirectory() {
        if (this.mode == AbstractEoulsanRuntime.EoulsanExecMode.HADOOP_TASK) {
            return new File(this.conf.get(HADOOP_TEMP_DIR, System.getProperty("java.io.tmpdir")));
        }
        return this.getSettings().getTempDirectoryFile();
    }

    @Override
    public InputStream getInputStream(String dataSource) throws IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException("The datasource is null.");
        }
        Path p = new Path(dataSource);
        FileSystem fs = p.getFileSystem(this.conf);
        return this.decompressInputStreamIsNeeded((InputStream)fs.open(p), dataSource);
    }

    @Override
    public InputStream getRawInputStream(String dataSource) throws IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException("The datasource is null.");
        }
        Path p = new Path(dataSource);
        FileSystem fs = p.getFileSystem(this.conf);
        return fs.open(p);
    }

    @Override
    public OutputStream getOutputStream(String dataSource) throws IOException {
        if (dataSource == null) {
            throw new IllegalArgumentException("The datasource is null.");
        }
        Path p = new Path(dataSource);
        FileSystem fs = p.getFileSystem(this.conf);
        return fs.create(p);
    }

    public static HadoopEoulsanRuntime newEoulsanRuntime(Configuration conf) throws IOException {
        try {
            return HadoopEoulsanRuntime.newEoulsanRuntime(new Settings(false), conf, AbstractEoulsanRuntime.EoulsanExecMode.HADOOP_TASK);
        }
        catch (EoulsanException e) {
            throw new IOException(e);
        }
    }

    static HadoopEoulsanRuntime newEoulsanRuntime(Settings settings) {
        Configuration conf = CommonHadoop.createConfiguration(settings);
        return HadoopEoulsanRuntime.newEoulsanRuntime(settings, conf, AbstractEoulsanRuntime.EoulsanExecMode.HADOOP);
    }

    private static synchronized HadoopEoulsanRuntime newEoulsanRuntime(Settings settings, Configuration conf, AbstractEoulsanRuntime.EoulsanExecMode mode) {
        HadoopEoulsanRuntime instance = new HadoopEoulsanRuntime(settings, conf, mode);
        EoulsanRuntime.setInstance(instance, true);
        return (HadoopEoulsanRuntime)EoulsanRuntime.getRuntime();
    }

    private HadoopEoulsanRuntime(Settings settings, Configuration conf, AbstractEoulsanRuntime.EoulsanExecMode mode) {
        super(settings);
        if (conf == null) {
            throw new IllegalArgumentException("The configuration is null");
        }
        this.conf = conf;
        this.mode = mode;
    }
}

