/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.eoulsan.util.LinuxCpuInfo;
import fr.ens.biologie.genomique.eoulsan.util.LinuxMemInfo;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import fr.ens.biologie.genomique.kenetre.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Infos {
    private static final String NOT_SET = "(Not set)";

    public static void log(Level level, List<Info> listInfos) {
        Objects.requireNonNull(level, "level argument cannot be null");
        Objects.requireNonNull(listInfos, "listInfos argument cannot be null");
        for (Info i : listInfos) {
            Infos.log(level, i);
        }
    }

    public static void log(Level level, Info info) {
        Objects.requireNonNull(level, "level argument cannot be null");
        Objects.requireNonNull(info, "info argument cannot be null");
        Logger logger = EoulsanLogger.getLogger();
        logger.log(level, info.getName() + ": " + StringUtils.join(info.getValues(), (String)" "));
    }

    public static Info diskFreeInfo(File partition) throws IOException {
        DiskFree df = new DiskFree(partition);
        return new Info(df.getDescription(), StringUtils.sizeToHumanReadable((long)df.getCapacity()) + " capacity, " + StringUtils.sizeToHumanReadable((long)df.getUsed()) + " used, " + StringUtils.sizeToHumanReadable((long)df.getAvailable()) + " available, " + df.getIntPercentUsed() + "% used");
    }

    public static List<Info> softwareInfos(Main main) {
        Objects.requireNonNull(main, "main argument cannot be null");
        ListInfo li = new ListInfo();
        li.add("Eoulsan version", Globals.APP_VERSION_STRING);
        li.add("Eoulsan revision", Globals.APP_BUILD_COMMIT);
        li.add("Eoulsan build date", Globals.APP_BUILD_DATE);
        li.add("Eoulsan website", Globals.WEBSITE_URL);
        li.add("Eoulsan contact", Globals.CONTACT_EMAIL);
        li.add("Eoulsan disscusion group", Globals.DISCUSSION_GROUP);
        li.add("Eoulsan Startup script", main.getLaunchScriptPath() == null ? "(no startup script)" : main.getLaunchScriptPath());
        li.add("Eoulsan installation directory", main.getEoulsanDirectory() == null ? "(installation directory not found)" : main.getEoulsanDirectory().toString());
        return li.getList();
    }

    public static List<Info> commandLineInfo(Main main) {
        Objects.requireNonNull(main, "main argument cannot be null");
        ListInfo li = new ListInfo();
        ArrayList<Object> args = new ArrayList<Object>();
        for (String a : main.getArgs()) {
            if (a.indexOf(32) != -1) {
                args.add("\"" + a + "\"");
                continue;
            }
            args.add(a);
        }
        li.add("Command line", Joiner.on((char)' ').join(args));
        li.add("Configuration file", main.getConfigurationFileArgument());
        li.add("Log file", main.getLogFileArgument() == null ? NOT_SET : main.getLogFileArgument());
        li.add("Log level", EoulsanLogger.getLogger().getLevel().getName());
        return li.getList();
    }

    public static List<Info> systemInfos() {
        ListInfo li = new ListInfo();
        li.add("Host", SystemUtils.getHostName());
        li.add("Operating system name", System.getProperty("os.name"));
        li.add("Operating system version", System.getProperty("os.version"));
        li.add("Operating system arch", System.getProperty("os.arch"));
        li.add("User name", System.getProperty("user.name"));
        li.add("User home", System.getProperty("user.home"));
        li.add("User current directory", System.getProperty("user.dir"));
        li.add("Java vendor", System.getProperty("java.vendor"));
        li.add("Java vm name", System.getProperty("java.vm.name"));
        li.add("Java version", System.getProperty("java.version"));
        li.add("Java max memory", "" + Runtime.getRuntime().maxMemory());
        return li.getList();
    }

    public static List<Info> generalConf(Settings settings) {
        Objects.requireNonNull(settings, "settings argument cannot be null");
        ListInfo li = new ListInfo();
        li.add("Debug mode", settings.isDebug());
        li.add("User interface", settings.getUIName());
        li.add("Maximum local thread count", settings.getLocalThreadsNumber());
        li.add("Print stack trace", settings.isPrintStackTrace());
        li.add("User defined temporary directory", settings.isUserDefinedTempDirectory());
        li.add("Temporary directory", settings.getTempDirectory());
        li.add("Executable temporary directory", settings.getExecutablesTempDirectory());
        li.add("Output type", settings.getOutputTreeType());
        li.add("Generate workflow image", settings.isSaveWorkflowImage());
        return li.getList();
    }

    public static List<Info> modulesAndFormatsInfo(Settings settings) {
        Objects.requireNonNull(settings, "settings argument cannot be null");
        ListInfo li = new ListInfo();
        li.add("Data format path", settings.getDataFormatPaths(), NOT_SET);
        li.add("Galaxy tools path", settings.getGalaxyToolPaths(), NOT_SET);
        li.add("Data format count", DataFormatRegistry.getInstance().getAllFormats().size());
        return li.getList();
    }

    public static List<Info> storageInfo(Settings settings) {
        Objects.requireNonNull(settings, "settings argument cannot be null");
        ListInfo li = new ListInfo();
        li.add("Genome description path", settings.getGenomeDescStoragePath());
        li.add("Genome mapper index storage path", settings.getGenomeMapperIndexStoragePath());
        li.add("Genome storage path", settings.getGenomeStoragePath());
        li.add("GFF storage path", settings.getGFFStoragePath());
        li.add("GTF storage path", settings.getGTFStoragePath());
        li.add("Additional annotation path", settings.getAdditionalAnnotationStoragePath());
        li.add("Hyperlinks conf file for additional annotation", settings.getAdditionalAnnotationHypertextLinksPath());
        return li.getList();
    }

    public static List<Info> clusterInfo(Settings settings) {
        Objects.requireNonNull(settings, "settings argument cannot be null");
        ListInfo li = new ListInfo();
        li.add("Cluster scheduler", settings.getClusterSchedulerName());
        li.add("Default cluster memory required", (String)(settings.getDefaultClusterMemoryRequired() == -1 ? NOT_SET : "" + settings.getDefaultClusterMemoryRequired()));
        if (settings.getSetting("htcondor.concurrency.limits") != null) {
            li.add("HTCondor concurrency limits", settings.getSetting("htcondor.concurrency.limits"));
        }
        return li.getList();
    }

    public static List<Info> hadoopInfo(Settings settings) {
        Objects.requireNonNull(settings, "settings argument cannot be null");
        ListInfo li = new ListInfo();
        li.add("Hadoop log level", settings.getHadoopLogLevel());
        li.add("ZooKeeper connection string", settings.getZooKeeperConnectString());
        li.add("ZooKeeper port", settings.getZooKeeperDefaultPort());
        li.add("ZooKeeper session timeout", settings.getZooKeeperSessionTimeout());
        return li.getList();
    }

    public static List<Info> cloudInfo(Settings settings) {
        Objects.requireNonNull(settings, "settings argument cannot be null");
        ListInfo li = new ListInfo();
        li.add("Hadoop AWS access key", settings.getAWSAccessKey() != null ? Strings.repeat((String)"X", (int)settings.getAWSAccessKey().length()) : NOT_SET);
        li.add("Hadoop AWS secret key", settings.getAWSSecretKey() != null ? Strings.repeat((String)"X", (int)settings.getAWSSecretKey().length()) : NOT_SET);
        li.add("Obfuscate design", settings.isObfuscateDesign());
        li.add("Remove duplicate info when obfuscate design", settings.isObfuscateDesignRemoveReplicateInfo());
        return li.getList();
    }

    public static List<Info> mailInfo(Settings settings) {
        Objects.requireNonNull(settings, "settings argument cannot be null");
        ListInfo li = new ListInfo();
        li.add("Send result by email", settings.isSendResultMail());
        li.add("Send results to", settings.getResultMail());
        li.add("SMTP server", settings.getSMTPHost());
        Properties p = settings.getJavaMailSMTPProperties();
        li.add("JavaMail configuration", p == null || p.isEmpty() ? NOT_SET : p.toString());
        return li.infos;
    }

    public static List<Info> rAndRserveInfo(Settings settings) {
        Objects.requireNonNull(settings, "settings argument cannot be null");
        ListInfo li = new ListInfo();
        li.add("Do not remove R scripts", settings.isSaveRscripts());
        li.add("Use RServe", settings.isRServeServerEnabled());
        li.add("RServe server name", settings.getRServeServerName());
        li.add("Keep files on RServe server", settings.isKeepRServeFiles());
        return li.infos;
    }

    public static List<Info> dockerInfo(Settings settings) {
        Objects.requireNonNull(settings, "settings argument cannot be null");
        ListInfo li = new ListInfo();
        li.add("Docker connection", settings.getDockerConnectionURI() == null ? NOT_SET : settings.getDockerConnectionURI().toString());
        li.add("Mount NFS roots in containers", settings.isDockerMountNFSRoots());
        return li.infos;
    }

    public static List<Info> cpuInfo() {
        ListInfo li = new ListInfo();
        LinuxCpuInfo cpuinfo = new LinuxCpuInfo();
        String modelName = cpuinfo.getModelName();
        String processor = cpuinfo.getProcessor();
        String cpuMHz = cpuinfo.getCPUMHz();
        String bogomips = cpuinfo.getBogoMips();
        String cores = cpuinfo.getCores();
        li.add("CPU model name", modelName == null ? "NA" : modelName);
        li.add("CPU count", (String)(processor == null ? "NA" : "" + (Integer.parseInt(processor.trim()) + 1)));
        li.add("CPU cores", cores == null ? "NA" : cores);
        li.add("CPU clock", (cpuMHz == null ? "NA" : cpuMHz) + " MHz");
        li.add("CPU Bogomips", bogomips == null ? "NA" : bogomips);
        return li.infos;
    }

    public static List<Info> memInfo() {
        ListInfo li = new ListInfo();
        LinuxMemInfo meminfo = new LinuxMemInfo();
        String memTotal = meminfo.getMemTotal();
        li.add("Total memory", memTotal == null ? "NA" : memTotal);
        return li.infos;
    }

    public static List<Info> partitionInfo(Settings settings) {
        Objects.requireNonNull(settings, "settings argument cannot be null");
        LinkedHashSet<Info> set = new LinkedHashSet<Info>();
        for (String p : new HashSet<String>(Arrays.asList("/", "/tmp", "/var", settings.getTempDirectory(), settings.getExecutablesTempDirectory()))) {
            File f;
            if (p == null || !(f = new File(p)).exists()) continue;
            try {
                set.add(Infos.diskFreeInfo(f));
            }
            catch (IOException iOException) {}
        }
        return new ArrayList<Info>(set);
    }

    private static class DiskFree {
        private final FileStore fileStore;

        public long getCapacity() throws IOException {
            return this.fileStore.getTotalSpace();
        }

        public long getUsed() throws IOException {
            return this.fileStore.getTotalSpace() - this.fileStore.getUsableSpace();
        }

        public long getAvailable() throws IOException {
            return this.fileStore.getUsableSpace();
        }

        public double getPercentUsed() throws IOException {
            return (double)this.getUsed() / (double)this.getCapacity();
        }

        public double getIntPercentUsed() throws IOException {
            return (int)(this.getPercentUsed() * 100.0);
        }

        public String getDescription() {
            return this.fileStore.name() + " : " + this.fileStore.type() + " : " + this.fileStore.toString();
        }

        public DiskFree(File file) throws IOException {
            this.fileStore = Files.getFileStore(file.toPath());
        }
    }

    private static class ListInfo {
        private final List<Info> infos = new ArrayList<Info>();

        private ListInfo() {
        }

        public List<Info> getList() {
            return this.infos;
        }

        public void add(String name, int value) {
            this.infos.add(new Info(name, value));
        }

        public void add(String name, boolean value) {
            this.infos.add(new Info(name, value));
        }

        public void add(String name, String value) {
            this.infos.add(new Info(name, value));
        }

        public void add(String name, List<String> values, String defaultValue) {
            this.infos.add(new Info(name, values, defaultValue));
        }
    }

    public static class Info {
        private final String name;
        private final List<String> values;

        public String getName() {
            return this.name;
        }

        public List<String> getValues() {
            return this.values;
        }

        public int maxValueLength() {
            int result = -1;
            for (String s : this.values) {
                result = Math.max(result, s.length());
            }
            return result;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.values);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Info)) {
                return false;
            }
            Info that = (Info)obj;
            return Objects.equals(this.name, that.name) && Objects.equals(this.values, that.values);
        }

        public Info(String name, int value) {
            this(name, "" + value);
        }

        public Info(String name, boolean value) {
            this(name, value ? "True" : "False");
        }

        public Info(String name, String value) {
            this(name, value, Infos.NOT_SET);
        }

        public Info(String name, String value, String defaultValue) {
            this(name, value == null ? Collections.singletonList(defaultValue) : Collections.singletonList(value));
        }

        public Info(String name, List<String> values, String defaultValue) {
            this(name, values.isEmpty() ? Collections.singletonList(Infos.NOT_SET) : values);
        }

        public Info(String name, List<String> values) {
            Objects.requireNonNull(name, "name argument cannot be null");
            Objects.requireNonNull(values, "values argument cannot be null");
            this.name = name;
            this.values = values;
        }
    }
}

