/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.LocalEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.Settings;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public final class MainCLI
extends Main {
    private static final String LAUNCH_MODE_NAME = "local";

    @Override
    protected Options makeOptions() {
        Options options = super.makeOptions();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"JAVA_HOME path");
        options.addOption(OptionBuilder.create((char)'j'));
        OptionBuilder.withArgName((String)"size");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"maximal memory usage for JVM in MB (4096 by default)");
        options.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.withArgName((String)"args");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"JVM arguments (-server by default)");
        options.addOption(OptionBuilder.create((char)'J'));
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"JVM working directory");
        options.addOption(OptionBuilder.create((char)'w'));
        OptionBuilder.withArgName((String)"classpath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"additional classpath for eoulsan plugins");
        options.addOption(OptionBuilder.create((char)'p'));
        return options;
    }

    @Override
    protected void initializeRuntime(Settings settings) {
        LocalEoulsanRuntime.newEoulsanRuntime(settings);
    }

    @Override
    protected String getHelpEoulsanCommand() {
        return Globals.APP_NAME_LOWER_CASE;
    }

    @Override
    protected Handler getLogHandler(URI logFile) throws IOException {
        if (logFile == null) {
            throw new NullPointerException("The log file is null");
        }
        File file = new File(logFile);
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IOException("Unable to create directory " + parentFile + " for log file:" + logFile);
        }
        return new FileHandler(file.getAbsolutePath());
    }

    protected MainCLI(String[] args) {
        super(LAUNCH_MODE_NAME, args);
    }
}

