/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan;

import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.Utils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

public final class Settings
implements Serializable {
    private static final long serialVersionUID = -7897805708866950402L;
    private static final String MAIN_PREFIX_KEY = "main.";
    private final Properties properties = new Properties();
    private static final String DEBUG_KEY = "main.debug";
    private static final String AWS_ACCESS_KEY = "aws.access.key";
    private static final String AWS_SECRET_KEY = "aws.secret.key";
    private static final String PRINT_STACK_TRACE_KEY = "main.printstacktrace";
    private static final String BYPASS_PLATFORM_CHECKING_KEY = "main.bypass.platform.checking";
    private static final String TMP_DIR_KEY = "main.tmp.dir";
    private static final String EXECUTABLES_TMP_DIR_KEY = "main.executables.tmp.dir";
    private static final String LOCAL_THREADS_NUMBER = "main.local.threads";
    private static final String OUTPUT_TREE_TYPE = "main.output.tree.type";
    private static final String SAVE_WORKFLOW_IMAGE_KEY = "main.generate.workflow.image";
    public static final String DATA_FORMAT_PATH_KEY = "main.format.path";
    public static final String GALAXY_TOOL_PATH_KEY = "main.galaxy.tool.path";
    private static final String HADOOP_AWS_ACCESS_KEY = "hadoop.conf.fs.s3n.awsAccessKeyId";
    private static final String HADOOP_AWS_SECRET_KEY = "hadoop.conf.fs.s3n.awsSecretAccessKey";
    private static final String CLUSTER_SCHEDULER_NAME_KEY = "main.cluster.scheduler.name";
    private static final String CLUSTER_DEFAULT_MEMORY_REQUIRED = "main.cluster.memory.required";
    private static final String HADOOP_LOG_LEVEL_KEY = "main.hadoop.log.level";
    private static final String RSERVE_ENABLED_KEY = "main.rserve.enable";
    private static final String RSERVE_SERVER_NAME_KEY = "main.rserve.servername";
    private static final String RSERVE_KEEP_FILES_KEY = "main.rserve.keep.files";
    private static final String SAVE_RSCRIPTS_KEY = "main.save.r.scripts";
    private static final String OBFUSCATE_DESIGN_KEY = "main.design.obfuscate";
    private static final String OBFUSCATE_DESIGN_REMOVE_REPLICATE_INFO_KEY = "main.design.remove.replicate.info";
    private static final String DEFAULT_FASTQ_FORMAT_KEY = "main.default.fastq.format";
    private static final String GENOME_MAPPER_INDEX_STORAGE_KEY = "main.genome.mapper.index.storage.path";
    private static final String GENOME_DESC_STORAGE_KEY = "main.genome.desc.storage.path";
    private static final String GENOME_STORAGE_KEY = "main.genome.storage.path";
    private static final String GFF_STORAGE_KEY = "main.gff.storage.path";
    private static final String GTF_STORAGE_KEY = "main.gtf.storage.path";
    private static final String ADDITIONAL_ANNOTATION_STORAGE_KEY = "main.additional.annotation.storage.path";
    private static final String ADDITIONAL_ANNOTATION_HYPERTEXT_LINKS_KEY = "main.additional.annotation.hypertext.links.path";
    private static final String SEND_RESULT_MAIL_KEY = "main.mail.send.result.mail";
    private static final String RESULT_MAIL_KEY = "main.mail.send.result.mail.to";
    private static final String SMTP_HOST_KEY = "main.mail.smtp.host";
    private static final String DOCKER_BACKEND_KEY = "main.docker.backend";
    private static final String DOCKER_URI_KEY = "main.docker.uri";
    private static final String DOCKER_SINGULARITY_ENABLED_KEY = "main.docker.singularity.enabled";
    private static final String DOCKER_SINGULARITY_STORAGE_KEY = "main.docker.singularity.storage.path";
    private static final String DOCKER_MOUNT_NFS_ROOTS_KEY = "main.docker.mount.nfs.roots";
    private static final String ZOOKEEPER_CONNECT_STRING_KEY = "zookeeper.connect.string";
    private static final String ZOOKEEPER_DEFAULT_PORT_KEY = "zookeeper.default.port";
    private static final String ZOOKEEPER_SESSION_TIMEOUT_KEY = "zookeeper.session.timeout";
    private static final String USE_OLD_EOULSAN_RESULT_FORMAT_KEY = "main.old.result.format";
    private static final String UI_NAME_KEY = "main.ui.name";
    public static final String STANDARD_EXTERNAL_MODULES_ENABLED_KEY = "main.standard.external.modules.enabled";
    private static final Set<String> FORBIDDEN_KEYS = Utils.unmodifiableSet((Object[])new String[]{"hadoop.conf.fs.s3n.awsAccessKeyId", "hadoop.conf.fs.s3n.awsSecretAccessKey"});
    private static final Set<String> OBFUSCATED_KEYS = Utils.unmodifiableSet((Object[])new String[]{"aws.access.key", "aws.secret.key", "hadoop.conf.fs.s3n.awsAccessKeyId", "hadoop.conf.fs.s3n.awsSecretAccessKey"});

    public boolean isSetting(String key) {
        return this.properties.containsKey(key);
    }

    public boolean isDebug() {
        String value = this.properties.getProperty(DEBUG_KEY, Boolean.toString(Globals.DEBUG));
        return Boolean.valueOf(value);
    }

    public boolean isPrintStackTrace() {
        String value = this.properties.getProperty(PRINT_STACK_TRACE_KEY, Boolean.toString(Globals.PRINT_STACK_TRACE_DEFAULT));
        return Boolean.valueOf(value);
    }

    public String getAWSAccessKey() {
        return this.properties.getProperty(AWS_ACCESS_KEY);
    }

    public String getAWSSecretKey() {
        return this.properties.getProperty(AWS_SECRET_KEY);
    }

    public String getHadoopLogLevel() {
        return this.properties.getProperty(HADOOP_LOG_LEVEL_KEY);
    }

    public String getClusterSchedulerName() {
        return this.properties.getProperty(CLUSTER_SCHEDULER_NAME_KEY);
    }

    public int getDefaultClusterMemoryRequired() {
        String value = this.properties.getProperty(CLUSTER_DEFAULT_MEMORY_REQUIRED);
        if (value == null) {
            return -1;
        }
        if ((value = value.trim()).isEmpty()) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public boolean isRServeServerEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(RSERVE_ENABLED_KEY));
    }

    public boolean isSaveRscripts() {
        return Boolean.parseBoolean(this.properties.getProperty(SAVE_RSCRIPTS_KEY));
    }

    public String getRServeServerName() {
        return this.properties.getProperty(RSERVE_SERVER_NAME_KEY);
    }

    public boolean isKeepRServeFiles() {
        return Boolean.parseBoolean(this.properties.getProperty(RSERVE_KEEP_FILES_KEY));
    }

    public String getTempDirectory() {
        return this.properties.getProperty(TMP_DIR_KEY, System.getProperty("java.io.tmpdir"));
    }

    public File getTempDirectoryFile() {
        return new File(this.getTempDirectory());
    }

    public boolean isUserDefinedTempDirectory() {
        return this.properties.containsKey(TMP_DIR_KEY);
    }

    public String getExecutablesTempDirectory() {
        return this.properties.getProperty(EXECUTABLES_TMP_DIR_KEY, this.getTempDirectory());
    }

    public File getExecutablesTempDirectoryFile() {
        return new File(this.getExecutablesTempDirectory());
    }

    public boolean isObfuscateDesign() {
        return Boolean.parseBoolean(this.properties.getProperty(OBFUSCATE_DESIGN_KEY, Boolean.toString(true)));
    }

    public boolean isObfuscateDesignRemoveReplicateInfo() {
        return Boolean.parseBoolean(this.properties.getProperty(OBFUSCATE_DESIGN_REMOVE_REPLICATE_INFO_KEY, Boolean.toString(true)));
    }

    public int getLocalThreadsNumber() {
        return Integer.parseInt(this.properties.getProperty(LOCAL_THREADS_NUMBER, "" + Runtime.getRuntime().availableProcessors()));
    }

    public FastqFormat getDefaultFastqFormat() {
        return FastqFormat.getFormatFromName((String)this.properties.getProperty(DEFAULT_FASTQ_FORMAT_KEY, Globals.FASTQ_FORMAT_DEFAULT.getName()));
    }

    public boolean isBypassPlatformChecking() {
        return Boolean.parseBoolean(this.properties.getProperty(BYPASS_PLATFORM_CHECKING_KEY));
    }

    public String getGenomeMapperIndexStoragePath() {
        return this.properties.getProperty(GENOME_MAPPER_INDEX_STORAGE_KEY);
    }

    public String getGenomeDescStoragePath() {
        return this.properties.getProperty(GENOME_DESC_STORAGE_KEY);
    }

    public String getGenomeStoragePath() {
        return this.properties.getProperty(GENOME_STORAGE_KEY);
    }

    public String getGFFStoragePath() {
        return this.properties.getProperty(GFF_STORAGE_KEY);
    }

    public String getGTFStoragePath() {
        return this.properties.getProperty(GTF_STORAGE_KEY);
    }

    public String getAdditionalAnnotationStoragePath() {
        return this.properties.getProperty(ADDITIONAL_ANNOTATION_STORAGE_KEY);
    }

    public String getAdditionalAnnotationHypertextLinksPath() {
        return this.properties.getProperty(ADDITIONAL_ANNOTATION_HYPERTEXT_LINKS_KEY);
    }

    public boolean isSendResultMail() {
        return Boolean.parseBoolean(this.properties.getProperty(SEND_RESULT_MAIL_KEY));
    }

    public String getResultMail() {
        return this.properties.getProperty(RESULT_MAIL_KEY);
    }

    public String getSMTPHost() {
        return this.properties.getProperty(SMTP_HOST_KEY);
    }

    public String getZooKeeperConnectString() {
        return this.properties.getProperty(ZOOKEEPER_CONNECT_STRING_KEY);
    }

    public int getZooKeeperDefaultPort() {
        return Integer.parseInt(this.properties.getProperty(ZOOKEEPER_DEFAULT_PORT_KEY, "2181"));
    }

    public int getZooKeeperSessionTimeout() {
        return Integer.parseInt(this.properties.getProperty(ZOOKEEPER_SESSION_TIMEOUT_KEY, "10000"));
    }

    public boolean isUseOldEoulsanResultFormat() {
        return Boolean.parseBoolean(this.properties.getProperty(USE_OLD_EOULSAN_RESULT_FORMAT_KEY, "false"));
    }

    public String getUIName() {
        return this.properties.getProperty(UI_NAME_KEY, "lanterna");
    }

    public String getDockerBackend() {
        return this.properties.getProperty(DOCKER_BACKEND_KEY);
    }

    public String getDockerConnection() {
        return this.properties.getProperty(DOCKER_URI_KEY);
    }

    public boolean isDockerBySingularityEnabled() {
        return Boolean.parseBoolean(this.properties.getProperty(DOCKER_SINGULARITY_ENABLED_KEY));
    }

    public String getDockerSingularityStoragePath() {
        return this.properties.getProperty(DOCKER_SINGULARITY_STORAGE_KEY);
    }

    public boolean isDockerConnectionDefined() {
        String connection = this.getDockerConnection();
        return connection != null && !connection.trim().isEmpty();
    }

    public boolean isDockerMountNFSRoots() {
        return Boolean.parseBoolean(this.properties.getProperty(DOCKER_MOUNT_NFS_ROOTS_KEY, "false"));
    }

    public URI getDockerConnectionURI() {
        String connectionString = this.getDockerConnection();
        if (connectionString == null || connectionString.trim().isEmpty()) {
            return null;
        }
        try {
            return new URI(connectionString);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public List<String> getDataFormatPaths() {
        String value = this.properties.getProperty(DATA_FORMAT_PATH_KEY);
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : value.split(" ")) {
            if (s.isEmpty()) continue;
            result.add(s);
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> getGalaxyToolPaths() {
        String value = this.properties.getProperty(GALAXY_TOOL_PATH_KEY);
        if (value == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : value.split(" ")) {
            if (s.isEmpty()) continue;
            result.add(s);
        }
        return Collections.unmodifiableList(result);
    }

    public String getOutputTreeType() {
        return this.properties.getProperty(OUTPUT_TREE_TYPE, "step");
    }

    public boolean isSaveWorkflowImage() {
        return Boolean.parseBoolean(this.properties.getProperty(SAVE_WORKFLOW_IMAGE_KEY, "true"));
    }

    public boolean isUseStandardExternalModules() {
        return Boolean.parseBoolean(this.properties.getProperty(STANDARD_EXTERNAL_MODULES_ENABLED_KEY, "true"));
    }

    public String getSetting(String settingName) {
        if (settingName == null) {
            return null;
        }
        if (settingName.startsWith(MAIN_PREFIX_KEY)) {
            return null;
        }
        return this.properties.getProperty(settingName);
    }

    public int getIntSetting(String settingName) throws EoulsanException {
        if (settingName == null) {
            throw new EoulsanException("The setting name is null");
        }
        String value = this.getSetting(settingName);
        if (value == null) {
            throw new EoulsanException("Invalid parameter, an integer parameter is need for " + settingName + " parameter: null");
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new EoulsanException("Invalid parameter, an integer parameter is need for " + settingName + " parameter: " + value);
        }
    }

    public double getDoubleSetting(String settingName) throws EoulsanException {
        if (settingName == null) {
            throw new EoulsanException("The setting name is null");
        }
        String value = this.getSetting(settingName);
        if (value == null) {
            throw new EoulsanException("Invalid parameter, an integer parameter is need for " + settingName + " parameter: null");
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new EoulsanException("Invalid parameter, an integer parameter is need for " + settingName + " parameter: " + value);
        }
    }

    public boolean getBooleanSetting(String settingName) {
        return Boolean.parseBoolean(this.getSetting(settingName));
    }

    public Set<String> getSettingsNames() {
        HashSet<String> result = new HashSet<String>();
        for (String key : this.properties.stringPropertyNames()) {
            if (key.startsWith(MAIN_PREFIX_KEY)) continue;
            result.add(key);
        }
        return result;
    }

    public void setDebug(boolean debug) {
        this.properties.setProperty(DEBUG_KEY, Boolean.toString(debug));
    }

    public void setPrintStackTrace(boolean printStackTrace) {
        this.properties.setProperty(PRINT_STACK_TRACE_KEY, Boolean.toString(printStackTrace));
    }

    public void setAWSAccessKey(String value) {
        if (value == null) {
            return;
        }
        this.properties.setProperty(AWS_ACCESS_KEY, value);
        this.properties.setProperty(HADOOP_AWS_ACCESS_KEY, value);
    }

    public void setAWSSecretKey(String value) {
        if (value == null) {
            return;
        }
        this.properties.setProperty(AWS_SECRET_KEY, value);
        this.properties.setProperty(HADOOP_AWS_SECRET_KEY, value);
    }

    public void setHadoopLogLevel(String value) {
        this.properties.setProperty(HADOOP_LOG_LEVEL_KEY, value);
    }

    public void setClusterSchedulerName(String schedulerName) {
        this.properties.setProperty(CLUSTER_SCHEDULER_NAME_KEY, schedulerName);
    }

    public void setDefaultClusterMemoryRequired(int memory) {
        this.properties.setProperty(CLUSTER_DEFAULT_MEMORY_REQUIRED, "" + memory);
    }

    public void setRServeServerEnabled(boolean enable) {
        this.properties.setProperty(RSERVE_ENABLED_KEY, Boolean.toString(enable));
    }

    public void setSaveRscript(boolean krs) {
        this.properties.setProperty(SAVE_RSCRIPTS_KEY, Boolean.toString(krs));
    }

    public void setKeepRServeFiles(boolean keepRServeFiles) {
        this.properties.setProperty(RSERVE_KEEP_FILES_KEY, Boolean.toString(keepRServeFiles));
    }

    public void setRServeServerName(String serverName) {
        this.properties.setProperty(RSERVE_SERVER_NAME_KEY, serverName);
    }

    public void setTempDirectory(String tempDirectory) {
        if (tempDirectory != null) {
            this.properties.setProperty(TMP_DIR_KEY, tempDirectory);
        }
    }

    public void setExecutablesTempDirectory(String executablesTempDirectory) {
        if (executablesTempDirectory != null) {
            this.properties.setProperty(EXECUTABLES_TMP_DIR_KEY, executablesTempDirectory);
        }
    }

    public void setObfuscateDesign(boolean obfuscate) {
        this.properties.setProperty(OBFUSCATE_DESIGN_KEY, Boolean.toString(obfuscate));
    }

    public void setObfuscateRemoveDesignInfo(boolean remove) {
        this.properties.setProperty(OBFUSCATE_DESIGN_REMOVE_REPLICATE_INFO_KEY, Boolean.toString(remove));
    }

    public void setLocalThreadsNumber(int threadsNumber) {
        if (threadsNumber < 0) {
            return;
        }
        this.properties.setProperty(LOCAL_THREADS_NUMBER, Integer.toString(threadsNumber));
    }

    public void setDefaultFastqFormat(FastqFormat format) {
        if (format == null) {
            throw new NullPointerException("The FastqFormat is null");
        }
        this.properties.setProperty(DEFAULT_FASTQ_FORMAT_KEY, format.getName());
    }

    public void setBypassPlatformChecking(boolean bypass) {
        this.properties.setProperty(BYPASS_PLATFORM_CHECKING_KEY, Boolean.toString(bypass));
    }

    public void setGenomeMapperIndexStoragePath(String genomeMapperIndexStoragePath) {
        this.properties.setProperty(GENOME_MAPPER_INDEX_STORAGE_KEY, genomeMapperIndexStoragePath);
    }

    public void setGenomeDescStoragePath(String genomeDescStoragePath) {
        this.properties.setProperty(GENOME_DESC_STORAGE_KEY, genomeDescStoragePath);
    }

    public void setGenomeStoragePath(String genomeStoragePath) {
        this.properties.setProperty(GENOME_STORAGE_KEY, genomeStoragePath);
    }

    public void setGFFStoragePath(String gffStoragePath) {
        this.properties.setProperty(GFF_STORAGE_KEY, gffStoragePath);
    }

    public void setGTFStoragePath(String gtfStoragePath) {
        this.properties.setProperty(GTF_STORAGE_KEY, gtfStoragePath);
    }

    public void setAdditionalAnnotationStoragePath(String additionalAnnotationStoragePath) {
        this.properties.setProperty(ADDITIONAL_ANNOTATION_STORAGE_KEY, additionalAnnotationStoragePath);
    }

    public void setAdditionalAnnotationHypertextLinksPath(String additionalAnnotationHypertextLinksPath) {
        this.properties.setProperty(ADDITIONAL_ANNOTATION_HYPERTEXT_LINKS_KEY, additionalAnnotationHypertextLinksPath);
    }

    public void setSendResultMail(boolean enableSendResultMail) {
        this.properties.setProperty(SEND_RESULT_MAIL_KEY, Boolean.toString(enableSendResultMail));
    }

    public void setResultMail(String mail) {
        this.properties.setProperty(RESULT_MAIL_KEY, mail);
    }

    public void setSMTPHost(String smtpHost) {
        this.properties.setProperty(SMTP_HOST_KEY, smtpHost);
    }

    public void setZooKeeperConnectString(String connectString) {
        this.properties.setProperty(ZOOKEEPER_CONNECT_STRING_KEY, connectString);
    }

    public void setZooKeeperDefaultPort(int port) {
        this.properties.setProperty(ZOOKEEPER_DEFAULT_PORT_KEY, "" + port);
    }

    public void setZooKeeperSessionTimeout(int timeout) {
        this.properties.setProperty(ZOOKEEPER_SESSION_TIMEOUT_KEY, "" + timeout);
    }

    public void setUseOldEoulsanResultFormat(boolean useOldEoulsanResultFormat) {
        this.properties.setProperty(USE_OLD_EOULSAN_RESULT_FORMAT_KEY, Boolean.toString(useOldEoulsanResultFormat));
    }

    public void setUIName(String uiName) {
        this.properties.setProperty(UI_NAME_KEY, uiName);
    }

    public void setDockerBackEnd(String backend) {
        this.properties.setProperty(DOCKER_BACKEND_KEY, backend);
    }

    public void setDockerConnectionURI(String uri) {
        this.properties.setProperty(DOCKER_URI_KEY, uri);
    }

    public void setDockerBySingularityEnabled(boolean enabled) {
        this.properties.setProperty(DOCKER_SINGULARITY_ENABLED_KEY, "" + enabled);
    }

    public void setDockerSingularityStoragePath(String storagePath) {
        this.properties.setProperty(DOCKER_SINGULARITY_STORAGE_KEY, storagePath);
    }

    public void setDockerMountNFSRoots(boolean enable) {
        this.properties.setProperty(DOCKER_MOUNT_NFS_ROOTS_KEY, "" + enable);
    }

    public void setDataFormatPath(String path) {
        this.properties.setProperty(DATA_FORMAT_PATH_KEY, path);
    }

    public void setDataFormatPaths(List<String> paths) {
        Objects.requireNonNull(paths);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : paths) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(s);
        }
        this.setDataFormatPath(sb.toString());
    }

    public void setGalaxyToolPath(String path) {
        this.properties.setProperty(GALAXY_TOOL_PATH_KEY, path);
    }

    public void setGalaxyToolsPaths(List<String> paths) {
        Objects.requireNonNull(paths);
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : paths) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(s);
        }
        this.setGalaxyToolPath(sb.toString());
    }

    public void setOutputTreeType(String outputTreeType) {
        this.properties.getProperty(OUTPUT_TREE_TYPE, outputTreeType);
    }

    public void setSaveWorkflowImage(boolean save) {
        this.properties.setProperty(SAVE_WORKFLOW_IMAGE_KEY, "" + save);
    }

    public void setUseStandardExternalModules(boolean enable) {
        this.properties.getProperty(STANDARD_EXTERNAL_MODULES_ENABLED_KEY, "" + enable);
    }

    public void setSetting(String settingName, String settingValue) {
        this.setSetting(settingName, settingValue, true);
    }

    public void setSetting(String settingName, String settingValue, boolean logChange) {
        if (settingName == null || settingValue == null) {
            return;
        }
        String key = settingName.toLowerCase();
        if (FORBIDDEN_KEYS.contains(key)) {
            return;
        }
        this.properties.setProperty(Settings.checkDeprecatedKey(key), settingValue);
        if (logChange) {
            this.logSetting(key);
        }
    }

    public static String getConfigurationFilePath() {
        String os = System.getProperty("os.name");
        String home = System.getProperty("user.home");
        if (os.toLowerCase(Globals.DEFAULT_LOCALE).startsWith("windows")) {
            return home + File.separator + "Application Data" + File.separator + Globals.APP_NAME_LOWER_CASE + ".conf";
        }
        return home + File.separator + "." + Globals.APP_NAME_LOWER_CASE;
    }

    public Properties getJavaMailSMTPProperties() {
        Properties result = new Properties();
        for (Map.Entry<Object, Object> e : this.properties.entrySet()) {
            String key = (String)e.getKey();
            String value = (String)e.getValue();
            String prefix = "main.mail.smtp.";
            int keyPosStart = MAIN_PREFIX_KEY.length();
            if (key == null || !key.startsWith("main.mail.smtp.")) continue;
            result.setProperty(key.substring(keyPosStart), value);
        }
        return result;
    }

    public void saveSettings() throws IOException {
        this.saveSettings(new File(Settings.getConfigurationFilePath()));
    }

    public void saveSettings(File file) throws IOException {
        OutputStream os = FileUtils.createOutputStream((File)file);
        this.properties.store(os, " Eoulsan version " + Globals.APP_VERSION_STRING + " configuration file");
        os.close();
    }

    public void loadSettings() throws IOException, EoulsanException {
        File confFile = new File(Settings.getConfigurationFilePath());
        if (confFile.exists()) {
            this.loadSettings(confFile);
        } else {
            EoulsanLogger.getLogger().config("No configuration file found.");
        }
    }

    public void loadSettings(File file) throws IOException, EoulsanException {
        EoulsanLogger.getLogger().info("Load configuration file: " + file.getAbsolutePath());
        InputStream is = FileUtils.createInputStream((File)file);
        Properties tmpProperties = new Properties();
        tmpProperties.load(FileUtils.createInputStream((File)file));
        is.close();
        for (String key : tmpProperties.stringPropertyNames()) {
            if (FORBIDDEN_KEYS.contains(key)) {
                throw new EoulsanException("Forbiden key found in configuration file: " + key);
            }
            this.properties.setProperty(Settings.checkDeprecatedKey(key), tmpProperties.getProperty(key));
        }
    }

    public void setSettings(Settings settings) {
        if (settings == null) {
            throw new NullPointerException("settings arguments cannot be null");
        }
        this.properties.putAll((Map<?, ?>)settings.properties);
    }

    private void init() {
        EoulsanLogger.getLogger().info("System temp directory: " + System.getProperty("java.io.tmpdir"));
    }

    public void logSettings() {
        for (Object key : this.properties.keySet()) {
            this.logSetting((String)key);
        }
    }

    private void logSetting(String key) {
        if (OBFUSCATED_KEYS.contains(key)) {
            EoulsanLogger.getLogger().info("Setting: " + key + "=xxxx value not shown xxxx");
        } else {
            EoulsanLogger.getLogger().info("Setting: " + key + "=" + this.properties.getProperty(key));
        }
    }

    public Set<String> getSettingsKeyToObfuscated() {
        return OBFUSCATED_KEYS;
    }

    private static String checkDeprecatedKey(String key) {
        String trimmedKey;
        if (key == null) {
            return null;
        }
        switch (trimmedKey = key.trim().toLowerCase()) {
            case "main.accesskey": {
                Settings.printWarningRenamedSetting(trimmedKey, AWS_ACCESS_KEY);
                break;
            }
            case "main.awssecretkey": {
                Settings.printWarningRenamedSetting(trimmedKey, AWS_SECRET_KEY);
                break;
            }
            case "main.annotation.storage.path": {
                Settings.printWarningRenamedSetting(trimmedKey, GFF_STORAGE_KEY);
                return GFF_STORAGE_KEY;
            }
            default: {
                return key;
            }
        }
        return key;
    }

    private static void printWarningRenamedSetting(String oldName, String newName) {
        Common.printWarning("The global/configuration parameter \"" + oldName + "\" is now deprecated. Please use the \"" + newName + "\" parameter instead");
    }

    Settings() throws IOException, EoulsanException {
        this(false);
    }

    Settings(boolean loadDefaultConfigurationFile) throws IOException, EoulsanException {
        this.init();
        if (!loadDefaultConfigurationFile) {
            this.loadSettings();
        }
    }

    Settings(File file) throws IOException, EoulsanException {
        this.init();
        this.loadSettings(file);
    }

    public String toString() {
        return this.properties.toString();
    }
}

