/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Settings;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractAction;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.workflow.CommandWorkflowParser;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public abstract class AbstractInfoAction
extends AbstractAction {
    @Override
    public String getDescription() {
        return "show information about " + this.getName() + " configuration.";
    }

    @Override
    public void action(List<String> arguments) {
        DataFile workflowFile;
        Options options = AbstractInfoAction.makeOptions();
        GnuParser parser = new GnuParser();
        try {
            CommandLine line = parser.parse(options, arguments.toArray(new String[0]), true);
            if (line.hasOption("help")) {
                this.help(options);
            }
        }
        catch (ParseException e) {
            Common.errorExit(e, "Error while parsing command line arguments: " + e.getMessage());
        }
        Settings settings = EoulsanRuntime.getSettings();
        switch (arguments.size()) {
            case 0: {
                workflowFile = null;
                break;
            }
            case 1: {
                workflowFile = new DataFile(arguments.get(0));
                break;
            }
            default: {
                this.help(options);
                workflowFile = null;
            }
        }
        if (workflowFile != null) {
            try {
                CommandWorkflowParser cwp = new CommandWorkflowParser(workflowFile);
                for (Parameter p : cwp.parse().getGlobalParameters()) {
                    settings.setSetting(p.getName(), p.getStringValue());
                }
            }
            catch (IOException e) {
                Common.errorExit(e, "Error while reading workflow file: " + e.getMessage());
            }
            catch (EoulsanException e) {
                Common.errorExit(e, "Error while parsing workflow file: " + e.getMessage());
            }
        }
        this.showInfo(settings);
    }

    protected abstract void showInfo(Settings var1);

    private static Options makeOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "Display this help");
        return options;
    }

    private void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Globals.APP_NAME_LOWER_CASE + ".sh " + this.getName() + " [options] [workflowfile]", options);
        Common.exit(0);
    }
}

