/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import fr.ens.biologie.genomique.eoulsan.AbstractEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.EoulsanRuntimeException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.LocalEoulsanRuntime;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractAction;
import fr.ens.biologie.genomique.eoulsan.core.workflow.TaskSerializationUtils;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ClusterTaskAction
extends AbstractAction {
    public static final String ACTION_NAME = "clustertask";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getDescription() {
        return "execute a cluster task";
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public void action(List<String> arguments) {
        Options options = this.makeOptions();
        GnuParser parser = new GnuParser();
        int argsOptions = 0;
        try {
            CommandLine line = parser.parse(options, arguments.toArray(new String[0]), true);
            if (line.hasOption("help")) {
                this.help(options);
            }
        }
        catch (ParseException e) {
            Common.errorExit(e, "Error while parsing parameter file: " + e.getMessage());
        }
        if (arguments.size() != argsOptions + 1) {
            this.help(options);
        }
        DataFile contextFile = new DataFile(arguments.get(0));
        ClusterTaskAction.run(contextFile);
    }

    private Options makeOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "display this help");
        return options;
    }

    private void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Globals.APP_NAME_LOWER_CASE + ".sh " + this.getName() + " [options] stepcontext.context", options);
        Common.exit(0);
    }

    private static void run(DataFile taskContextFile) {
        Objects.requireNonNull(taskContextFile, "contextFile is null");
        LocalEoulsanRuntime localRuntime = (LocalEoulsanRuntime)EoulsanRuntime.getRuntime();
        localRuntime.setMode(AbstractEoulsanRuntime.EoulsanExecMode.CLUSTER_TASK);
        try {
            TaskSerializationUtils.execute(taskContextFile);
        }
        catch (FileNotFoundException e) {
            Common.errorExit(e, "File not found: " + e.getMessage());
        }
        catch (IOException e) {
            Common.errorExit(e, "IOException: " + e.getMessage());
        }
        catch (EoulsanRuntimeException e) {
            Common.errorExit(e, "Error while executing " + Globals.APP_NAME_LOWER_CASE + ": " + e.getMessage());
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

