/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractAction;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.design.Design;
import fr.ens.biologie.genomique.eoulsan.design.DesignBuilder;
import fr.ens.biologie.genomique.eoulsan.design.DesignUtils;
import fr.ens.biologie.genomique.eoulsan.design.io.DesignWriter;
import fr.ens.biologie.genomique.eoulsan.design.io.Eoulsan1DesignWriter;
import fr.ens.biologie.genomique.eoulsan.design.io.Eoulsan2DesignWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CreateDesignAction
extends AbstractAction {
    public static final String ACTION_NAME = "createdesign";
    private static final int DEFAULT_DESIGN_FORMAT = 2;

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getDescription() {
        return "create a design file from a list of files.";
    }

    @Override
    public boolean isCurrentArchCompatible() {
        return true;
    }

    @Override
    public void action(List<String> arguments) {
        int formatVersion;
        boolean symlinks;
        String samplesProjectName;
        ArrayList<String> sampleSheetPaths;
        boolean pairedEndMode;
        int argsOptions;
        String filename;
        block22: {
            Options options = CreateDesignAction.makeOptions();
            GnuParser parser = new GnuParser();
            filename = "design.txt";
            argsOptions = 0;
            pairedEndMode = false;
            sampleSheetPaths = new ArrayList<String>();
            samplesProjectName = null;
            symlinks = false;
            formatVersion = 2;
            try {
                CommandLine line = parser.parse(options, arguments.toArray(new String[0]), true);
                if (line.hasOption("paired-end")) {
                    pairedEndMode = true;
                    ++argsOptions;
                }
                if (line.hasOption("help")) {
                    CreateDesignAction.help(options);
                }
                if (line.hasOption("o")) {
                    filename = line.getOptionValue("o");
                    argsOptions += 2;
                }
                if (line.hasOption("s")) {
                    String[] sampleSheets = line.getOptionValues("s");
                    sampleSheetPaths.addAll(Arrays.asList(sampleSheets));
                    argsOptions += sampleSheets.length * 2;
                }
                if (line.hasOption("n")) {
                    samplesProjectName = line.getOptionValue("n");
                    argsOptions += 2;
                }
                if (line.hasOption("symlinks")) {
                    symlinks = true;
                    ++argsOptions;
                }
                if (!line.hasOption("f")) break block22;
                try {
                    formatVersion = Integer.parseInt(line.getOptionValue("f").trim());
                }
                catch (NumberFormatException e) {
                    Common.errorExit(e, "Invalid Eoulsan design format version: " + e.getMessage());
                }
                argsOptions += 2;
            }
            catch (ParseException e) {
                Common.errorExit(e, "Error while parsing command line arguments: " + e.getMessage());
            }
        }
        Main.getInstance().flushLog();
        Design design = null;
        DataFile designFile = new DataFile(filename);
        try {
            List<String> newArgs = arguments.subList(argsOptions, arguments.size());
            DesignBuilder db = new DesignBuilder();
            for (String sampleSheetPath : sampleSheetPaths) {
                db.addBcl2FastqSamplesheetProject(new File(sampleSheetPath), samplesProjectName);
            }
            db.addFiles(newArgs);
            design = db.getDesign(pairedEndMode);
            if (symlinks) {
                DesignUtils.replaceLocalPathBySymlinks(design, designFile.getParent());
            }
        }
        catch (EoulsanException | IOException e) {
            Common.errorExit(e, "Error: " + e.getMessage());
        }
        if (design.getSamples().isEmpty()) {
            Common.showErrorMessageAndExit("Error: Nothing to create, no file found.\n  Use the -h option to get more information.\nusage: " + Globals.APP_NAME_LOWER_CASE + " createdesign files");
        }
        try {
            DesignWriter dw;
            if (designFile.exists()) {
                throw new IOException("Output design file " + designFile + " already exists");
            }
            switch (formatVersion) {
                case 1: {
                    dw = new Eoulsan1DesignWriter(designFile.create());
                    break;
                }
                case 2: {
                    dw = new Eoulsan2DesignWriter(designFile.create());
                    break;
                }
                default: {
                    Common.showErrorMessageAndExit("Unknown Eoulsan design format version: " + formatVersion);
                    return;
                }
            }
            dw.write(design);
        }
        catch (IOException e) {
            Common.errorExit(e, "File not found: " + e.getMessage());
        }
    }

    private static Options makeOptions() {
        Options options = new Options();
        options.addOption("p", "paired-end", false, "Paired-end mode");
        options.addOption("h", "help", false, "Display this help");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Illumina samplesheet file");
        OptionBuilder.withLongOpt((String)"samplesheet");
        options.addOption(OptionBuilder.create((char)'s'));
        OptionBuilder.withArgName((String)"name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Illumina project name");
        OptionBuilder.withLongOpt((String)"project-name");
        options.addOption(OptionBuilder.create((char)'n'));
        options.addOption("l", "symlinks", false, "Create symbolic links in design file directory");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Output file");
        OptionBuilder.withLongOpt((String)"output");
        options.addOption(OptionBuilder.create((char)'o'));
        OptionBuilder.withArgName((String)"version");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"Eoulsan design format version");
        OptionBuilder.withLongOpt((String)"format-version");
        options.addOption(OptionBuilder.create((char)'f'));
        return options;
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Globals.APP_NAME_LOWER_CASE + ".sh createdesign [options] file1 file2 ... fileN", options);
        Common.exit(0);
    }
}

