/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractAction;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopJarRepackager;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CreateHadoopJarAction
extends AbstractAction {
    public static final String ACTION_NAME = "createhadoopjar";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getDescription() {
        return "create a jar file for hadoop with all dependencies include.";
    }

    @Override
    public boolean isCurrentArchCompatible() {
        return true;
    }

    @Override
    public void action(List<String> arguments) {
        Options options = CreateHadoopJarAction.makeOptions();
        GnuParser parser = new GnuParser();
        int argsOptions = 0;
        try {
            CommandLine line = parser.parse(options, arguments.toArray(new String[0]), true);
            if (line.hasOption("help")) {
                CreateHadoopJarAction.help(options);
            }
        }
        catch (ParseException e) {
            Common.errorExit(e, "Error while parsing command line arguments: " + e.getMessage());
        }
        if (arguments.size() != argsOptions) {
            CreateHadoopJarAction.help(options);
        }
        Main.getInstance().flushLog();
        try {
            HadoopJarRepackager.repack();
        }
        catch (IOException e) {
            Common.errorExit(e, "Error while executing " + Globals.APP_NAME_LOWER_CASE + ": " + e.getMessage());
        }
    }

    private static Options makeOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "display this help");
        return options;
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Globals.APP_NAME_LOWER_CASE + ".sh createhadoopjar", options);
        Common.exit(0);
    }
}

