/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractAction;
import fr.ens.biologie.genomique.eoulsan.core.workflow.Executor;
import fr.ens.biologie.genomique.eoulsan.core.workflow.ExecutorArguments;
import fr.ens.biologie.genomique.eoulsan.util.LinuxCpuInfo;
import fr.ens.biologie.genomique.eoulsan.util.LinuxMemInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class ExecAction
extends AbstractAction {
    public static final String ACTION_NAME = "exec";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getDescription() {
        return "execute Eoulsan in local mode.";
    }

    @Override
    public void action(List<String> arguments) {
        Options options = ExecAction.makeOptions();
        GnuParser parser = new GnuParser();
        String jobDescription = null;
        int argsOptions = 0;
        try {
            CommandLine line = parser.parse(options, arguments.toArray(new String[0]), true);
            if (line.hasOption("help")) {
                ExecAction.help(options);
            }
            if (line.hasOption("d")) {
                jobDescription = line.getOptionValue("d");
                argsOptions += 2;
            }
        }
        catch (ParseException e) {
            Common.errorExit(e, "Error while parsing command line arguments: " + e.getMessage());
        }
        if (arguments.size() != argsOptions + 2) {
            ExecAction.help(options);
        }
        File paramFile = new File(arguments.get(argsOptions));
        File designFile = new File(arguments.get(argsOptions + 1));
        ExecAction.run(paramFile, designFile, jobDescription);
    }

    private static Options makeOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "display this help");
        OptionBuilder.withArgName((String)"description");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"job description");
        OptionBuilder.withLongOpt((String)"desc");
        options.addOption(OptionBuilder.create((char)'d'));
        return options;
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Globals.APP_NAME_LOWER_CASE + ".sh exec [options] workflow.xml design.txt", options);
        Common.exit(0);
    }

    private static void run(File workflowFile, File designFile, String jobDescription) {
        Objects.requireNonNull(workflowFile, "paramFile is null");
        Objects.requireNonNull(designFile, "designFile is null");
        String desc = jobDescription == null ? "no job description" : jobDescription.trim();
        EoulsanLogger.getLogger().info("Workflow file: " + workflowFile);
        EoulsanLogger.getLogger().info("Design file: " + designFile);
        try {
            if (!workflowFile.exists()) {
                throw new FileNotFoundException(workflowFile.toString());
            }
            if (!designFile.exists()) {
                throw new FileNotFoundException(designFile.toString());
            }
            String env = "Local Mode on " + new LinuxCpuInfo().getModelName() + ", " + Runtime.getRuntime().availableProcessors() + " CPU(s)/thread(s), " + new LinuxMemInfo().getMemTotal();
            ExecutorArguments arguments = new ExecutorArguments(workflowFile, designFile);
            arguments.setJobDescription(desc);
            arguments.setJobEnvironment(env);
            Main.getInstance().createLogFiles(arguments.logPath(Globals.LOG_FILENAME), arguments.logPath("additional.log"));
            Executor e = new Executor(arguments);
            e.execute();
        }
        catch (FileNotFoundException e) {
            Common.errorExit(e, "File not found: " + e.getMessage());
        }
        catch (Throwable e) {
            Common.errorExit(e, "Error while executing " + Globals.APP_NAME_LOWER_CASE + ": " + e.getMessage());
        }
    }
}

