/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import com.google.common.base.Joiner;
import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.Main;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractAction;
import fr.ens.biologie.genomique.eoulsan.util.hadoop.HadoopJarRepackager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class HadoopExecAction
extends AbstractAction {
    public static final String ACTION_NAME = "hadoopexec";
    private static final String HADOOP_CLIENT_OPTS_ENV = "HADOOP_CLIENT_OPTS";

    @Override
    public String getName() {
        return ACTION_NAME;
    }

    @Override
    public String getDescription() {
        return "execute Eoulsan on local hadoop cluster.";
    }

    @Override
    public void action(List<String> arguments) {
        Options options = HadoopExecAction.makeOptions();
        GnuParser parser = new GnuParser();
        String jobDescription = null;
        int argsOptions = 0;
        try {
            CommandLine line = parser.parse(options, arguments.toArray(new String[0]), true);
            if (line.hasOption("help")) {
                HadoopExecAction.help(options);
            }
            if (line.hasOption("d")) {
                jobDescription = line.getOptionValue("d");
                argsOptions += 2;
            }
        }
        catch (ParseException e) {
            Common.errorExit(e, "Error while parsing command line arguments: " + e.getMessage());
        }
        if (arguments.size() != argsOptions + 3) {
            HadoopExecAction.help(options);
        }
        File paramFile = new File(arguments.get(argsOptions));
        File designFile = new File(arguments.get(argsOptions + 1));
        String hdfsPath = arguments.get(argsOptions + 2);
        HadoopExecAction.run(paramFile, designFile, hdfsPath, jobDescription);
    }

    private static Options makeOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "display this help");
        OptionBuilder.withArgName((String)"description");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"job description");
        OptionBuilder.withLongOpt((String)"desc");
        options.addOption(OptionBuilder.create((char)'d'));
        return options;
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Globals.APP_NAME_LOWER_CASE + ".sh hadoopexec [options] workflow.xml design.txt hdfs://server/path", options);
        Common.exit(0);
    }

    private static String getJVMArgs() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (String a : Main.getInstance().getJVMArgs()) {
            if (!a.startsWith("-Xm")) continue;
            result.add(a);
        }
        Main main = Main.getInstance();
        if (main.getEoulsanScriptPath() != null) {
            result.add("-Deoulsan.launch.script.path=" + main.getEoulsanScriptPath());
            result.add("-Deoulsan.path=" + main.getEoulsanDirectory());
        }
        if (main.getClassPath() != null) {
            result.add("-Deoulsan.classpath=" + main.getClassPath());
        }
        return Joiner.on((char)' ').join(result);
    }

    private static void run(File workflowFile, File designFile, String hdfsPath, String jobDescription) {
        File repackagedJarFile;
        Objects.requireNonNull(workflowFile, "paramFile is null");
        Objects.requireNonNull(designFile, "designFile is null");
        Objects.requireNonNull(hdfsPath, "hdfsPath is null");
        Main.getInstance().flushLog();
        System.out.println("Package Eoulsan for hadoop mode...");
        try {
            repackagedJarFile = HadoopJarRepackager.repack();
        }
        catch (IOException e) {
            Common.errorExit(e, "Error while repackaging " + Globals.APP_NAME_LOWER_CASE + ": " + e.getMessage());
            return;
        }
        EoulsanLogger.getLogger().info("Launch Eoulsan in Hadoop mode.");
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("hadoop");
        argsList.add("jar");
        argsList.add(repackagedJarFile.getAbsolutePath());
        Main main = Main.getInstance();
        if (main.getLogLevelArgument() != null) {
            argsList.add("-loglevel");
            argsList.add(main.getLogLevelArgument());
        }
        if (main.getConfigurationFileArgument() != null) {
            argsList.add("-conf");
            argsList.add(main.getConfigurationFileArgument());
        }
        for (String setting : main.getCommandLineSettings()) {
            argsList.add("-s");
            argsList.add(setting);
        }
        argsList.add("execjarhadoop");
        if (jobDescription != null) {
            argsList.add("-d");
            argsList.add(jobDescription.trim());
        }
        argsList.add("-e");
        argsList.add("local hadoop cluster");
        argsList.add(workflowFile.toString());
        argsList.add(designFile.toString());
        argsList.add(hdfsPath);
        System.out.println("Launch Eoulsan in hadoop mode...");
        try {
            ProcessBuilder builder = new ProcessBuilder(argsList).inheritIO();
            builder.environment().put(HADOOP_CLIENT_OPTS_ENV, HadoopExecAction.getJVMArgs());
            int exitCode = builder.start().waitFor();
            System.exit(exitCode);
        }
        catch (IOException | InterruptedException e) {
            Common.errorExit(e, "Error while executing " + Globals.APP_NAME_LOWER_CASE + ": " + e.getMessage());
        }
    }
}

