/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.actions;

import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.Globals;
import fr.ens.biologie.genomique.eoulsan.actions.AbstractAction;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.it.ITFactory;
import fr.ens.biologie.genomique.kenetre.it.ITSuite;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.TestNG;

public class IntegrationTestAction
extends AbstractAction {
    @Override
    public String getName() {
        return "it";
    }

    @Override
    public String getDescription() {
        return "integration test Eoulsan version.";
    }

    @Override
    public void action(List<String> arguments) {
        int argsOptions;
        File testNGReportDirectory;
        Options options;
        block16: {
            options = this.makeOptions();
            GnuParser parser = new GnuParser();
            testNGReportDirectory = null;
            File testOutputDirectory = null;
            argsOptions = 0;
            try {
                CommandLine line = parser.parse(options, arguments.toArray(new String[0]), true);
                if (line.hasOption("help")) {
                    this.help(options);
                }
                if (line.hasOption("testconf")) {
                    String val = line.getOptionValue("testconf").trim();
                    if (!new File(val).exists() || !new File(val).canRead()) {
                        Common.errorExit(null, "Integration test configuration file doesn't exists");
                    }
                    System.setProperty("it.conf.path", val);
                    argsOptions += 2;
                }
                if (line.hasOption("exec")) {
                    System.setProperty("it.application.path", line.getOptionValue("exec").trim());
                    argsOptions += 2;
                }
                if (line.hasOption("f")) {
                    System.setProperty("it.test.list.path", line.getOptionValue("f").trim());
                    argsOptions += 2;
                }
                if (line.hasOption("t")) {
                    System.setProperty("it.test.name", line.getOptionValue("t").trim());
                    argsOptions += 2;
                }
                if (line.hasOption("expected")) {
                    String s = line.getOptionValue("expected").trim();
                    if (s.toLowerCase(Globals.DEFAULT_LOCALE).equals("all")) {
                        System.setProperty("it.generate.all.expected.data", "true");
                    } else if (s.toLowerCase(Globals.DEFAULT_LOCALE).equals("new")) {
                        System.setProperty("it.generate.new.expected.data", "true");
                    }
                    argsOptions += 2;
                }
                if (line.hasOption("d")) {
                    testOutputDirectory = new File(line.getOptionValue("d").trim());
                    System.setProperty("it.output.dir", testOutputDirectory.getAbsolutePath());
                    argsOptions += 2;
                }
                if (!line.hasOption("o")) break block16;
                testNGReportDirectory = new File(line.getOptionValue("o").trim());
                try {
                    FileUtils.checkExistingDirectoryFile((File)testNGReportDirectory, (String)"Output TestNG report");
                }
                catch (IOException e) {
                    throw new ParseException(e.getMessage());
                }
                argsOptions += 2;
            }
            catch (ParseException e) {
                Common.errorExit(e, "Error while parse parameter file: " + e.getMessage());
            }
        }
        if (argsOptions == 0 || arguments.size() != argsOptions) {
            this.help(options);
        }
        this.runIT(testNGReportDirectory);
    }

    private Options makeOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, "display this help");
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"configuration file");
        options.addOption(OptionBuilder.create((String)"testconf"));
        OptionBuilder.withArgName((String)"appliPath");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"application path to launch");
        options.addOption(OptionBuilder.create((String)"exec"));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"optional: files with tests name to launch");
        OptionBuilder.withLongOpt((String)"file");
        options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withArgName((String)"test");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"optional: test name to launch");
        OptionBuilder.withLongOpt((String)"test");
        options.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withArgName((String)"mode");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"optional: mode for generate data expected: all (remove existing) or mode to generate no exists directory new");
        options.addOption(OptionBuilder.create((String)"expected"));
        OptionBuilder.withArgName((String)"outputdir");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"optional: test output directory");
        OptionBuilder.withLongOpt((String)"dir");
        options.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"TestNG report directory");
        options.addOption(OptionBuilder.create((char)'o'));
        return options;
    }

    private void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Globals.APP_NAME_LOWER_CASE + ".sh " + this.getName() + " [options]", options);
        Common.exit(0);
    }

    private void runIT(File testNGReportDirectory) {
        TestListenerAdapter tla = new TestListenerAdapter(){

            public void onTestSuccess(ITestResult tr) {
                super.onTestSuccess(tr);
                System.out.println(tr);
            }

            public void onTestFailure(ITestResult tr) {
                super.onTestFailure(tr);
                System.err.println(tr);
                System.err.println(tr.getThrowable().getMessage());
            }
        };
        TestNG testng = new TestNG();
        try {
            testng.setTestClasses(new Class[]{ITFactory.class});
            testng.addListener((ITestListener)tla);
            if (testNGReportDirectory != null) {
                testng.setOutputDirectory(testNGReportDirectory.getAbsolutePath());
            }
        }
        catch (Throwable e) {
            Common.errorExit(e, "Integration test can not be initialized the test factory.");
        }
        testng.run();
        File reportDirectory = new File(testng.getOutputDirectory());
        File outputTestDirectory = new File(ITSuite.getInstance().getOutputTestDirectoryPath());
        if (reportDirectory.exists() && outputTestDirectory.exists()) {
            File file = new File(outputTestDirectory, reportDirectory.getName());
        }
    }
}

