/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.annotations;

import fr.ens.biologie.genomique.eoulsan.annotations.Generator;
import fr.ens.biologie.genomique.eoulsan.annotations.NoLog;
import fr.ens.biologie.genomique.eoulsan.annotations.NoOutputDirectory;
import fr.ens.biologie.genomique.eoulsan.annotations.RequiresAllPreviousSteps;
import fr.ens.biologie.genomique.eoulsan.annotations.RequiresPreviousStep;
import fr.ens.biologie.genomique.eoulsan.annotations.ReuseModuleInstance;
import fr.ens.biologie.genomique.eoulsan.annotations.Terminal;
import fr.ens.biologie.genomique.eoulsan.core.Module;
import java.lang.annotation.Annotation;
import java.util.Objects;

public class EoulsanAnnotationUtils {
    public static boolean isGenerator(Module module) {
        return EoulsanAnnotationUtils.isAnnotation(module, Generator.class);
    }

    public static boolean isReuseStepInstance(Module module) {
        return EoulsanAnnotationUtils.isAnnotation(module, ReuseModuleInstance.class);
    }

    public static boolean isTerminal(Module module) {
        return EoulsanAnnotationUtils.isAnnotation(module, Terminal.class);
    }

    public static boolean isNoLog(Module module) {
        return EoulsanAnnotationUtils.isAnnotation(module, NoLog.class);
    }

    public static boolean isRequiresPreviousStep(Module module) {
        return EoulsanAnnotationUtils.isAnnotation(module, RequiresPreviousStep.class);
    }

    public static boolean isRequiresAllPreviousSteps(Module module) {
        return EoulsanAnnotationUtils.isAnnotation(module, RequiresAllPreviousSteps.class);
    }

    public static boolean isNoOutputDirectory(Module module) {
        return EoulsanAnnotationUtils.isAnnotation(module, NoOutputDirectory.class);
    }

    private static boolean isAnnotation(Module module, Class<? extends Annotation> clazz) {
        Objects.requireNonNull(module, "module argument cannot be null");
        Objects.requireNonNull(clazz, "clazz argument cannot be null");
        return module.getClass().getAnnotation(clazz) != null;
    }

    private EoulsanAnnotationUtils() {
        throw new IllegalStateException();
    }
}

