/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.bio.io.hadoop;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.mapreduce.lib.input.SplitLineReader;

public class CompressedSplitFastqLineReader
extends SplitLineReader {
    SplitCompressionInputStream scin;
    private boolean usingCRLF;
    private boolean needAdditionalRecord = false;
    private boolean finished = false;
    private boolean cont = false;

    public CompressedSplitFastqLineReader(SplitCompressionInputStream in, Configuration conf, byte[] recordDelimiterBytes) throws IOException {
        super((InputStream)in, conf, recordDelimiterBytes);
        this.scin = in;
        this.usingCRLF = recordDelimiterBytes == null;
    }

    protected int fillBuffer(InputStream in, byte[] buffer, boolean inDelimiter) throws IOException {
        int bytesRead = in.read(buffer);
        if (inDelimiter && bytesRead > 0) {
            this.needAdditionalRecord = this.usingCRLF ? buffer[0] != 10 : true;
        }
        return bytesRead;
    }

    public int readLine(Text str, int maxLineLength, int maxBytesToConsume) throws IOException {
        int bytesRead = 0;
        if (!this.finished) {
            if (this.scin.getPos() > this.scin.getAdjustedEnd() && !this.cont) {
                this.finished = true;
            }
            bytesRead = super.readLine(str, maxLineLength, maxBytesToConsume);
        }
        return bytesRead;
    }

    public boolean needAdditionalRecordAfterSplit() {
        return !this.finished && this.needAdditionalRecord;
    }

    void setContinue(boolean cont) {
        this.cont = cont;
    }
}

