/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.checkers;

import com.google.common.collect.Sets;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.checkers.CheckStore;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.generators.GenomeDescriptionCreator;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.GFFEntry;
import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.bio.GenomicArray;
import fr.ens.biologie.genomique.kenetre.bio.GenomicInterval;
import fr.ens.biologie.genomique.kenetre.bio.io.GFFReader;
import fr.ens.biologie.genomique.kenetre.bio.io.GTFReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GFFChecker
implements Checker {
    private String genomicType;
    private String attributeId;
    private boolean stranded = true;
    private final boolean gtfFormat;

    @Override
    public String getName() {
        return "gff_checker";
    }

    @Override
    public boolean isDesignChecker() {
        return false;
    }

    @Override
    public DataFormat getFormat() {
        return this.gtfFormat ? DataFormats.ANNOTATION_GTF : DataFormats.ANNOTATION_GFF;
    }

    @Override
    public Set<DataFormat> getCheckersRequired() {
        return Sets.newHashSet((Object[])new DataFormat[]{DataFormats.GENOME_FASTA});
    }

    @Override
    public void configure(Set<Parameter> stepParameters) throws EoulsanException {
        for (Parameter p : stepParameters) {
            switch (p.getName()) {
                case "genomic.type": {
                    this.genomicType = p.getStringValue();
                    break;
                }
                case "attribute.id": {
                    this.attributeId = p.getStringValue();
                    break;
                }
                case "stranded": {
                    this.stranded = "yes".equals(p.getStringValue()) || "reverse".equals(p.getStringValue());
                    break;
                }
            }
        }
    }

    @Override
    public boolean check(Data data, CheckStore checkInfo) throws EoulsanException {
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        if (checkInfo == null) {
            throw new NullPointerException("The check info info is null");
        }
        try {
            DataFile featureFile = data.getDataFile();
            if (!featureFile.exists()) {
                InputStream in;
                if (!featureFile.getProtocol().canRead() && (in = featureFile.open()) != null) {
                    in.close();
                }
                return true;
            }
            if (this.genomicType == null) {
                return true;
            }
            GenomeDescription desc = this.getGenomeDescription(featureFile, checkInfo);
            GFFChecker.validationAnnotation(featureFile, this.gtfFormat, desc, this.genomicType, this.attributeId, this.stranded);
        }
        catch (IOException e) {
            throw new EoulsanException("Annotation Check: Error while reading annotation file for checking: " + e.getMessage(), e);
        }
        catch (BadBioEntryException e) {
            throw new EoulsanException("Annotation Check: " + e.getMessage() + " in line \"" + e.getEntry() + "\"", e);
        }
        return false;
    }

    private static void validationAnnotation(DataFile file, boolean gtfFormat, GenomeDescription desc, String featureType, String attributeId, boolean stranded) throws IOException, BadBioEntryException, EoulsanException {
        GenomicArray features = new GenomicArray();
        Map<String, long[]> sequenceRegions = null;
        Map<String, Long> sequenceLengths = GFFChecker.getSequencesLengths(desc);
        boolean featuresFound = false;
        long[] interval = null;
        long sequenceLength = -1L;
        String lastSequenceName = null;
        try (GTFReader gffReader = gtfFormat ? new GTFReader(file.open()) : new GFFReader(file.open());){
            GFFEntry lastEntry = null;
            Iterator iterator = gffReader.iterator();
            while (iterator.hasNext()) {
                GFFEntry e;
                lastEntry = e = (GFFEntry)iterator.next();
                if (!featureType.equals(e.getType())) continue;
                String sequenceName = e.getSeqId();
                int start = e.getStart();
                int end = e.getEnd();
                if (sequenceRegions != null) {
                    if (!sequenceName.equals(lastSequenceName) && (interval = sequenceRegions.get(sequenceName)) == null) {
                        throw new BadBioEntryException("GFF entry with id (" + sequenceName + ") not found in sequence region", GFFChecker.formatEntry(e, gtfFormat));
                    }
                    if ((long)Math.min(start, end) < interval[0]) {
                        throw new BadBioEntryException("GFF entry with start position (" + Math.min(start, end) + ") lower than the start of sequence region" + sequenceName + " (" + interval[0] + ")", GFFChecker.formatEntry(e, gtfFormat));
                    }
                    if ((long)Math.max(start, end) > interval[1]) {
                        throw new BadBioEntryException("GFF entry with end position (" + Math.max(start, end) + ") greater than the end of sequence region " + sequenceName + " (" + interval[1] + ")", GFFChecker.formatEntry(e, gtfFormat));
                    }
                }
                if (sequenceLengths != null) {
                    if (!sequenceName.equals(lastSequenceName)) {
                        if (!sequenceLengths.containsKey(sequenceName)) {
                            throw new BadBioEntryException("GFF entry with id (" + sequenceName + ") not found in genome", GFFChecker.formatEntry(e, gtfFormat));
                        }
                        sequenceLength = sequenceLengths.get(sequenceName);
                    }
                    if (Math.min(start, end) < 1) {
                        throw new BadBioEntryException("GFF entry with start position (" + Math.min(start, end) + ") lower than 1 in sequence " + sequenceName, GFFChecker.formatEntry(e, gtfFormat));
                    }
                    if ((long)(Math.max(start, end) - 1) > sequenceLength) {
                        gffReader.close();
                        throw new BadBioEntryException("GFF entry with end position (" + Math.max(start, end) + ") greater than the the length of sequence " + sequenceName + " (" + sequenceLength + ")", GFFChecker.formatEntry(e, gtfFormat));
                    }
                }
                String featureId = e.getAttributeValue(attributeId);
                if (attributeId != null && featureId == null) {
                    throw new BadBioEntryException("Feature " + featureType + " does not contain a " + attributeId + " attribute", GFFChecker.formatEntry(e, gtfFormat));
                }
                if (featureId != null) {
                    features.addEntry(new GenomicInterval(e, stranded), (Object)featureId);
                    featuresFound = true;
                }
                lastSequenceName = sequenceName;
            }
            gffReader.throwException();
            if (lastEntry != null) {
                sequenceRegions = GFFChecker.checkSequenceRegions(lastEntry, desc);
            }
            if (featureType != null && !featuresFound) {
                throw new EoulsanException("No feature \"" + featureType + "\" with attribute \"" + attributeId + "\" in annotation.");
            }
        }
    }

    private static String formatEntry(GFFEntry e, boolean gtfFormat) {
        if (gtfFormat) {
            return e.toGTF();
        }
        return e.toGFF3();
    }

    private static Map<String, Long> getSequencesLengths(GenomeDescription desc) {
        if (desc == null) {
            return null;
        }
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (String sequenceName : desc.getSequencesNames()) {
            result.put(sequenceName, desc.getSequenceLength(sequenceName));
        }
        return result;
    }

    private static Map<String, long[]> checkSequenceRegions(GFFEntry entry, GenomeDescription desc) throws BadBioEntryException {
        if (entry == null || desc == null) {
            return null;
        }
        HashMap<String, long[]> result = new HashMap<String, long[]>();
        List sequenceRegions = entry.getMetadata().get("sequence-region");
        if (sequenceRegions == null) {
            return null;
        }
        for (String sequenceRegion : sequenceRegions) {
            if (sequenceRegion == null) continue;
            String[] fields = sequenceRegion.trim().split(" ");
            if (fields.length != 3) {
                throw new BadBioEntryException("Invalid GFF metadata", "##sequence-region " + sequenceRegion);
            }
            try {
                String sequenceName = fields[0].trim();
                long start = Integer.parseInt(fields[1]);
                long end = Integer.parseInt(fields[2]);
                result.put(sequenceName, new long[]{start, end});
                long len = desc.getSequenceLength(sequenceName);
                if (len == -1L) {
                    throw new BadBioEntryException("Unknown sequence found in GFF metadata", "##sequence-region " + sequenceRegion);
                }
                if (end <= len + 2L) continue;
                throw new BadBioEntryException("Invalid GFF metadata, the end position (" + end + ") is greater than the length of the sequence (" + (len + 2L) + ")", "##sequence-region " + sequenceRegion);
            }
            catch (NumberFormatException e) {
                throw new BadBioEntryException("Invalid GFF metadata", "##sequence-region " + sequenceRegion);
            }
        }
        return result;
    }

    private GenomeDescription getGenomeDescription(DataFile annotationFile, CheckStore checkInfo) throws EoulsanException, BadBioEntryException, IOException {
        GenomeDescription result = (GenomeDescription)checkInfo.get("genome_description");
        if (result != null) {
            return result;
        }
        result = new GenomeDescriptionCreator().createGenomeDescriptionFromAnnotation(annotationFile);
        return result;
    }

    protected GFFChecker(boolean gtfFormat) {
        this.gtfFormat = gtfFormat;
    }

    public GFFChecker() {
        this(false);
    }
}

