/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.checkers;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.EoulsanLogger;
import fr.ens.biologie.genomique.eoulsan.checkers.CheckStore;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.eoulsan.modules.generators.GenomeDescriptionCreator;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;

public class GenomeChecker
implements Checker {
    public static final String GENOME_DESCRIPTION = "genome_description";

    @Override
    public String getName() {
        return "genome_checker";
    }

    @Override
    public boolean isDesignChecker() {
        return false;
    }

    @Override
    public DataFormat getFormat() {
        return DataFormats.GENOME_FASTA;
    }

    @Override
    public Set<DataFormat> getCheckersRequired() {
        return Collections.emptySet();
    }

    @Override
    public void configure(Set<Parameter> stepParameters) throws EoulsanException {
    }

    @Override
    public boolean check(Data data, CheckStore checkInfo) throws EoulsanException {
        if (data == null) {
            throw new NullPointerException("The data is null");
        }
        if (checkInfo == null) {
            throw new NullPointerException("The check info info is null");
        }
        if (checkInfo.contains(GENOME_DESCRIPTION)) {
            EoulsanLogger.getLogger().info("Genome check has already been done");
            return true;
        }
        DataFile genomeFile = data.getDataFile();
        try {
            if (!genomeFile.exists()) {
                return true;
            }
            new GenomeDescriptionCreator().createGenomeDescription(genomeFile);
        }
        catch (IOException e) {
            throw new EoulsanException("Error while reading genome " + genomeFile.getSource() + " for checking: " + e.getMessage(), e);
        }
        catch (BadBioEntryException e) {
            throw new EoulsanException("Found bad read entry in genome " + genomeFile.getSource() + ": " + e.getMessage(), e);
        }
        return true;
    }
}

