/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.checkers;

import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.checkers.CheckStore;
import fr.ens.biologie.genomique.eoulsan.checkers.Checker;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormats;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.IlluminaReadId;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.io.FastqReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;

public class ReadsChecker
implements Checker {
    public static final int MAX_READS_TO_CHECK = 1000;

    @Override
    public String getName() {
        return "reads_checker";
    }

    @Override
    public boolean isDesignChecker() {
        return false;
    }

    @Override
    public DataFormat getFormat() {
        return DataFormats.READS_FASTQ;
    }

    @Override
    public Set<DataFormat> getCheckersRequired() {
        return Collections.emptySet();
    }

    @Override
    public void configure(Set<Parameter> stepParameters) throws EoulsanException {
    }

    @Override
    public boolean check(Data data, CheckStore checkInfo) throws EoulsanException {
        if (data == null) {
            throw new NullPointerException("The sample is null");
        }
        if (checkInfo == null) {
            throw new NullPointerException("The check info info is null");
        }
        int inFileCount = data.getDataFileCount();
        if (inFileCount < 1) {
            throw new EoulsanException("No reads file found.");
        }
        if (inFileCount > 2) {
            throw new EoulsanException("Cannot handle more than 2 reads files at the same time.");
        }
        FastqFormat format = data.getMetadata().getFastqFormat();
        if (inFileCount == 1) {
            this.checkReadFile(data.getDataFile(0), format);
        }
        if (inFileCount == 2) {
            this.checkReadFile(data.getDataFile(0), format, true, 1);
            this.checkReadFile(data.getDataFile(1), format, true, 2);
        }
        return true;
    }

    private void checkReadFile(DataFile file, FastqFormat format) throws EoulsanException {
        this.checkReadFile(file, format, false, -1);
    }

    private void checkReadFile(DataFile file, FastqFormat format, boolean checkPairMember, int pairMember) throws EoulsanException {
        if (!file.exists()) {
            return;
        }
        try {
            InputStream is = file.open();
            this.checkReadsFile(is, 1000, format, checkPairMember, pairMember);
        }
        catch (IOException e) {
            throw new EoulsanException("Error while reading reads of sample " + file.getSource() + " for checking: " + e.getMessage(), e);
        }
        catch (BadBioEntryException e) {
            throw new EoulsanException("Found bad read entry in sample " + file.getSource() + " (cause: " + e.getMessage() + ") when checking: " + e.getEntry(), e);
        }
    }

    private boolean checkReadsFile(InputStream is, int maxReadToCheck, FastqFormat format, boolean checkPairMember, int pairMember) throws IOException, BadBioEntryException {
        FastqReader reader = new FastqReader(is);
        int count = 0;
        for (ReadSequence read : reader) {
            int invalidChar;
            if (count > maxReadToCheck) break;
            if (checkPairMember && count == 0) {
                int readPairMember;
                block9: {
                    String readId = read.getName();
                    readPairMember = -1;
                    try {
                        int invalidChar2;
                        IlluminaReadId irid = new IlluminaReadId(readId);
                        readPairMember = irid.getPairMember();
                        if (readPairMember != pairMember) {
                            throw new BadBioEntryException("Invalid pair member number, " + pairMember + " was excepted", read.getName());
                        }
                        if (format != null && (invalidChar2 = format.findInvalidChar(read.getQuality())) != -1) {
                            throw new BadBioEntryException("Invalid quality character found for " + format.getName() + " format: " + (char)invalidChar2, read.getQuality());
                        }
                        readPairMember = irid.getPairMember();
                    }
                    catch (KenetreException e) {
                        if (readId.endsWith("/1")) {
                            readPairMember = 1;
                        }
                        if (!readId.endsWith("/2")) break block9;
                        readPairMember = 2;
                    }
                }
                if (readPairMember > 0 && readPairMember != pairMember) {
                    reader.close();
                    throw new BadBioEntryException("Invalid pair member number, " + pairMember + " was excepted", read.getName());
                }
            }
            if (format != null && (invalidChar = format.findInvalidChar(read.getQuality())) != -1) {
                reader.close();
                throw new BadBioEntryException("Invalid quality character found for " + format.getName() + " format: " + (char)invalidChar, read.getQuality());
            }
            ++count;
        }
        reader.throwException();
        reader.close();
        return true;
    }
}

