/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core;

import com.google.common.base.Preconditions;
import fr.ens.biologie.genomique.eoulsan.core.FileNamingParsingRuntimeException;
import fr.ens.biologie.genomique.eoulsan.core.Naming;
import fr.ens.biologie.genomique.eoulsan.data.Data;
import fr.ens.biologie.genomique.eoulsan.data.DataFile;
import fr.ens.biologie.genomique.eoulsan.data.DataFormat;
import fr.ens.biologie.genomique.eoulsan.data.DataFormatRegistry;
import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.io.File;
import java.util.Objects;

public class FileNaming {
    private static final char SEPARATOR = '_';
    private static final String FILE_INDEX_PREFIX = "file";
    private static final String PART_INDEX_PREFIX = "part";
    private String stepId;
    private String portName;
    private String dataName;
    private int sampleNumber = -1;
    private DataFormat format;
    private int fileIndex = -1;
    private int part = -1;
    private CompressionType compression = CompressionType.NONE;

    public String getStepId() {
        return this.stepId;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getDataName() {
        return this.dataName;
    }

    public int getSampleNumber() {
        return this.sampleNumber;
    }

    public DataFormat getFormat() {
        return this.format;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public int getPart() {
        return this.part;
    }

    public CompressionType getCompression() {
        return this.compression;
    }

    public void setStepId(String stepId) {
        FileNaming.checkStepId(stepId);
        this.stepId = stepId;
    }

    public void setPortName(String portName) {
        FileNaming.checkPortName(portName);
        this.portName = portName;
    }

    public void setDataName(String dataName) {
        FileNaming.checkDataName(dataName);
        this.dataName = dataName;
    }

    public void setSampleNumber(int sampleNumber) {
        this.sampleNumber = sampleNumber;
    }

    public void setFormat(DataFormat format) {
        Objects.requireNonNull(format, "format argument cannot be null");
        this.format = format;
    }

    public void setFileIndex(int fileIndex) {
        this.fileIndex = fileIndex < 0 ? -1 : fileIndex;
    }

    public void setPart(int part) {
        this.part = part < 0 ? -1 : part;
    }

    public void setCompression(CompressionType compression) {
        Objects.requireNonNull(compression, "compression argument cannot be null");
        this.compression = compression;
    }

    protected void set(Data data) {
        Objects.requireNonNull(data, "port argument cannot be null");
        this.setDataName(data.getName());
        this.setPart(data.getPart());
    }

    public String filePrefix() {
        Objects.requireNonNull(this.stepId, "stepId has not been set");
        Objects.requireNonNull(this.portName, "portName has not been set");
        Objects.requireNonNull(this.format, "format has not been set");
        return FileNaming.filePrefix(this.stepId, this.portName, this.format.getPrefix());
    }

    public String fileSuffix() {
        Objects.requireNonNull(this.format, "format has not been set");
        Objects.requireNonNull(this.compression, "compression has not been set");
        return FileNaming.fileSuffix(this.format.getDefaultExtension(), this.compression.getExtension());
    }

    public String fileMiddle() {
        Objects.requireNonNull(this.dataName, "datName has not been set");
        this.checkFormatAndFileIndex();
        return FileNaming.fileMiddle(this.dataName, this.fileIndex, this.part);
    }

    public String filename() {
        Objects.requireNonNull(this.stepId, "stepId has not been set");
        Objects.requireNonNull(this.portName, "portName has not been set");
        Objects.requireNonNull(this.format, "format has not been set");
        Objects.requireNonNull(this.dataName, "datName has not been set");
        Objects.requireNonNull(this.compression, "compression has not been set");
        this.checkFormatAndFileIndex();
        return FileNaming.filename(this.stepId, this.portName, this.format, this.dataName, this.fileIndex, this.part, this.compression);
    }

    public String glob() {
        return this.filePrefix() + "*" + this.fileSuffix();
    }

    public String compatibilityFilename() {
        String prefix;
        Objects.requireNonNull(this.stepId, "stepId has not been set");
        Objects.requireNonNull(this.portName, "portName has not been set");
        Objects.requireNonNull(this.format, "format has not been set");
        Objects.requireNonNull(this.dataName, "datName has not been set");
        Objects.requireNonNull(this.compression, "compression has not been set");
        this.checkFormatAndFileIndex();
        StringBuilder sb = new StringBuilder();
        switch (this.stepId) {
            case "filterreads": {
                prefix = "filtered_reads";
                break;
            }
            case "mapreads": {
                prefix = "mapper_results";
                break;
            }
            case "filtersam": 
            case "filterandmap": {
                prefix = "filtered_mapper_results";
                break;
            }
            default: {
                prefix = this.stepId;
            }
        }
        sb.append(prefix);
        sb.append('_');
        if (this.format.isOneFilePerAnalysis()) {
            sb.append('1');
        } else {
            sb.append(this.sampleNumber);
        }
        if (this.fileIndex >= 0) {
            sb.append(StringUtils.toLetter((int)this.fileIndex));
        }
        sb.append(this.format.getDefaultExtension());
        return sb.toString();
    }

    private void checkFormatAndFileIndex() {
        if (this.format.getMaxFilesCount() == 1) {
            Preconditions.checkArgument((this.fileIndex == -1 ? 1 : 0) != 0, (Object)("Invalid fileIndex argument for format " + this.format.getName() + ": " + this.fileIndex));
        } else {
            Preconditions.checkArgument((this.fileIndex < this.format.getMaxFilesCount() ? 1 : 0) != 0, (Object)("Invalid fileIndex argument for format " + this.format.getName() + ": " + this.fileIndex));
        }
    }

    public static String filePrefix(String stepId, String portName, DataFormat format) {
        FileNaming f = new FileNaming();
        f.setStepId(stepId);
        f.setPortName(portName);
        f.setFormat(format);
        return f.filePrefix();
    }

    public static String filePrefix(String stepId, String portName, String formatPrefix) {
        FileNaming.checkStepId(stepId);
        FileNaming.checkPortName(portName);
        FileNaming.checkFormatPrefix(formatPrefix);
        return stepId + "_" + portName + "_" + formatPrefix + "_";
    }

    public static String fileMiddle(String dataName, int fileIndex, int part) {
        FileNaming.checkDataName(dataName);
        StringBuilder sb = new StringBuilder();
        sb.append(dataName);
        if (fileIndex >= 0) {
            sb.append('_');
            sb.append(FILE_INDEX_PREFIX);
            sb.append(fileIndex);
        }
        if (part > -1) {
            sb.append('_');
            sb.append(PART_INDEX_PREFIX);
            sb.append(part);
        }
        return sb.toString();
    }

    public static String fileSuffix(DataFormat format, CompressionType compression) {
        FileNaming f = new FileNaming();
        f.setFormat(format);
        f.setCompression(compression);
        return f.fileSuffix();
    }

    public static String fileSuffix(String extension, String compression) {
        FileNaming.checkExtension(extension);
        FileNaming.checkCompression(compression);
        StringBuilder sb = new StringBuilder();
        sb.append(extension);
        if (compression != null) {
            sb.append(compression);
        }
        return sb.toString();
    }

    public static String filename(String stepId, String portName, DataFormat format, String dataName, int fileIndex, int part, CompressionType compression) {
        return FileNaming.filePrefix(stepId, portName, format) + FileNaming.fileMiddle(dataName, fileIndex, part) + FileNaming.fileSuffix(format, compression);
    }

    public static FileNaming parse(File file) {
        Objects.requireNonNull(file, "file argument cannot be null");
        return FileNaming.parse(file.getName());
    }

    public static FileNaming parse(DataFile file) {
        Objects.requireNonNull(file, "file argument cannot be null");
        return FileNaming.parse(file.getName());
    }

    public static FileNaming parse(String filename) {
        String[] fields;
        Objects.requireNonNull(filename, "filename argument cannot be null");
        FileNaming result = new FileNaming();
        String[] extensions = filename.split("\\.");
        if (extensions.length < 2 || extensions.length > 3) {
            throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
        }
        String formatExtension = "." + extensions[1];
        if (extensions.length == 3) {
            result.setCompression(CompressionType.getCompressionTypeByExtension((String)("." + extensions[2])));
        }
        if ((fields = extensions[0].split("_")).length < 4) {
            throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
        }
        if (fields[0].isEmpty() || !FileNaming.isStepIdValid(fields[0])) {
            throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
        }
        result.setStepId(fields[0]);
        if (fields[1].isEmpty() || !FileNaming.isPortNameValid(fields[1])) {
            throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
        }
        result.setPortName(fields[1]);
        DataFormat format = DataFormatRegistry.getInstance().getDataFormatFromFilename(fields[2], formatExtension);
        if (format == null) {
            throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
        }
        result.setFormat(format);
        if (fields[3].isEmpty() || !FileNaming.isDataNameValid(fields[3])) {
            throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
        }
        result.setDataName(fields[3]);
        for (int i = 4; i < fields.length; ++i) {
            if (fields[i].startsWith(FILE_INDEX_PREFIX)) {
                if (result.getFileIndex() != -1) {
                    throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
                }
                try {
                    result.setFileIndex(Integer.parseInt(fields[i].substring(FILE_INDEX_PREFIX.length())));
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
                }
            }
            if (!fields[i].startsWith(PART_INDEX_PREFIX)) continue;
            if (result.getPart() != -1) {
                throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
            }
            try {
                result.setPart(Integer.parseInt(fields[i].substring(PART_INDEX_PREFIX.length())));
                continue;
            }
            catch (NumberFormatException e) {
                throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
            }
        }
        if (result.getFormat().getMaxFilesCount() > 1 && result.getFileIndex() == -1) {
            throw new FileNamingParsingRuntimeException("Invalid filename: " + filename);
        }
        return result;
    }

    public static boolean isStepIdValid(String stepId) {
        return FileNaming.isNameValid(stepId);
    }

    public static boolean isFormatPrefixValid(String formatPrefix) {
        return FileNaming.isNameValid(formatPrefix);
    }

    public static boolean isPortNameValid(String portName) {
        return FileNaming.isNameValid(portName);
    }

    public static boolean isDataNameValid(String dataName) {
        return FileNaming.isNameValid(dataName);
    }

    private static boolean isNameValid(String name) {
        return name != null && !name.isEmpty() && Naming.ASCII_LETTER_OR_DIGIT.matchesAllOf((CharSequence)name);
    }

    public static boolean isFilenameValid(DataFile file) {
        Objects.requireNonNull(file, "file argument cannot be null");
        return FileNaming.isFilenameValid(file.getName());
    }

    public static boolean isFilenameValid(File file) {
        Objects.requireNonNull(file, "file argument cannot be null");
        return FileNaming.isFilenameValid(file.getName());
    }

    public static boolean isFilenameValid(String filename) {
        try {
            FileNaming.parse(filename);
        }
        catch (FileNamingParsingRuntimeException e) {
            return false;
        }
        return true;
    }

    public static boolean dataEquals(File file1, File file2) {
        Objects.requireNonNull(file1, "file1 argument cannot be null");
        Objects.requireNonNull(file2, "file2 argument cannot be null");
        return FileNaming.dataEquals(file1.getName(), file2.getName());
    }

    public static boolean dataEquals(DataFile file1, DataFile file2) {
        Objects.requireNonNull(file1, "file1 argument cannot be null");
        Objects.requireNonNull(file2, "file2 argument cannot be null");
        return FileNaming.dataEquals(file1.getName(), file2.getName());
    }

    public static boolean dataEquals(String filename1, String filename2) {
        FileNaming fn2;
        FileNaming fn1;
        Objects.requireNonNull(filename1, "filename1 argument cannot be null");
        Objects.requireNonNull(filename2, "filename2 argument cannot be null");
        try {
            fn1 = FileNaming.parse(filename1);
            fn2 = FileNaming.parse(filename2);
        }
        catch (FileNamingParsingRuntimeException e) {
            return false;
        }
        return Objects.equals(fn1.stepId, fn2.stepId) && Objects.equals(fn1.portName, fn2.portName) && Objects.equals(fn1.format, fn2.format) && Objects.equals(fn1.dataName, fn2.dataName) && Objects.equals(fn1.part, fn2.part);
    }

    private static void checkStepId(String stepId) {
        Objects.requireNonNull(stepId, "stepId argument cannot be null");
        Preconditions.checkArgument((!stepId.isEmpty() ? 1 : 0) != 0, (Object)"stepId is empty");
        Preconditions.checkArgument((boolean)FileNaming.isStepIdValid(stepId), (Object)("The step id of the file name can only contains letters or digit: " + stepId));
    }

    private static void checkPortName(String portName) {
        Objects.requireNonNull(portName, "portName argument cannot be null");
        Preconditions.checkArgument((!portName.isEmpty() ? 1 : 0) != 0, (Object)"portName argument is empty");
        Preconditions.checkArgument((boolean)FileNaming.isPortNameValid(portName), (Object)("The port name of the file name can only contains letters or digit: " + portName));
    }

    private static void checkFormatPrefix(String formatPrefix) {
        Objects.requireNonNull(formatPrefix, "formatPrefix argument cannot be null");
        Preconditions.checkArgument((!formatPrefix.isEmpty() ? 1 : 0) != 0, (Object)"formatPrefix is empty");
        Preconditions.checkArgument((boolean)FileNaming.isFormatPrefixValid(formatPrefix), (Object)("The format prefix of the file name can only contains letters or digit: " + formatPrefix));
    }

    private static void checkDataName(String dataName) {
        Objects.requireNonNull(dataName, "dataName argument cannot be null");
        Preconditions.checkArgument((!dataName.isEmpty() ? 1 : 0) != 0, (Object)"dataName is empty");
        Preconditions.checkArgument((boolean)FileNaming.isFormatPrefixValid(dataName), (Object)("The data name of the file name can only contains letters or digit: " + dataName));
    }

    private static void checkExtension(String extension) {
        Objects.requireNonNull(extension, "extension argument cannot be null");
        Preconditions.checkArgument((!extension.isEmpty() ? 1 : 0) != 0, (Object)"A part of the file name is empty");
        Preconditions.checkArgument((extension.charAt(0) == '.' ? 1 : 0) != 0, (Object)("The extension do not starts with a dot: " + extension));
        Preconditions.checkArgument((boolean)Naming.ASCII_LETTER_OR_DIGIT.matchesAllOf((CharSequence)extension.substring(1)), (Object)("The extension of the file name can only contains letters or digit: " + extension));
    }

    private static void checkCompression(String compression) {
        Objects.requireNonNull(compression, "compression argument cannot be null");
        if (compression.isEmpty()) {
            return;
        }
        Preconditions.checkArgument((compression.charAt(0) == '.' ? 1 : 0) != 0, (Object)("The compression do not starts with a dot: " + compression));
        Preconditions.checkArgument((boolean)Naming.ASCII_LETTER_OR_DIGIT.matchesAllOf((CharSequence)compression.substring(1)), (Object)("The compression of the file name can only contains letters or digit: " + compression));
    }

    protected FileNaming() {
    }
}

