/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.eoulsan.core;

import fr.ens.biologie.genomique.eoulsan.Common;
import fr.ens.biologie.genomique.eoulsan.EoulsanException;
import fr.ens.biologie.genomique.eoulsan.core.Parameter;
import fr.ens.biologie.genomique.eoulsan.core.StepConfigurationContext;
import java.util.Objects;
import java.util.Set;

public class Modules {
    public static void deprecatedParameter(StepConfigurationContext context, Parameter parameter) {
        try {
            Modules.deprecatedParameter(context, parameter, false);
        }
        catch (EoulsanException eoulsanException) {
            // empty catch block
        }
    }

    public static void deprecatedParameter(StepConfigurationContext context, Parameter parameter, boolean throwException) throws EoulsanException {
        Objects.requireNonNull(context, "context argument cannot be null");
        Modules.deprecatedParameter(context.getCurrentStep().getId(), parameter, throwException);
    }

    public static void deprecatedParameter(String stepId, Parameter parameter, boolean throwException) throws EoulsanException {
        Objects.requireNonNull(stepId, "stepId argument cannot be null");
        Objects.requireNonNull(parameter, "parameter argument cannot be null");
        String message = "The parameter \"" + parameter.getName() + "\" in the \"" + stepId + "\" step is now deprecated";
        if (throwException) {
            throw new EoulsanException(message);
        }
        Common.printWarning(message);
    }

    public static void renamedParameter(StepConfigurationContext context, Parameter parameter, String newParameterName) {
        try {
            Modules.renamedParameter(context, parameter, newParameterName, false);
        }
        catch (EoulsanException eoulsanException) {
            // empty catch block
        }
    }

    public static void renamedParameter(StepConfigurationContext context, Parameter parameter, String newParameterName, boolean throwException) throws EoulsanException {
        Objects.requireNonNull(context, "context argument cannot be null");
        Modules.renamedParameter(context.getCurrentStep().getId(), parameter, newParameterName, throwException);
    }

    public static void renamedParameter(String stepId, Parameter parameter, String newParameterName, boolean throwException) throws EoulsanException {
        Objects.requireNonNull(stepId, "stepId argument cannot be null");
        Objects.requireNonNull(parameter, "parameter argument cannot be null");
        Objects.requireNonNull(newParameterName, "newName argument cannot be null");
        String message = "The parameter \"" + parameter.getName() + "\" in the \"" + stepId + "\" step is now deprecated. Please use the \"" + newParameterName + "\" parameter instead";
        if (throwException) {
            throw new EoulsanException(message);
        }
        Common.printWarning(message);
    }

    public static void removedParameter(StepConfigurationContext context, Parameter parameter) throws EoulsanException {
        Objects.requireNonNull(context, "context argument cannot be null");
        Modules.removedParameter(context.getCurrentStep().getId(), parameter);
    }

    public static void removedParameter(String stepId, Parameter parameter) throws EoulsanException {
        Objects.requireNonNull(stepId, "context argument cannot be null");
        Objects.requireNonNull(parameter, "parameter argument cannot be null");
        throw new EoulsanException("The parameter \"" + parameter.getName() + "\" in the \"" + stepId + "\" step no more exists");
    }

    public static void unknownParameter(StepConfigurationContext context, Parameter parameter) throws EoulsanException {
        Objects.requireNonNull(context, "context argument cannot be null");
        Modules.unknownParameter(context.getCurrentStep().getId(), parameter);
    }

    public static void unknownParameter(String stepId, Parameter parameter) throws EoulsanException {
        Objects.requireNonNull(stepId, "context argument cannot be null");
        Objects.requireNonNull(parameter, "parameter argument cannot be null");
        throw new EoulsanException("Unknown \"" + parameter.getName() + "\" parameter for the \"" + stepId + "\" step");
    }

    public static void badParameterValue(StepConfigurationContext context, Parameter parameter, String message) throws EoulsanException {
        Objects.requireNonNull(context, "context argument cannot be null");
        Modules.badParameterValue(context.getCurrentStep().getId(), parameter, message);
    }

    public static void badParameterValue(String stepId, Parameter parameter, String message) throws EoulsanException {
        Objects.requireNonNull(stepId, "context argument cannot be null");
        Objects.requireNonNull(parameter, "parameter argument cannot be null");
        Objects.requireNonNull(message, "message argument cannot be null");
        throw new EoulsanException("The invalid value (" + parameter.getValue() + ") for \"" + parameter.getName() + "\" parameter in the \"" + stepId + "\" step: " + message);
    }

    public static void invalidConfiguration(StepConfigurationContext context, String message) throws EoulsanException {
        Objects.requireNonNull(context, "context argument cannot be null");
        Modules.invalidConfiguration(context.getCurrentStep().getId(), message);
    }

    public static void invalidConfiguration(String stepId, String message) throws EoulsanException {
        Objects.requireNonNull(stepId, "stepId argument cannot be null");
        Objects.requireNonNull(message, "message argument cannot be null");
        throw new EoulsanException("The invalid configuration for the \"" + stepId + "\" step: " + message);
    }

    public static Parameter getParameter(Set<Parameter> parameters, String parameterName) {
        Objects.requireNonNull(parameters, "parameters argument cannot be null");
        Objects.requireNonNull(parameterName, "parameterName argument cannot be null");
        Parameter result = null;
        for (Parameter p : parameters) {
            if (!parameterName.equals(p.getName())) continue;
            result = p;
        }
        return result;
    }

    public static boolean containsParameter(Set<Parameter> parameters, String parameterName) {
        Objects.requireNonNull(parameters, "parameters argument cannot be null");
        Objects.requireNonNull(parameterName, "parameterName argument cannot be null");
        for (Parameter p : parameters) {
            if (!parameterName.equals(p.getName())) continue;
            return true;
        }
        return false;
    }

    private Modules() {
    }
}

